/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.activation.FileTypeMap;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.FileConceptDefinition;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;

public class FileConcept
extends JavaConcept {
    protected String _fileUrl = null;
    protected File _file = null;
    public AttributeConcept url = new AttributeConcept("url", "url", new NilConcept());
    public AttributeConcept length = new AttributeConcept("length", "length", new NilConcept());
    public AttributeConcept contentType = new AttributeConcept("contentType", "contentType", new NilConcept());
    public ElementConcept content = new ElementConcept("content", "content", new NilConcept(), null);

    public FileConcept create(StringConcept url) {
        this.initialize(url.toString());
        return this;
    }

    public ConceptDefinition getConceptDefinition() {
        return FileConceptDefinition.getReference();
    }

    public LogicalConcept exists() {
        return new LogicalConcept(this._file.exists());
    }

    public LogicalConcept delete() {
        return new LogicalConcept(this._file.delete());
    }

    public LogicalConcept canRead() {
        return new LogicalConcept(this._file.canRead());
    }

    public LogicalConcept canWrite() {
        return new LogicalConcept(this._file.canWrite());
    }

    public LogicalConcept isFile() {
        return new LogicalConcept(this._file.isFile());
    }

    public LogicalConcept mkdir() {
        return new LogicalConcept(this._file.mkdirs());
    }

    public LogicalConcept isHidden() {
        if (this._file != null) {
            return new LogicalConcept(this._file.isHidden());
        }
        return new LogicalConcept(false);
    }

    public LogicalConcept setReadOnly() {
        return new LogicalConcept(this._file.setReadOnly());
    }

    public LogicalConcept rename(StringConcept dest) {
        if (!this._file.renameTo(new File(dest.toString()))) {
            return new LogicalConcept(false);
        }
        this.initialize(dest.toString());
        return new LogicalConcept(true);
    }

    public SeriesConcept getLinks() {
        File[] files = this._file.listFiles();
        SeriesConcept result = new SeriesConcept();
        if (files != null) {
            File tmpFile = null;
            int i = 0;
            while (i < files.length) {
                tmpFile = files[i];
                try {
                    result.add(new StringConcept(tmpFile.toURL().toString()));
                }
                catch (MalformedURLException ex) {
                    result.add(new StringConcept(tmpFile.toString()));
                }
                ++i;
            }
        }
        return result;
    }

    public Concept getContent() {
        this.readContent();
        return this.content.getElementValue();
    }

    public LogicalConcept setContent(Concept value) {
        this.content.setElementValue(value.toTXT());
        return this.writeContent();
    }

    /*
     * WARNING - void declaration
     */
    protected LogicalConcept readContent() {
        if (this._file != null && this._file.exists() && this._file.isFile()) {
            StringBuffer buffer = new StringBuffer();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this._file));
                try {
                    int character;
                    while ((character = reader.read()) != -1) {
                        void var3_5;
                        buffer.append((char)var3_5);
                    }
                }
                catch (IOException ex) {
                    new ErrorConcept("error", "fileOperationFailed", ex.getMessage());
                    return new LogicalConcept(false);
                }
            }
            catch (FileNotFoundException fnfex) {
            }
            catch (Exception ex) {
                new ErrorConcept("error", "fileOperationFailed", ex.getMessage());
                return new LogicalConcept(false);
            }
            this.content.setElementValue(new StringConcept(buffer.toString()));
        } else if (this._file != null && !this._file.isFile()) {
            this.content.setElementValue(new StringConcept());
        }
        return new LogicalConcept(true);
    }

    /*
     * Loose catch block
     */
    protected LogicalConcept writeContent() {
        block13: {
            block12: {
                if (this._file != null && !this._file.exists()) {
                    try {
                        this._file.createNewFile();
                    }
                    catch (IOException ioex) {
                        new ErrorConcept("error", "fileOperationFailed", ioex.getMessage());
                    }
                }
                if (this._file == null || !this._file.canWrite()) break block12;
                FileWriter writter = null;
                writter = new FileWriter(this._file);
                char[] contentChars = this.content.getElementValue().toTXT().toString().toCharArray();
                writter.write(contentChars, 0, contentChars.length);
                writter.flush();
                Object var3_5 = null;
                try {
                    writter.close();
                }
                catch (IOException ioex) {
                    new ErrorConcept("error", "fileOperationFailed", ioex.getMessage());
                }
                break block13;
                {
                    catch (IOException ex) {
                        new ErrorConcept("error", "fileOperationFailed", ex.getMessage());
                        LogicalConcept logicalConcept = new LogicalConcept(false);
                        Object var3_6 = null;
                        try {
                            writter.close();
                        }
                        catch (IOException ioex) {
                            new ErrorConcept("error", "fileOperationFailed", ioex.getMessage());
                        }
                        return logicalConcept;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    try {
                        writter.close();
                    }
                    catch (IOException ioex) {
                        new ErrorConcept("error", "fileOperationFailed", ioex.getMessage());
                    }
                    throw throwable;
                }
            }
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public Object clone() {
        return this;
    }

    private final void initialize(String url) {
        URL givenURL = null;
        try {
            givenURL = new URL(url);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (givenURL == null || givenURL.getProtocol().toLowerCase().equals("file")) {
            this._file = givenURL != null ? new File(givenURL.getPath()) : new File(url);
            this._fileUrl = url;
            try {
                this.url.setAttributeValue(new StringConcept(this._file.toURL().toString()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.length.setAttributeValue(new IntegerConcept(this._file.length()));
            this.contentType.setAttributeValue(new StringConcept(FileTypeMap.getDefaultFileTypeMap().getContentType(this._file)));
        }
        this._fileUrl = url;
    }

    public FileConcept() {
        this._file = new File("");
        try {
            this._fileUrl = this._file.toURL().toString();
        }
        catch (MalformedURLException me) {
            this._fileUrl = this._file.toString();
        }
        this.initialize(this._fileUrl);
    }

    public FileConcept(String url) {
        this.initialize(url);
    }
}

