/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.ExpressionConcept;
import org.media.mn8.concepts.FileConcept;
import org.media.mn8.concepts.FileHandlerDefinition;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandler;
import org.media.mn8.concepts.URIHandlerDefinition;

public class FileHandler
extends URIHandler {
    private String _url = null;
    private boolean _overwrite = true;
    private FileConcept _file = null;
    private int _requests = 1;
    private int _depth = 0;
    private ExpressionConcept _filter;
    private MapConcept _options;

    public URIHandler create(StringConcept url) {
        this._url = url.toString();
        return this;
    }

    public LogicalConcept acceptsURI(StringConcept uri) {
        return ((URIHandlerDefinition)this.getConceptDefinition()).acceptsURI(uri);
    }

    public LogicalConcept initialize(MapConcept options) {
        this._options = options;
        if (options.containsKey(new StringConcept("action")).getValue()) {
            String action = options.getValue(new StringConcept("action")).toTXT().toString();
            this._overwrite = !action.toLowerCase().equals("append");
        }
        if (options.containsKey(new StringConcept("requests")).getValue()) {
            String requests = options.getValue(new StringConcept("requests")).toTXT().toString();
            this._requests = new Integer(requests);
        }
        if (options.containsKey(new StringConcept("filter")).getValue()) {
            this._filter = (ExpressionConcept)options.getValue(new StringConcept("filter"));
        }
        if (options.containsKey(new StringConcept("depth")).getValue()) {
            String depth = options.getValue(new StringConcept("depth")).toTXT().toString();
            this._depth = new Integer(depth);
        }
        if (this._depth > 0 && this._requests == 1) {
            this._requests = Integer.MAX_VALUE;
        }
        if (this._requests > 1 && this._depth == 0) {
            this._depth = Integer.MAX_VALUE;
        }
        return new LogicalConcept(true);
    }

    public LogicalConcept openConnection() {
        this._file = new FileConcept(this._url);
        if (this._file != null) {
            if (!this._overwrite) {
                this._file.readContent();
            }
            return new LogicalConcept(true);
        }
        return new LogicalConcept(false);
    }

    public Concept getContent() {
        FileConcept tmpFile;
        this._file.readContent();
        if (this._requests == 1 && this._depth == 0) {
            return this._file;
        }
        Vector<FileConcept> result = new Vector<FileConcept>();
        result.add(this._file);
        SeriesConcept links = null;
        links = this._file.getLinks();
        if (links.getVector().size() == 0) {
            return new SeriesConcept(result);
        }
        --this._depth;
        int cnt = 1;
        Vector tmpVector = links.getVector();
        int i = 0;
        while (i < tmpVector.size()) {
            if (this._filter == null || this._filter.matches((StringConcept)tmpVector.elementAt(i)).getValue()) {
                tmpFile = new FileConcept(((StringConcept)tmpVector.elementAt(i)).toString());
                tmpFile.readContent();
                result.add(tmpFile);
            }
            ++i;
        }
        while (this._depth > 0 && cnt <= this._requests) {
            cnt += (tmpVector = this.getDeepLinks(tmpVector, cnt)).size() == 0 ? 1 : tmpVector.size();
            i = 0;
            while (i < tmpVector.size()) {
                if (this._filter == null || this._filter.matches((StringConcept)tmpVector.elementAt(i)).getValue()) {
                    tmpFile = new FileConcept(((StringConcept)tmpVector.elementAt(i)).toString());
                    tmpFile.readContent();
                    result.add(tmpFile);
                }
                ++i;
            }
            --this._depth;
        }
        return new SeriesConcept(result);
    }

    protected Vector getDeepLinks(Vector links, int cnt) {
        Vector result = new Vector();
        int i = 0;
        while (i < links.size()) {
            if (cnt >= this._requests) {
                return result;
            }
            StringConcept uri = (StringConcept)links.elementAt(i);
            FileConcept tmpFile = new FileConcept(uri.toString());
            if (!tmpFile.isFile().getValue()) {
                result.addAll(tmpFile.getLinks().getVector());
            }
            ++cnt;
            ++i;
        }
        return result;
    }

    public LogicalConcept setContent(Concept value) {
        if (this._overwrite) {
            this._file.content.setElementValue(value.toTXT());
        } else {
            this._file.content.setElementValue(new StringConcept(this._file.content.getElementValue().toTXT().toString() + value.toTXT().toString()));
        }
        return this._file.writeContent();
    }

    public LogicalConcept closeConnection() {
        return new LogicalConcept(true);
    }

    public ConceptDefinition getConceptDefinition() {
        return FileHandlerDefinition.getReference();
    }

    public Object clone() {
        if (this._url != null) {
            return new FileHandler(new StringConcept(this._url));
        }
        return new URIHandler();
    }

    public FileHandler() {
    }

    public FileHandler(StringConcept url) {
        this._url = url.toString();
    }
}

