/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.FileHandler;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandlerDefinition;
import org.media.mn8.mn8JavaMethod;

public class FileHandlerDefinition
extends URIHandlerDefinition {
    private static SeriesConcept _inheritedConcepts = new SeriesConcept("Concept");
    private static FileHandlerDefinition _fileReference = new FileHandlerDefinition();

    public LogicalConcept acceptsURI(StringConcept uri) {
        try {
            URL url = new File(uri.toString()).toURL();
            if (url.getProtocol().equalsIgnoreCase("file")) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
        catch (MalformedURLException malformedURLException) {
            return new LogicalConcept(false);
        }
    }

    public static ConceptDefinition getReference() {
        return _fileReference;
    }

    public Concept getConceptInstance() {
        return new FileHandler();
    }

    public StringConcept getConceptLabel() {
        return new StringConcept("FileHandler");
    }

    public StringConcept getConceptType() {
        return new StringConcept("FileHandler");
    }

    public SeriesConcept getInheritedConcepts() {
        return _inheritedConcepts;
    }

    protected FileHandlerDefinition() {
        try {
            _inheritedConcepts.add(new StringConcept("URIHandler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.FileHandler", "initialize:org.media.mn8.concepts.MapConcept", "initialize:Map", "FileHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.FileHandler", "closeConnection:", "closeConnection:", "FileHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.FileHandler", "create:org.media.mn8.concepts.StringConcept", "create:String", "FileHandler", "Concept"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.FileHandler", "getContent:", "getContent:", "FileHandler", "Concept"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.FileHandler", "setContent:org.media.mn8.Concept", "setContent:Concept", "FileHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.FileHandler", "create:org.media.mn8.concepts.StringConcept", "create:String", "FileHandler", "FileHandler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.FileHandlerDefinition", true, "acceptsURI:org.media.mn8.concepts.StringConcept", "acceptsURI:String", "FileHandler", "Logical"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

