/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptConceptDefinition;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.Helper;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.ExpressionConcept;
import org.media.mn8.concepts.FileConcept;
import org.media.mn8.concepts.HTMLFormDefinition;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8RuntimeFlags;
import org.media.mn8.protocol.http.DefaultControl;
import org.media.mn8.protocol.http.DomainNameFilter;
import org.media.mn8.protocol.http.Form;
import org.media.mn8.protocol.http.InputControl;

public class HTMLFormConcept
extends MapConcept {
    public static String FORM_DB = Helper.getUserHome().getValue() + ".mn8" + File.separatorChar + "http" + File.separatorChar + "forms" + File.separatorChar;
    private Form _form = null;
    public AttributeConcept id = new AttributeConcept("id", "id", new StringConcept());
    public AttributeConcept url = new AttributeConcept("url", "url", new StringConcept());
    public AttributeConcept method = new AttributeConcept("method", "method", new StringConcept("GET"));
    public AttributeConcept name = new AttributeConcept("name", "name", new StringConcept());
    public AttributeConcept target = new AttributeConcept("target", "target", new StringConcept());
    public AttributeConcept encoding = new AttributeConcept("encoding", "encoding", new StringConcept());

    public void setURL(StringConcept url) {
        this._form.setAction(url.toString());
        this.setForm();
    }

    public StringConcept getAsEncodedURL() {
        StringBuffer result = new StringBuffer();
        result.append(this.url.getValue().toString());
        if (!this.name.getValue().toString().equals("")) {
            result.append("?name=");
            result.append(URLEncoder.encode(this.name.getValue().toString()));
        }
        int i = 0;
        while (i < this._keys.size()) {
            if (i == 0 && result.toString().indexOf("?") == -1) {
                result.append("?");
                result.append(((Concept)this._keys.elementAt(i)).toTXT().toString());
                result.append("=");
                result.append(URLEncoder.encode(((Concept)this._values.elementAt(i)).toTXT().toString()));
            } else {
                result.append("&");
                result.append(((Concept)this._keys.elementAt(i)).toTXT().toString());
                result.append("=");
                result.append(URLEncoder.encode(((Concept)this._values.elementAt(i)).toTXT().toString()));
            }
            ++i;
        }
        return new StringConcept(result.toString());
    }

    public void setMethod(StringConcept method) {
        this._form.setMethod(method.toString());
        this.setForm();
    }

    public void setName(StringConcept name) {
        this._form.setName(name.toString());
        this.setForm();
    }

    public void setTarget(StringConcept target) {
        this._form.setTarget(target.toString());
        this.setForm();
    }

    public void setEncoding(StringConcept enc) {
        this._form.setEncoding(enc.toString());
        this.setForm();
    }

    public String getID() {
        return ((StringConcept)this.id.getValue()).getValue();
    }

    public Object clone() {
        return this;
    }

    public ConceptDefinition getConceptDefinition() {
        return HTMLFormDefinition.getReference();
    }

    private final void setForm(Form form) {
        if (form != null) {
            this._form = form;
            this.setForm();
            this.id.setAttributeValue(new StringConcept("" + this._form.toXMLString().hashCode()));
            this.addControls();
        }
    }

    private final void setForm() {
        this.url.setAttributeValue(new StringConcept(this._form.getAction()));
        this.method.setAttributeValue(new StringConcept(this._form.getMethod()));
        this.name.setAttributeValue(new StringConcept(this._form.getName()));
        this.target.setAttributeValue(new StringConcept(this._form.getTarget()));
        this.encoding.setAttributeValue(new StringConcept(this._form.getEncoding()));
    }

    private final void addControls() {
        Enumeration e = this._form.getControls().elements();
        while (e.hasMoreElements()) {
            Enumeration e1;
            DefaultControl _control = (DefaultControl)e.nextElement();
            if (_control.isSendable() && _control.getControlType().equalsIgnoreCase("INPUT") && ((InputControl)_control).getType().equalsIgnoreCase("file")) {
                e1 = _control.getValues().elements();
                while (e1.hasMoreElements()) {
                    this.add(new StringConcept(_control.getName()), new FileConcept((String)e1.nextElement()));
                }
                continue;
            }
            if (!_control.isSendable()) continue;
            e1 = _control.getValues().elements();
            while (e1.hasMoreElements()) {
                this.add(new StringConcept(_control.getName()), new StringConcept((String)e1.nextElement()));
            }
        }
    }

    public static Concept fromXML(StringConcept content) {
        return ((ConceptConceptDefinition)HTMLFormDefinition.getReference()).fromXML(content);
    }

    public void loadContent(Concept from) {
        if (from == null) {
            return;
        }
        if (mn8RuntimeFlags.isDebug()) {
            System.err.println("--> in concept:" + Helper.getConceptInfo(this) + "->" + Helper.getConceptInfo(from));
        }
        Helper.loadAttributes(from, this);
        Vector elementes = from.getConceptElements().getVector();
        ElementConcept elem = null;
        int i = 0;
        while (i < elementes.size()) {
            elem = (ElementConcept)elementes.elementAt(i);
            StringConcept name = new StringConcept(elem.getName().toString());
            this.add(name, new StringConcept(elem.getValue().toString()));
            ++i;
        }
    }

    public void storeForm() {
        String domain = HTMLFormConcept.getHost((StringConcept)this.url.getValue());
        if (this._form == null) {
            return;
        }
        String fName = FORM_DB + File.separator + domain;
        if (!new File(FORM_DB).exists()) {
            new File(FORM_DB).mkdirs();
        }
        int formNr = this.getFormNr(FORM_DB, domain);
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fName + "[" + formNr + "].xml")));
            writer.println(this.toXML());
            writer.close();
        }
        catch (Exception e) {
            new ErrorConcept("error", "storeFormURL", "Error durring when save XML: " + e.getMessage());
        }
    }

    private final int getFormNr(String dest, String domain) {
        int nr = 1;
        String fName = dest + File.separator + domain;
        while (new File(fName + "[" + nr + "].xml").exists()) {
            ++nr;
        }
        return nr;
    }

    public static SeriesConcept getStoredForms(StringConcept durl) {
        SeriesConcept ser = new SeriesConcept();
        if (!new File(FORM_DB).exists()) {
            return ser;
        }
        File[] formFiles = new File(FORM_DB).listFiles(new DomainNameFilter(HTMLFormConcept.getHost(durl)));
        int i = 0;
        while (i < formFiles.length) {
            FileConcept file = new FileConcept(FORM_DB + formFiles[i].getName());
            HTMLFormConcept con = (HTMLFormConcept)HTMLFormConcept.fromXML((StringConcept)file.getContent());
            AttributeConcept url_attr = (AttributeConcept)con.getConceptAttribute(new StringConcept("url"));
            StringConcept url_str = (StringConcept)url_attr.getValue();
            if (HTMLFormConcept.getHost(durl).equals(HTMLFormConcept.getHost(url_str)) && HTMLFormConcept.getPath(durl).equals(HTMLFormConcept.getPath(url_str))) {
                ser.add(con);
            }
            ++i;
        }
        return ser;
    }

    public static SeriesConcept getStoredForms(ExpressionConcept expr) {
        SeriesConcept ser = new SeriesConcept();
        if (!new File(FORM_DB).exists()) {
            return ser;
        }
        File[] formFiles = new File(FORM_DB).listFiles();
        int i = 0;
        while (i < formFiles.length) {
            FileConcept file = new FileConcept(FORM_DB + formFiles[i].getName());
            HTMLFormConcept con = (HTMLFormConcept)HTMLFormConcept.fromXML((StringConcept)file.getContent());
            AttributeConcept url_attr = (AttributeConcept)con.getConceptAttribute(new StringConcept("url"));
            StringConcept url_str = (StringConcept)url_attr.getValue();
            if (expr.matches(url_str).getValue()) {
                ser.add(con);
            }
            ++i;
        }
        return ser;
    }

    private static final String getPath(StringConcept durl) {
        String _path = "";
        try {
            URL _url = new URL(durl.getValue());
            _path = _url.getPath();
        }
        catch (Exception e) {
            new ErrorConcept("error", "getStoredFormsURL", e.getMessage());
        }
        return _path;
    }

    private static final String getHost(StringConcept durl) {
        String _host = "";
        try {
            URL _url = new URL(durl.getValue());
            _host = _url.getHost();
        }
        catch (Exception e) {
            new ErrorConcept("error", "getStoredFormsURL", e.getMessage());
        }
        return _host;
    }

    public HTMLFormConcept() {
        this._form = new Form(null, null);
    }

    public HTMLFormConcept(Form form) {
        this.setForm(form);
    }
}

