/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.CookieConcept;
import org.media.mn8.concepts.CookieDefinition;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.FileConcept;
import org.media.mn8.concepts.HTMLFormConcept;
import org.media.mn8.concepts.HTMLPageConceptDefinition;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8RuntimeFlags;
import org.media.mn8.protocol.http.FormExtractor;
import org.media.mn8.protocol.http.LinkExtractor;
import org.media.mn8.protocol.http.TagExtractor;
import org.media.mn8.protocol.http.TagStriper;
import org.media.mn8.protocol.http.URIExtractor;

public class HTMLPageConcept
extends JavaConcept {
    private URL _url = null;
    private StringConcept _content = null;
    private MapConcept _headers = null;
    private SeriesConcept _cookies = new SeriesConcept();
    private int resp_code = 0;
    private String resp_msg = "";
    public AttributeConcept url = new AttributeConcept("url", "url", new StringConcept());
    public AttributeConcept length = new AttributeConcept("length", "length", new IntegerConcept(-1L));
    public AttributeConcept contentType = new AttributeConcept("contentType", "contentType", new StringConcept());
    public AttributeConcept lastModified = new AttributeConcept("lastModified", "lastModified", new IntegerConcept(-1L));
    public AttributeConcept title = new AttributeConcept("titile", "title", new StringConcept());
    public ElementConcept content = new ElementConcept("content", "content", new NilConcept(), null);

    public HTMLPageConcept create(StringConcept url) {
        this.initialize(url.toString());
        return this;
    }

    public HTMLPageConcept create(HTMLFormConcept form) {
        this.initialize(form);
        return this;
    }

    public boolean initialize(String url) {
        URL givenURL = null;
        try {
            givenURL = new URL(url);
            if (givenURL != null) {
                this._url = givenURL;
                this.url.setAttributeValue(new StringConcept(givenURL.toString()));
                this.getConnection();
                this.getContent();
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return false;
        }
        return true;
    }

    public boolean initialize(HTMLFormConcept form) {
        URL givenURL = null;
        String _myURL = form.url.getValue().toString() + "?";
        String method = form.method.getValue().toString();
        if (method.equalsIgnoreCase("get")) {
            Enumeration e = form.getKeyVector().elements();
            while (e.hasMoreElements()) {
                StringConcept _key = (StringConcept)e.nextElement();
                StringConcept _value = null;
                if (form.getValue(_key) instanceof StringConcept) {
                    _value = (StringConcept)form.getValue(_key);
                }
                if (_value == null || _value.toString().trim().length() <= 0) continue;
                _myURL = _myURL + _key.toString() + "=" + URLEncoder.encode(_value.toString()) + "&";
            }
        }
        if (_myURL.trim().endsWith("&") || _myURL.trim().endsWith("?")) {
            _myURL = _myURL.substring(0, _myURL.length() - 1);
        }
        try {
            givenURL = new URL(_myURL);
            if (givenURL != null) {
                this._url = givenURL;
                this.url.setAttributeValue(new StringConcept(givenURL.toString()));
                if (method.equalsIgnoreCase("get")) {
                    this.getConnection();
                } else {
                    this.getPostConnection(form);
                }
                this.getContent();
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final URLConnection getPostConnection(HTMLFormConcept form) throws Exception {
        void ex;
        String encType = form.encoding.getValue().toString();
        if (encType == null || encType.trim().length() < 1) {
            encType = "application/x-www-form-urlencoded";
        }
        URLConnection connection = this._url.openConnection();
        if (this._url.getProtocol().equalsIgnoreCase("http")) {
            HttpURLConnection httpcon = (HttpURLConnection)connection;
            httpcon.setRequestMethod(form.method.getValue().toString().toUpperCase());
            httpcon.setDoInput(true);
            httpcon.setDoOutput(true);
            httpcon.setUseCaches(false);
            httpcon.setRequestProperty("Connection", "Keep-Alive");
            httpcon.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows 98; DigExt)");
            httpcon.setRequestProperty("Accept-Language", "en-us");
            httpcon.setRequestProperty("Content-Type", encType);
            httpcon.setAllowUserInteraction(false);
            String cookiesString = ((CookieDefinition)CookieDefinition.getReference()).getCookieString(new StringConcept(this._url.toString())).toString();
            if (cookiesString != null) {
                httpcon.setRequestProperty("Cookie", cookiesString.trim());
            }
            String content = "";
            Enumeration e = form.getKeyVector().elements();
            while (e.hasMoreElements()) {
                StringConcept _key = (StringConcept)e.nextElement();
                String _value = null;
                if (form.getValue(_key) instanceof StringConcept) {
                    _value = ((StringConcept)form.getValue(_key)).toString();
                }
                if (form.getValue(_key) instanceof FileConcept) {
                    _value = ((StringConcept)((FileConcept)form.getValue((Concept)_key)).url.getValue()).toString().substring(5);
                }
                if (_value == null || _value.trim().length() <= 0) continue;
                content = content + _key.toString() + "=" + URLEncoder.encode(_value) + "&";
            }
            DataOutputStream out = new DataOutputStream(httpcon.getOutputStream());
            out.writeBytes(content.length() > 0 ? content.substring(0, content.length() - 1) : "");
            out.flush();
            out.close();
            this.loadHeaders(httpcon);
            connection = httpcon;
        } else {
            connection.setUseCaches(false);
            connection.setRequestProperty("Connection", "Keep-Alive");
        }
        this.contentType.setAttributeValue(new StringConcept(connection.getContentType()));
        this.length.setAttributeValue(new IntegerConcept(connection.getContentLength()));
        this.lastModified.setAttributeValue(new IntegerConcept(connection.getLastModified()));
        return ex;
    }

    /*
     * WARNING - void declaration
     */
    private final URLConnection getConnection() throws Exception {
        void ex;
        URLConnection connection = this._url.openConnection();
        if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
            System.err.println("http:connecting to: " + this._url.toString());
        }
        if (this._url.getProtocol().equalsIgnoreCase("http")) {
            HttpURLConnection httpcon = (HttpURLConnection)connection;
            httpcon.setDoInput(true);
            httpcon.setUseCaches(false);
            httpcon.setRequestProperty("Connection", "Keep-Alive");
            httpcon.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows 98; DigExt)");
            httpcon.setRequestProperty("Accept-Language", "en-us");
            httpcon.setAllowUserInteraction(false);
            String cookiesString = ((CookieDefinition)CookieDefinition.getReference()).getCookieString(new StringConcept(this._url.toString())).toString();
            if (cookiesString != null) {
                httpcon.setRequestProperty("Cookie", cookiesString.trim());
            }
            if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                System.err.println("http:sent cookie: " + cookiesString);
            }
            if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                System.err.println("http:" + httpcon.getResponseCode() + ":" + httpcon.getResponseMessage());
            }
            httpcon.connect();
            if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                System.err.println("http:" + httpcon.getResponseCode() + ":" + httpcon.getResponseMessage());
            }
            this.loadHeaders(httpcon);
            connection = httpcon;
        } else {
            connection.setUseCaches(false);
            connection.setRequestProperty("Connection", "Keep-Alive");
        }
        this.contentType.setAttributeValue(new StringConcept(connection.getContentType()));
        this.length.setAttributeValue(new IntegerConcept(connection.getContentLength()));
        this.lastModified.setAttributeValue(new IntegerConcept(connection.getLastModified()));
        return ex;
    }

    public StringConcept getContent() {
        if (this._content == null) {
            this._content = new StringConcept(this.getPageContent());
            this.content.setElementValue(this._content);
        }
        return this._content;
    }

    public SeriesConcept getURIs() {
        String cType = this.contentType.getAttributeValue().toString();
        if (cType == null || !cType.trim().equalsIgnoreCase("text/html")) {
            return new SeriesConcept();
        }
        URIExtractor extractor = new URIExtractor();
        extractor.baseURL = this._url;
        return new SeriesConcept(extractor.getURIs(this.getContent().toString()));
    }

    public SeriesConcept getForms() {
        String cType = this.contentType.getAttributeValue().toString();
        if (cType == null || !cType.trim().equalsIgnoreCase("text/html")) {
            return new SeriesConcept();
        }
        FormExtractor extractor = new FormExtractor();
        extractor.baseURL = this._url;
        return new SeriesConcept(extractor.getForms(this.getContent().toString()));
    }

    public SeriesConcept getLinks() {
        String cType = this.contentType.getAttributeValue().toString();
        if (cType == null || !cType.trim().equalsIgnoreCase("text/html")) {
            return new SeriesConcept();
        }
        LinkExtractor extractor = new LinkExtractor();
        extractor.baseURL = this._url;
        return new SeriesConcept(extractor.getLinks(this.getContent().toString()));
    }

    public SeriesConcept getTags() {
        TagExtractor extractor = new TagExtractor(null, false);
        return new SeriesConcept(extractor.parsePage(this.getContent().toString()));
    }

    public SeriesConcept getTagsWithText() {
        TagExtractor extractor = new TagExtractor(null, true);
        return new SeriesConcept(extractor.parsePage(this.getContent().toString()));
    }

    public SeriesConcept getCookies() {
        return this._cookies;
    }

    public MapConcept getHeaders() {
        if (this._headers == null) {
            return new MapConcept();
        }
        return this._headers;
    }

    public Object clone() {
        return this;
    }

    public ConceptDefinition getConceptDefinition() {
        return HTMLPageConceptDefinition.getReference();
    }

    public StringConcept toTXT() {
        return new StringConcept(TagStriper.strip_tags(this.getPageContent(), true));
    }

    public StringConcept getResponseMessage() {
        return new StringConcept(this.resp_msg);
    }

    public IntegerConcept getResponseCode() {
        return new IntegerConcept(this.resp_code);
    }

    public static void setFollowRedirects(LogicalConcept bol) {
        HttpURLConnection.setFollowRedirects(bol.getValue());
    }

    public static LogicalConcept isFollowRedirects() {
        boolean bol = HttpURLConnection.getFollowRedirects();
        return new LogicalConcept(bol);
    }

    /*
     * WARNING - void declaration
     */
    private final String getPageContent() {
        StringBuffer buffer = new StringBuffer();
        try {
            if (this._url == null) {
                return "";
            }
            URLConnection connection = this.getConnection();
            if (connection == null) {
                return "";
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            try {
                int character;
                while ((character = reader.read()) != -1) {
                    void var4_5;
                    buffer.append((char)var4_5);
                }
            }
            catch (IOException ex) {
                new ErrorConcept("error", "httpOperationFailed", ex.getMessage());
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "httpOperationFailed", ex.getMessage());
        }
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void loadHeaders(HttpURLConnection connection) {
        try {
            String key;
            this._headers = new MapConcept();
            int i = 1;
            this.resp_code = connection.getResponseCode();
            this.resp_msg = connection.getResponseMessage();
            while ((key = ((URLConnection)connection).getHeaderFieldKey(i)) != null) {
                void var3_4;
                this._headers.add(new StringConcept((String)var3_4), new StringConcept(((URLConnection)connection).getHeaderField(i)));
                if (var3_4.equalsIgnoreCase("set-cookie") || var3_4.equalsIgnoreCase("set-cookie2")) {
                    CookieConcept cookie = new CookieConcept(new StringConcept(((URLConnection)connection).getHeaderField(i)), new StringConcept(connection.getURL().getHost()));
                    this._cookies.add(cookie);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "httpOperationFailed", ex.getMessage());
        }
    }

    public HTMLPageConcept() {
    }

    public HTMLPageConcept(String url) {
        this.initialize(url);
    }

    public HTMLPageConcept(HTMLFormConcept form) {
        this.initialize(form);
    }
}

