/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.IntegerDefinition;
import org.media.mn8.concepts.RealConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;

public class IntegerConcept
extends RealConcept {
    protected long _value = 0L;

    public void fromIntegerConcept(long value) {
        this._value = value;
    }

    public Concept create(StringConcept value) {
        return this.fromString(value);
    }

    public IntegerConcept fromString(StringConcept value) {
        this._value = new Long(value.toString());
        return this;
    }

    public IntegerConcept opIntegerINC() {
        ++this._value;
        return new IntegerConcept(this._value);
    }

    public IntegerConcept opIntegerDEC() {
        --this._value;
        return new IntegerConcept(this._value);
    }

    public IntegerConcept opPlus(IntegerConcept value) {
        return new IntegerConcept(this._value + value.getLong());
    }

    public IntegerConcept opMinus(IntegerConcept value) {
        return new IntegerConcept(this._value - value.getLong());
    }

    public IntegerConcept opSTAR(IntegerConcept value) {
        return new IntegerConcept(this._value * value.getLong());
    }

    public Concept abs() {
        return new IntegerConcept(Math.abs(this.getLong()));
    }

    public Concept max(IntegerConcept value) {
        return new IntegerConcept(Math.max(this.getLong(), value.getLong()));
    }

    public Concept min(IntegerConcept value) {
        return new IntegerConcept(Math.min(this.getLong(), value.getLong()));
    }

    public StringConcept toStringConcept() {
        return new StringConcept("" + this._value);
    }

    public StringConcept toTXT() {
        return this.toStringConcept();
    }

    public StringConcept toXML() {
        return this.toStringConcept();
    }

    public long getLong() {
        return this._value;
    }

    public int getInt() {
        return (int)this._value;
    }

    public float getFloat() {
        return this._value;
    }

    public void setValue(long value) {
        this._value = value;
    }

    public boolean equals(Object obj) {
        return obj instanceof IntegerConcept && ((IntegerConcept)obj).getLong() == this._value;
    }

    public ConceptDefinition getConceptDefinition() {
        return IntegerDefinition.getReference();
    }

    public void main(SeriesConcept param) {
        System.out.println(this._value);
    }

    public Object clone() {
        return new IntegerConcept(this.getLong());
    }

    public IntegerConcept() {
    }

    public IntegerConcept(long value) {
        this._value = value;
    }

    public IntegerConcept(String value) {
        this.fromString(new StringConcept(value));
    }
}

