/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.IOException;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.DateDefinition;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.JabberClientDefinition;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.TypedSeries;
import org.media.mn8.mn8ScriptMethod;
import org.media.mn8.protocol.http.TagStriper;
import org.media.mn8.protocol.jabber.JabberDataBlock;
import org.media.mn8.protocol.jabber.JabberListener;
import org.media.mn8.protocol.jabber.JabberStream;
import org.media.mn8.protocol.jabber.datablocks.Iq;
import org.media.mn8.protocol.jabber.datablocks.Login;
import org.media.mn8.protocol.jabber.datablocks.Message;
import org.media.mn8.protocol.jabber.datablocks.Presence;
import org.media.mn8.protocol.jabber.seConnector;

public class JabberClientConcept
extends JavaConcept
implements JabberListener {
    private static final String JABBER_RESOURCE = "MN8-Client";
    private static final int RECONNECT_NR = 5;
    private static final int WAIT_SEC = 10;
    private JabberStream jabberStream = null;
    private boolean connectionOpen;
    private String jabberServerName;
    private int jabberServerPort;
    private String jabberUserID;
    private String jabberPasswd;
    private mn8ScriptMethod _method = null;
    private Concept _concept = new NilConcept();
    private TypedSeries item = new TypedSeries("item", "item");
    public ElementConcept response = new ElementConcept("response", "response", this.item, null);

    public JabberClientConcept create(StringConcept host, IntegerConcept port) {
        this.jabberServerName = host.getValue();
        this.jabberServerPort = port.getInt();
        return this;
    }

    public void login(StringConcept user, StringConcept pwd) {
        this.jabberUserID = user.getValue();
        this.jabberPasswd = pwd.getValue();
        this.connectToJabberServer();
    }

    public void send(StringConcept to, StringConcept message, StringConcept html) {
        this.send(to.getValue().trim(), message.getValue().trim(), html.getValue().trim(), true);
    }

    public void send(StringConcept to, StringConcept message) {
        String stripedMessage = TagStriper.strip_tags(message.getValue().trim(), false);
        this.send(to.getValue().trim(), stripedMessage, "<body>" + message.getValue().trim() + "</body>", !stripedMessage.equals(message.getValue().trim()));
    }

    public void addHandler(Concept concept, StringConcept methodName) {
        this._method = (mn8ScriptMethod)concept.getConceptMethod(new StringConcept(methodName.toString() + ":JabberClient,Element"));
        this._concept = concept;
    }

    public ConceptDefinition getConceptDefinition() {
        return JabberClientDefinition.getReference();
    }

    public Object clone() {
        return this;
    }

    public synchronized void connectToJabberServer() {
        this.connectionOpen = false;
        if (this.jabberStream != null) {
            this.jabberStream.close();
        }
        this.jabberStream = null;
        try {
            seConnector connector = new seConnector(this.jabberServerName, this.jabberServerPort);
            this.jabberStream = new JabberStream(connector);
            this.jabberStream.setJabberListener(this);
        }
        catch (Exception e) {
            new ErrorConcept("error", "connectionFalied", e.getMessage());
        }
    }

    public void beginConversation() {
        try {
            Login login = new Login(this.jabberUserID, this.jabberPasswd, JABBER_RESOURCE);
            this.jabberStream.send(login);
        }
        catch (Exception e) {
            new ErrorConcept("error", "connectionFalied", e.getMessage());
        }
    }

    public void blockArrived(JabberDataBlock data) {
        try {
            String result;
            if (data instanceof Iq && (result = data.getAttribute("type")).equals("result")) {
                this.sendPresence();
                this.connectionOpen = true;
            }
            if (data instanceof Message) {
                Message message = (Message)data;
                SeriesConcept param = new SeriesConcept();
                ElementConcept ec = new ElementConcept("item", "item", new StringConcept(message.getBody()), null);
                ec.addAttribute(new AttributeConcept("timestamp", "timestamp", ((DateDefinition)DateDefinition.getReference()).getToday()));
                ec.addAttribute(new AttributeConcept("fromId", "from", new StringConcept(message.getAttribute("from"))));
                this.item.add(ec);
                if (this._method != null) {
                    param.add(this);
                    param.add(ec);
                    this._method.invoke(this._concept, param);
                }
            }
        }
        catch (Exception e) {
            new ErrorConcept("error", "connectionFailed", e.getMessage());
        }
    }

    public void connectionTerminated(Exception e) {
        this.connectToJabberServer();
    }

    private final void sendPresence() throws IOException {
        Presence pres = new Presence();
        this.jabberStream.send(pres);
    }

    private final void send(String to, String text, String html, boolean isHTML) {
        block10: {
            if (to.length() == 0) {
                new ErrorConcept("warning", "recipientMissing", "No recipient has been specified");
            }
            if (text.length() == 0) {
                new ErrorConcept("warning", "messageMissing", "No message text has been specified");
            }
            int reconnectNr = 5;
            while (!this.connectionOpen && reconnectNr > 0) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.connectionOpen) {
                    this.connectToJabberServer();
                }
                --reconnectNr;
            }
            if (!this.connectionOpen) {
                new ErrorConcept("error", "connectionFailed", "Jabber Server unavailable");
            }
            try {
                Message outMessage = new Message(to, text);
                if (isHTML) {
                    outMessage.setHTMLBodyText(html);
                }
                this.jabberStream.send(outMessage);
            }
            catch (Exception e) {
                if (this.jabberStream == null) break block10;
                this.jabberStream.close();
                this.jabberStream = null;
            }
        }
    }
}

