/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.Locale;
import org.media.mn8.Concept;
import org.media.mn8.ConceptConceptDefinition;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.LocaleConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8JavaMethod;

public class LocaleDefinition
extends ConceptConceptDefinition {
    private static SeriesConcept _inheritedConcepts = new SeriesConcept("Concept");
    private static LocaleDefinition _reference = new LocaleDefinition();
    private static SeriesConcept _availableLocales = null;
    private static SeriesConcept _isoCountries = null;
    private static SeriesConcept _isoLanguages = null;

    public static ConceptDefinition getReference() {
        return _reference;
    }

    public static LocaleConcept getDefault() {
        return new LocaleConcept(Locale.getDefault());
    }

    public static void setDefault(LocaleConcept value) {
        if (value != null && value.getValue() != null) {
            Locale.setDefault(value.getValue());
        }
    }

    public static SeriesConcept getAvailableLocales() {
        if (_availableLocales != null) {
            return _availableLocales;
        }
        SeriesConcept result = new SeriesConcept();
        Locale[] locales = Locale.getAvailableLocales();
        if (locales != null) {
            int i = 0;
            while (i < locales.length) {
                result.add(new LocaleConcept(locales[i]));
                ++i;
            }
        }
        _availableLocales = result;
        return result;
    }

    public static SeriesConcept getISOCountries() {
        if (_isoCountries != null) {
            return _isoCountries;
        }
        SeriesConcept result = new SeriesConcept();
        String[] countries = Locale.getISOCountries();
        if (countries != null) {
            int i = 0;
            while (i < countries.length) {
                result.add(new StringConcept(countries[i]));
                ++i;
            }
        }
        _isoCountries = result;
        return result;
    }

    public static SeriesConcept getISOLanguages() {
        if (_isoLanguages != null) {
            return _isoLanguages;
        }
        SeriesConcept result = new SeriesConcept();
        String[] languages = Locale.getISOLanguages();
        if (languages != null) {
            int i = 0;
            while (i < languages.length) {
                result.add(new StringConcept(languages[i]));
                ++i;
            }
        }
        _isoLanguages = result;
        return result;
    }

    public Concept getConceptInstance() {
        return LocaleDefinition.getDefault();
    }

    public StringConcept getConceptLabel() {
        return new StringConcept("Locale");
    }

    public StringConcept getConceptType() {
        return new StringConcept("Locale");
    }

    public SeriesConcept getInheritedConcepts() {
        return _inheritedConcepts;
    }

    private LocaleDefinition() {
        try {
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "create:", "create:", "Locale", "Locale"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "create:org.media.mn8.concepts.StringConcept,org.media.mn8.concepts.StringConcept", "create:String,String", "Locale", "Locale"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "create:org.media.mn8.concepts.StringConcept,org.media.mn8.concepts.StringConcept,org.media.mn8.concepts.StringConcept", "create:String,String,String", "Locale", "Locale"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleDefinition", true, "getDefault:", "getDefault:", "Locale", "Locale"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleDefinition", true, "getAvailableLocales:", "getAvailableLocales:", "Locale", "Series"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleDefinition", true, "getISOCountries:", "getISOCountries:", "Locale", "Series"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleDefinition", true, "getISOLanguages:", "getISOLanguages:", "Locale", "Series"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleDefinition", true, "setDefault:org.media.mn8.concepts.LocaleConcept", "setDefault:Locale:", "Locale", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getCountry:", "getCountry:", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getLanguage:", "getLanguage:", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getVariant:", "getVariant:", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getDisplayCountry:", "getDisplayCountry:", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getDisplayName:", "getDisplayName:", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getDisplayLanguage:", "getDisplayLanguage:", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getDisplayVariant:", "getDisplayVariant:", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getDisplayCountry:org.media.mn8.concepts.LocaleConcept", "getDisplayCountry:Locale", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getDisplayName:org.media.mn8.concepts.LocaleConcept", "getDisplayName:Locale", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getDisplayLanguage:org.media.mn8.concepts.LocaleConcept", "getDisplayLanguage:Locale", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getDisplayVariant:org.media.mn8.concepts.LocaleConcept", "getDisplayVariant:Locale", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getISO3Language:", "getISO3Language:", "Locale", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.LocaleConcept", "getISO3Country:", "getISO3Country:", "Locale", "String"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

