/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.DummyFieldConcept;
import org.media.mn8.FieldDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.Map;
import org.media.mn8.concepts.MapDefinition;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.event.mn8IndexOutOfBoundsException;

public class MapConcept
extends JavaConcept
implements Map {
    protected Vector _keys = new Vector();
    protected Vector _values = new Vector();
    protected Vector _nameCache = new Vector();
    protected IntegerConcept _index = new IntegerConcept(0L);
    protected IntegerConcept _length = new IntegerConcept(0L);
    protected LogicalConcept _hasNext = new LogicalConcept(false);
    protected LogicalConcept _hasPrevious = new LogicalConcept(false);
    public AttributeConcept length = new AttributeConcept("length", "length", this._length);
    public AttributeConcept index = new AttributeConcept("index", "index", this._index);
    public AttributeConcept hasNext = new AttributeConcept("hasNext", "hasNext", this._hasNext);
    public AttributeConcept hasPrevious = new AttributeConcept("hasPrevious", "hasPrevious", this._hasPrevious);

    public void add(Concept key, Concept newValue) {
        this._keys.add(key);
        this._values.add(newValue);
        this._length.setValue(this._keys.size());
        this._nameCache.add(key.toTXT().getValue());
        this.updateNavigationFans();
    }

    public void remove(Concept key) {
        int ind = this._keys.indexOf(key);
        if (ind != -1) {
            this._keys.remove(ind);
            this._values.remove(ind);
            this._nameCache.remove(ind);
            this.updateNavigationFans();
        }
    }

    public Concept nextValue() {
        if (this._hasNext.getValue()) {
            this._index.opIntegerINC();
            Concept result = (Concept)this._values.get(this._index.getInt() - 1);
            this.updateNavigationFans();
            return result;
        }
        return new NilConcept();
    }

    public Concept nextKey() {
        if (this._hasNext.getValue()) {
            this._index.opIntegerINC();
            Concept result = (Concept)this._keys.get(this._index.getInt() - 1);
            this.updateNavigationFans();
            return result;
        }
        return new NilConcept();
    }

    public void clear() {
        this._keys.clear();
        this._values.clear();
        this.updateNameCache();
        this.updateNavigationFans();
    }

    public Concept getValue(Concept key) {
        if (this._keys.contains(key)) {
            return (Concept)this._values.elementAt(this._keys.indexOf(key));
        }
        return new NilConcept();
    }

    public Concept currentKey() {
        if (this._index.getLong() >= 1L && this._index.getLong() <= (long)this._keys.size()) {
            Concept result = (Concept)this._keys.get(this._index.getInt() - 1);
            return result;
        }
        return new NilConcept();
    }

    public Concept previousKey() {
        if (this._hasPrevious.getValue()) {
            this._index.opIntegerDEC();
            Concept result = (Concept)this._keys.get(this._index.getInt() - 1);
            this.updateNavigationFans();
            return result;
        }
        return new NilConcept();
    }

    public void insert(Concept newKey, Concept newValue) {
        this.insert(new IntegerConcept(this._index.getInt() + 1), newKey, newValue);
    }

    public void insert(IntegerConcept position, Concept newKey, Concept newValue) {
        try {
            this._keys.add(position.getInt() - 1, newKey);
            this._values.add(position.getInt() - 1, newValue);
            this._nameCache.add(position.getInt() - 1, newKey.toTXT().getValue());
            this._length.setValue(this._keys.size());
            this.updateNavigationFans();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new mn8IndexOutOfBoundsException(position.toString());
        }
    }

    public LogicalConcept containsKey(Concept key) {
        return new LogicalConcept(this._keys.contains(key));
    }

    public LogicalConcept containsValue(Concept value) {
        return new LogicalConcept(this._values.contains(value));
    }

    public IntegerConcept indexOfKey(Concept key) {
        int idx = this._keys.indexOf(key);
        if (idx == -1) {
            return new IntegerConcept(idx);
        }
        return new IntegerConcept(idx + 1);
    }

    public IntegerConcept indexOfValue(Concept value) {
        int idx = this._values.indexOf(value);
        if (idx == -1) {
            return new IntegerConcept(idx);
        }
        return new IntegerConcept(idx + 1);
    }

    public void sort(Concept sorter) {
    }

    public SeriesConcept getKeys() {
        return new SeriesConcept(this._keys);
    }

    public SeriesConcept getValues() {
        return new SeriesConcept(this._values);
    }

    public Vector getKeyVector() {
        return this._keys;
    }

    public Vector getValuesVector() {
        return this._values;
    }

    public void setVectors(Vector keys, Vector contents) {
        this._values = contents;
        this._keys = keys;
        this._length.setValue(this._keys.size());
        this.updateNameCache();
        this.updateNavigationFans();
    }

    public ConceptDefinition getConceptDefinition() {
        return MapDefinition.getReference();
    }

    public boolean hasNext() {
        return this._hasNext.getValue();
    }

    public boolean hasPrevious() {
        return this._hasPrevious.getValue();
    }

    public Concept getKeyAt(IntegerConcept position) {
        return (Concept)this._keys.elementAt(position.getInt() - 1);
    }

    public Concept getValueAt(IntegerConcept position) {
        return (Concept)this._values.elementAt(position.getInt() - 1);
    }

    public int getLength() {
        return this._length.getInt();
    }

    public int getIndex() {
        return this._index.getInt();
    }

    public void setIndex(int idx) {
        this._index.setValue(idx);
        this.updateNavigationFans();
    }

    public void setIndex(IntegerConcept idx) {
        this.setIndex(idx.getInt());
    }

    protected void updateNameCache() {
        this._nameCache.clear();
        int i = 0;
        while (i < this._keys.size()) {
            this._nameCache.add(((Concept)this._keys.elementAt(i)).toTXT().getValue());
            ++i;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof MapConcept && ((MapConcept)obj).getKeyVector().equals(this._keys) && ((MapConcept)obj).getValuesVector().equals(this._values);
    }

    protected void updateNavigationFans() {
        if (this._keys.size() - this._index.getInt() > 0) {
            this._hasNext.setValue(true);
        } else {
            this._hasNext.setValue(false);
            this._index.setValue(this._keys.size());
        }
        if (this._index.getInt() >= 1) {
            if (this._index.getInt() > 1) {
                this._hasPrevious.setValue(true);
            } else {
                this._hasPrevious.setValue(false);
            }
        } else {
            this._hasPrevious.setValue(false);
            this._index.setValue(0L);
        }
        this._length.setValue(this._keys.size());
    }

    public Concept getConceptElement(StringConcept name) {
        try {
            Concept result = super.getConceptElement(name);
            if (result != null) {
                return result;
            }
            if (this._keys.indexOf(name) == -1) {
                return new NilConcept();
            }
            int i = this._keys.indexOf(name);
            return new ElementConcept(((Concept)this._keys.elementAt(i)).toTXT().toString(), ((Concept)this._keys.elementAt(i)).toTXT().toString(), (Concept)this._values.elementAt(i), null);
        }
        catch (Exception exception) {
            return new NilConcept();
        }
    }

    public boolean hasConceptElement(String name) {
        boolean result = super.hasConceptElement(name.toString());
        if (result) {
            return result;
        }
        return this._keys.indexOf(new StringConcept(name)) != -1;
    }

    public SeriesConcept getConceptElementFields() {
        SeriesConcept result = super.getConceptElementFields();
        int i = 0;
        while (i < this._keys.size()) {
            result.add(new DummyFieldConcept(((Concept)this._keys.elementAt(i)).toTXT().toString(), new ElementConcept(((Concept)this._keys.elementAt(i)).toTXT().toString(), ((Concept)this._keys.elementAt(i)).toTXT().toString(), (Concept)this._values.elementAt(i), null), false, ((Concept)this._keys.elementAt(i)).toTXT().toString(), ((Concept)this._keys.elementAt(i)).getConceptType().toString()));
            ++i;
        }
        return result;
    }

    public FieldDefinition getConceptElementField(String elementName) {
        try {
            FieldDefinition result = super.getConceptElementField(elementName);
            if (result != null) {
                return result;
            }
            if (this._keys.indexOf(new StringConcept(elementName)) == -1) {
                return null;
            }
            int i = this._keys.indexOf(new StringConcept(elementName));
            return new DummyFieldConcept(((Concept)this._keys.elementAt(i)).toTXT().toString(), new ElementConcept(((Concept)this._keys.elementAt(i)).toTXT().toString(), ((Concept)this._keys.elementAt(i)).toTXT().toString(), (Concept)this._values.elementAt(i), null), false, ((Concept)this._keys.elementAt(i)).toTXT().toString(), ((Concept)this._keys.elementAt(i)).getConceptType().toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public SeriesConcept getConceptElements() {
        SeriesConcept result = new SeriesConcept();
        int i = 0;
        while (i < this._keys.size()) {
            result.add(new ElementConcept(((Concept)this._keys.elementAt(i)).toTXT().toString(), ((Concept)this._keys.elementAt(i)).toTXT().toString(), (Concept)this._values.elementAt(i), null));
            ++i;
        }
        return result;
    }

    public Object clone() {
        return new MapConcept((Vector)this._keys.clone(), (Vector)this._values.clone());
    }

    public MapConcept() {
        LogicalConcept true_value = new LogicalConcept(true);
        this.length.setHidden(true_value);
        this.index.setHidden(true_value);
        this.hasPrevious.setHidden(true_value);
        this.hasNext.setHidden(true_value);
    }

    public MapConcept(Vector keys, Vector values) {
        this._values = values;
        this._keys = keys;
        this._length.setValue(keys.size());
        this.updateNameCache();
        this.updateNavigationFans();
    }
}

