/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.net.MalformedURLException;
import java.net.URL;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MemHandler;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandlerDefinition;
import org.media.mn8.mn8JavaMethod;

public class MemHandlerDefinition
extends URIHandlerDefinition {
    private static SeriesConcept _inheritedConcepts = new SeriesConcept("Concept");
    private static MemHandlerDefinition _memReference = new MemHandlerDefinition();

    public LogicalConcept acceptsURI(StringConcept uri) {
        try {
            URL url = new URL(uri.toString());
            if (url.getProtocol().equalsIgnoreCase("mem")) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
        catch (MalformedURLException ex) {
            if (uri.toString().toLowerCase().startsWith("mem:")) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
    }

    public static ConceptDefinition getReference() {
        return _memReference;
    }

    public Concept getConceptInstance() {
        return new MemHandler();
    }

    public StringConcept getConceptLabel() {
        return new StringConcept("MemHandler");
    }

    public StringConcept getConceptType() {
        return new StringConcept("MemHandler");
    }

    public SeriesConcept getInheritedConcepts() {
        return _inheritedConcepts;
    }

    protected MemHandlerDefinition() {
        try {
            _inheritedConcepts.add(new StringConcept("URIHandler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.MemHandler", "initialize:org.media.mn8.concepts.MapConcept", "initialize:Map", "MemHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.MemHandler", "closeConnection:", "closeConnection:", "MemHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.MemHandler", "openConnection:", "openConnection:", "MemHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.MemHandler", "getContent:", "getContent:", "MemHandler", "Concept"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.MemHandler", "setContent:org.media.mn8.Concept", "setContent:Concept", "MemHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.MemHandler", "create:org.media.mn8.concepts.StringConcept", "create:String", "MemHandler", "MemHandler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.MemHandlerDefinition", true, "acceptsURI:org.media.mn8.concepts.StringConcept", "acceptsURI:String", "MemHandler", "Logical"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

