/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import com.oroinc.net.ProtocolCommandListener;
import com.oroinc.net.pop3.POP3Client;
import com.oroinc.net.pop3.POP3MessageInfo;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.net.URL;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.POP3ClientConceptDefinition;
import org.media.mn8.concepts.PrintCommandListener;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8RuntimeFlags;

public class POP3ClientConcept
extends JavaConcept {
    protected POP3Client _client;
    protected URL _url;
    public AttributeConcept errorMessage = new AttributeConcept("errorMessage", "errorMessage", new NilConcept());

    public LogicalConcept openConnection(StringConcept url) {
        URL givenURL = null;
        try {
            givenURL = new URL(url.toString());
            if (givenURL == null || givenURL.getProtocol().toLowerCase().equals("pop3")) {
                if (givenURL != null) {
                    this._url = givenURL;
                    this._client = new POP3Client();
                    this._client.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
                    if (givenURL.getHost() == null || givenURL.getHost().trim().length() < 1) {
                        new ErrorConcept("error", "missingHost", "Missing host name for POP3 connection.");
                        return new LogicalConcept(false);
                    }
                    if (givenURL.getHost() != null && givenURL.getPort() == -1) {
                        this._client.connect(givenURL.getHost());
                    }
                    if (givenURL.getHost() != null && givenURL.getPort() != -1) {
                        this._client.connect(givenURL.getHost(), givenURL.getPort());
                    }
                    this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
                    if (-1 == this._client.getState()) {
                        this._client.disconnect();
                        new ErrorConcept("error", "connectionRefuzed", "POP3 server (" + givenURL.getHost() + ") refuzed connection.");
                        return new LogicalConcept(false);
                    }
                }
            } else if (givenURL != null) {
                new ErrorConcept("error", "unsupportedProtocol", "'" + givenURL.getProtocol() + "' protocol not supported by POP3Client");
            }
        }
        catch (Exception ex) {
            if (mn8RuntimeFlags.isDebug()) {
                ex.printStackTrace();
            }
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public void closeConnection() {
        try {
            this._client.disconnect();
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
        }
        catch (Exception ex) {
            new ErrorConcept("error", "closeConnection", ex.getMessage());
        }
    }

    public LogicalConcept login(StringConcept uname, StringConcept pwd) {
        try {
            boolean logined = this._client.login(uname.toString(), pwd.toString());
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            if (!logined) {
                new ErrorConcept("warning", "loginWarning", this._client.getReplyString());
            }
            return new LogicalConcept(logined);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "loginFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public LogicalConcept logout() {
        try {
            boolean status = this._client.logout();
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            return new LogicalConcept(status);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "logoutFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public SeriesConcept getLinks() {
        SeriesConcept result = new SeriesConcept();
        try {
            POP3MessageInfo[] infos = this._client.listMessages();
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            if (infos != null) {
                int i = 0;
                while (i < infos.length) {
                    result.add(new StringConcept(infos[i].number + " (" + infos[i].size + ")"));
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "POP3OperationFailed", ex.getMessage());
        }
        return result;
    }

    public StringConcept getLinks(IntegerConcept messID) {
        try {
            POP3MessageInfo info = this._client.listMessage(messID.getInt());
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            if (info != null) {
                return new StringConcept(info.number + " (" + info.size + ")");
            }
            return new StringConcept("");
        }
        catch (Exception ex) {
            new ErrorConcept("error", "POP3OperationFailed", ex.getMessage());
            return new StringConcept("");
        }
    }

    public LogicalConcept delete(IntegerConcept messID) {
        try {
            boolean status = this._client.deleteMessage(messID.getInt());
            this.errorMessage.setAttributeValue(new StringConcept(this._client.getReplyString()));
            return new LogicalConcept(status);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "POP3OperationFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public StringConcept getMessage(IntegerConcept messID) {
        try {
            BufferedReader reader = new BufferedReader(this._client.retrieveMessage(messID.getInt()));
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line + "\n");
            }
            reader.close();
            return new StringConcept(buffer.toString());
        }
        catch (Exception ex) {
            new ErrorConcept("error", "POP3OperationFailed", ex.getMessage());
            return new StringConcept("");
        }
    }

    public ConceptDefinition getConceptDefinition() {
        return POP3ClientConceptDefinition.getReference();
    }

    public Object clone() {
        return this;
    }
}

