/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.net.URL;
import java.util.Enumeration;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.POP3ClientConcept;
import org.media.mn8.concepts.POP3HandlerDefinition;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandler;
import org.media.mn8.concepts.URIHandlerDefinition;

public class POP3Handler
extends URIHandler {
    private String _url = null;
    private String _uname = null;
    private String _pwd = null;
    private MapConcept _options;
    private POP3ClientConcept _client;

    public URIHandler create(StringConcept url) {
        this._url = url.toString();
        return this;
    }

    public LogicalConcept acceptsURI(StringConcept uri) {
        return ((URIHandlerDefinition)this.getConceptDefinition()).acceptsURI(uri);
    }

    public LogicalConcept initialize(MapConcept options) {
        URL givenURL = null;
        this._options = options;
        if (options.containsKey(new StringConcept("user")).getValue()) {
            this._uname = options.getValue(new StringConcept("user")).toTXT().toString();
        }
        if (options.containsKey(new StringConcept("pwd")).getValue()) {
            this._pwd = options.getValue(new StringConcept("pwd")).toTXT().toString();
        }
        try {
            givenURL = new URL(this._url);
            if (givenURL != null && givenURL.getProtocol().equalsIgnoreCase("pop3") && this._uname != null && this._uname.trim().length() > 0 && this._pwd != null && this._pwd.trim().length() > 0) {
                this._url = givenURL.getProtocol() + "://";
                this._url = this._url + this._uname + ":" + this._pwd + "@";
                if (givenURL.getHost() != null) {
                    this._url = this._url + givenURL.getHost();
                }
                if (givenURL.getPort() != -1) {
                    this._url = this._url + ":" + givenURL.getPort();
                }
                if (givenURL.getPath() != null) {
                    this._url = this._url + givenURL.getPath();
                }
                if (givenURL.getQuery() != null) {
                    this._url = this._url + "?" + givenURL.getQuery();
                }
                if (givenURL.getRef() != null) {
                    this._url = this._url + "#" + givenURL.getRef();
                }
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public LogicalConcept closeConnection() {
        return this._client.logout();
    }

    public LogicalConcept openConnection() {
        this._client = new POP3ClientConcept();
        if (!this._client.openConnection(new StringConcept(this._url)).getValue()) {
            return new LogicalConcept(false);
        }
        try {
            URL myURL = new URL(this._url);
            String ui = myURL.getUserInfo();
            String user = null;
            String passwd = null;
            if (ui == null || ui.trim().length() < 1) {
                return new LogicalConcept(false);
            }
            if (ui.indexOf(":") == -1) {
                new ErrorConcept("error", "userInfoMissing", "Username and password to login to POP3 server is missing.");
                return new LogicalConcept(false);
            }
            user = ui.substring(0, ui.indexOf(":"));
            passwd = ui.substring(ui.indexOf(":") + 1);
            return this._client.login(new StringConcept(user), new StringConcept(passwd));
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return new LogicalConcept(false);
        }
    }

    public Concept getContent() {
        String command = null;
        String messID = null;
        try {
            URL url = new URL(this._url);
            String file = url.getFile();
            String qu = url.getQuery();
            command = file.equals("/") || file.trim().length() < 1 ? "retrieve" : (file.indexOf("?") < 0 ? file.substring(1) : file.substring(1, file.indexOf("?")));
            if (qu != null && qu.indexOf("=") > 0 && qu.trim().length() != 0) {
                messID = qu.substring(qu.indexOf("=") + 1);
            }
            if (command.equalsIgnoreCase("list")) {
                if (messID == null) {
                    return this._client.getLinks();
                }
                return this._client.getLinks(new IntegerConcept(messID));
            }
            if (command.equalsIgnoreCase("retrieve")) {
                if (messID != null) {
                    return this._client.getMessage(new IntegerConcept(messID));
                }
                SeriesConcept result = new SeriesConcept();
                Enumeration e = this._client.getLinks().getVector().elements();
                while (e.hasMoreElements()) {
                    String id = ((StringConcept)e.nextElement()).toString();
                    id = id.substring(0, id.indexOf("(")).trim();
                    result.add(this._client.getMessage(new IntegerConcept(id)));
                }
                return result;
            }
            if (command.equalsIgnoreCase("delete")) {
                if (messID != null) {
                    return this._client.delete(new IntegerConcept(messID));
                }
                boolean allDeleted = true;
                Enumeration e = this._client.getLinks().getVector().elements();
                while (e.hasMoreElements()) {
                    String id = ((StringConcept)e.nextElement()).toString();
                    if (this._client.delete(new IntegerConcept(id = id.substring(0, id.indexOf("(")).trim())).getValue()) continue;
                    allDeleted = false;
                }
                return new LogicalConcept(allDeleted);
            }
            new ErrorConcept("error", "unknownCommand", "Unknown command '" + command + "'.\n" + "Command may be: list, delete or retrieve.");
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
        }
        return new StringConcept("");
    }

    public LogicalConcept setContent(Concept value) {
        return new LogicalConcept(false);
    }

    public ConceptDefinition getConceptDefinition() {
        return POP3HandlerDefinition.getReference();
    }

    public Object clone() {
        if (this._url != null) {
            return new POP3Handler(new StringConcept(this._url));
        }
        return new URIHandler();
    }

    public POP3Handler() {
    }

    public POP3Handler(StringConcept url) {
        this._url = url.toString();
    }
}

