/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.net.MalformedURLException;
import java.net.URL;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.POP3Handler;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandlerDefinition;
import org.media.mn8.mn8JavaMethod;

public class POP3HandlerDefinition
extends URIHandlerDefinition {
    private static SeriesConcept _inheritedConcepts = new SeriesConcept("Concept");
    private static POP3HandlerDefinition _reference = new POP3HandlerDefinition();

    public LogicalConcept acceptsURI(StringConcept uri) {
        try {
            URL url = new URL(uri.toString());
            if (url.getProtocol().equalsIgnoreCase("pop3")) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
        catch (MalformedURLException ex) {
            if (uri.toString().toLowerCase().startsWith("pop3:")) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
    }

    public static ConceptDefinition getReference() {
        return _reference;
    }

    public Concept getConceptInstance() {
        return new POP3Handler();
    }

    public StringConcept getConceptLabel() {
        return new StringConcept("POP3Handler");
    }

    public StringConcept getConceptType() {
        return new StringConcept("POP3Handler");
    }

    public SeriesConcept getInheritedConcepts() {
        return _inheritedConcepts;
    }

    protected POP3HandlerDefinition() {
        try {
            _inheritedConcepts.add(new StringConcept("URIHandler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.POP3Handler", "initialize:org.media.mn8.concepts.MapConcept", "initialize:Map", "POP3Handler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.POP3Handler", "closeConnection:", "closeConnection:", "POP3Handler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.POP3Handler", "openConnection:", "openConnection:", "POP3Handler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.POP3Handler", "getContent:", "getContent:", "POP3Handler", "Concept"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.POP3Handler", "setContent:org.media.mn8.Concept", "setContent:Concept", "POP3Handler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.POP3Handler", "create:org.media.mn8.concepts.StringConcept", "create:String", "POP3Handler", "POP3Handler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.POP3HandlerDefinition", true, "acceptsURI:org.media.mn8.concepts.StringConcept", "acceptsURI:String", "POP3Handler", "Logical"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

