/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.ProcessDefinition;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;

public class ProcessConcept
extends JavaConcept {
    public AttributeConcept exitValue = new AttributeConcept("exitValue", "exitValue", new StringConcept());
    public ElementConcept error = new ElementConcept("error", "error", new NilConcept(), null);
    public ElementConcept input = new ElementConcept("input", "input", new NilConcept(), null);
    public ElementConcept output = new ElementConcept("output", "output", new NilConcept(), null);
    private String inputText = null;

    public void setInput(StringConcept text) {
        this.inputText = text.toString();
        this.input.setElementValue(text);
    }

    public ProcessConcept exec(StringConcept cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd.toString());
            if (this.inputText != null) {
                this.sendTo(process);
            }
            process.waitFor();
            this.inputText = null;
            this.exitValue.setAttributeValue(new StringConcept(process.exitValue() + ""));
            this.error.setElementValue(new StringConcept(this.getStringFromIS(process.getErrorStream())));
            this.output.setElementValue(new StringConcept(this.getStringFromIS(process.getInputStream())));
        }
        catch (Exception ex) {
            new ErrorConcept("error", "execFailed", "Unable to execute command");
        }
        return this;
    }

    public ProcessConcept exec(StringConcept cmd, StringConcept dir) {
        try {
            Process process = Runtime.getRuntime().exec(cmd.toString(), null, new File(dir.toString()));
            if (this.inputText != null) {
                this.sendTo(process);
            }
            process.waitFor();
            this.inputText = null;
            this.exitValue.setAttributeValue(new StringConcept(process.exitValue() + ""));
            this.error.setElementValue(new StringConcept(this.getStringFromIS(process.getErrorStream())));
            this.output.setElementValue(new StringConcept(this.getStringFromIS(process.getInputStream())));
        }
        catch (Exception ex) {
            new ErrorConcept("error", "execFailed", "Unable to execute command");
        }
        return this;
    }

    public ProcessConcept exec(SeriesConcept cmd) {
        try {
            Process process = Runtime.getRuntime().exec(this.getArray(cmd.getValue()));
            if (this.inputText != null) {
                this.sendTo(process);
            }
            process.waitFor();
            this.inputText = null;
            this.exitValue.setAttributeValue(new StringConcept(process.exitValue() + ""));
            this.error.setElementValue(new StringConcept(this.getStringFromIS(process.getErrorStream())));
            this.output.setElementValue(new StringConcept(this.getStringFromIS(process.getInputStream())));
        }
        catch (Exception ex) {
            new ErrorConcept("error", "execFailed", "Unable to execute command");
        }
        return this;
    }

    public ProcessConcept exec(SeriesConcept cmd, StringConcept dir) {
        try {
            Process process = Runtime.getRuntime().exec(this.getArray(cmd.getValue()), null, new File(dir.toString()));
            if (this.inputText != null) {
                this.sendTo(process);
            }
            process.waitFor();
            this.inputText = null;
            this.exitValue.setAttributeValue(new StringConcept(process.exitValue() + ""));
            this.error.setElementValue(new StringConcept(this.getStringFromIS(process.getErrorStream())));
            this.output.setElementValue(new StringConcept(this.getStringFromIS(process.getInputStream())));
        }
        catch (Exception ex) {
            new ErrorConcept("error", "execFailed", "Unable to execute command");
        }
        return this;
    }

    public Object clone() {
        return this;
    }

    public ConceptDefinition getConceptDefinition() {
        return ProcessDefinition.getReference();
    }

    /*
     * WARNING - void declaration
     */
    private final String getStringFromIS(InputStream is) throws IOException {
        String line;
        StringBuffer result = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            void var2_4;
            result.append((String)var2_4 + "\n");
        }
        reader.close();
        return result.toString();
    }

    private final String[] getArray(Vector cmd) {
        String[] cmds = new String[cmd.size()];
        int i = 0;
        Enumeration e = cmd.elements();
        while (e.hasMoreElements()) {
            cmds[i] = ((StringConcept)e.nextElement()).toString();
            ++i;
        }
        return cmds;
    }

    private final void sendTo(Process process) throws Exception {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        writer.write(this.inputText, 0, this.inputText.length());
        writer.flush();
        writer.close();
    }
}

