/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.ExpressionConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.RegexpDefinition;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;

public class RegexpConcept
extends ExpressionConcept {
    private Pattern _pattern = null;

    public ExpressionConcept create(StringConcept pattern) throws MalformedPatternException {
        this._pattern = new Perl5Compiler().compile(pattern.toString());
        return this;
    }

    public void setPattern(StringConcept pattern) throws MalformedPatternException {
        this._pattern = new Perl5Compiler().compile(pattern.toString());
    }

    public StringConcept getPattern() {
        if (this._pattern == null) {
            return new StringConcept();
        }
        return new StringConcept(this._pattern.getPattern());
    }

    public LogicalConcept matches(StringConcept string) {
        Perl5Matcher matcher = new Perl5Matcher();
        return new LogicalConcept(matcher.matches(string.toString(), this._pattern));
    }

    public LogicalConcept contains(StringConcept string) {
        Perl5Matcher matcher = new Perl5Matcher();
        return new LogicalConcept(matcher.contains(string.toString(), this._pattern));
    }

    public SeriesConcept getMatches(StringConcept string) {
        SeriesConcept result = new SeriesConcept();
        PatternMatcherInput input = new PatternMatcherInput(string.toString());
        Perl5Matcher matcher = new Perl5Matcher();
        MatchResult tmpResult = null;
        while (matcher.contains(input, this._pattern)) {
            tmpResult = matcher.getMatch();
            if (tmpResult.groups() > 2) {
                SeriesConcept tempRes = new SeriesConcept();
                int i = 1;
                while (i < tmpResult.groups()) {
                    if (tmpResult.group(i) != null) {
                        tempRes.add(new StringConcept(tmpResult.group(i)));
                    }
                    ++i;
                }
                result.add(tempRes);
                continue;
            }
            if (tmpResult.groups() != 2 || tmpResult.group(1) == null) continue;
            result.add(new StringConcept(tmpResult.group(1)));
        }
        return result;
    }

    public StringConcept toTXT() {
        return this.getPattern();
    }

    public Object clone() {
        try {
            if (this._pattern != null) {
                return new RegexpConcept(this.getPattern());
            }
            return new RegexpConcept();
        }
        catch (MalformedPatternException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ConceptDefinition getConceptDefinition() {
        return RegexpDefinition.getReference();
    }

    public RegexpConcept() {
    }

    public RegexpConcept(StringConcept pattern) throws MalformedPatternException {
        this._pattern = new Perl5Compiler().compile(pattern.toString());
    }
}

