/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import com.oroinc.net.ProtocolCommandListener;
import com.oroinc.net.smtp.SMTPClient;
import com.oroinc.net.smtp.SMTPReply;
import com.oroinc.net.smtp.SimpleSMTPHeader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.PrintCommandListener;
import org.media.mn8.concepts.SMTPHandlerDefinition;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandler;
import org.media.mn8.concepts.URIHandlerDefinition;

public class SMTPHandler
extends URIHandler {
    private String _url = null;
    private SMTPClient _client;

    public URIHandler create(StringConcept url) {
        this._url = url.toString();
        return this;
    }

    public LogicalConcept acceptsURI(StringConcept uri) {
        return ((URIHandlerDefinition)this.getConceptDefinition()).acceptsURI(uri);
    }

    public LogicalConcept initialize(MapConcept options) {
        return new LogicalConcept(true);
    }

    public LogicalConcept closeConnection() {
        try {
            return new LogicalConcept(this._client.logout());
        }
        catch (Exception ex) {
            return new LogicalConcept(false);
        }
    }

    public LogicalConcept openConnection() {
        URL givenURL = null;
        try {
            givenURL = new URL(this._url);
            if ((givenURL == null || givenURL.getProtocol().toLowerCase().equals("smtp")) && givenURL != null) {
                this._client = new SMTPClient();
                this._client.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
                if (givenURL.getHost() == null || givenURL.getHost().trim().length() < 1) {
                    new ErrorConcept("error", "missingHost", "Missing host name for SMTP connection.");
                    return new LogicalConcept(false);
                }
                if (givenURL.getHost() != null && givenURL.getPort() == -1) {
                    this._client.connect(givenURL.getHost());
                }
                if (givenURL.getHost() != null && givenURL.getPort() != -1) {
                    this._client.connect(givenURL.getHost(), givenURL.getPort());
                }
                if (!SMTPReply.isPositiveCompletion((int)this._client.getReplyCode())) {
                    this._client.disconnect();
                    new ErrorConcept("error", "connectionRefuzed", "SMTP server (" + givenURL.getHost() + ") refuzed connection.");
                    return new LogicalConcept(false);
                }
                if (!this._client.login()) {
                    new ErrorConcept("error", "loginFailed", "Login failed to SMTP server.");
                    return new LogicalConcept(false);
                }
                return new LogicalConcept(true);
            }
        }
        catch (IOException e) {
            if (this._client.isConnected()) {
                try {
                    this._client.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
        }
        return new LogicalConcept(false);
    }

    public Concept getContent() {
        return new LogicalConcept(false);
    }

    public LogicalConcept setContent(Concept value) {
        String content = ((StringConcept)value).toString();
        String field = null;
        try {
            String from = this.getEmailAddress(this.getFromHeader(content, "From:"));
            String to = this.getEmailAddress(this.getFromHeader(content, "To:"));
            String subject = this.getFromHeader(content, "Subject:");
            if (from == null || from.length() < 1) {
                return new LogicalConcept(false);
            }
            if (to == null || to.length() < 1) {
                return new LogicalConcept(false);
            }
            if (!this._client.setSender(from)) {
                return new LogicalConcept(false);
            }
            if (!this._client.addRecipient(to)) {
                return new LogicalConcept(false);
            }
            Writer writer = this._client.sendMessageData();
            if (writer == null) {
                return new LogicalConcept(false);
            }
            SimpleSMTPHeader header = new SimpleSMTPHeader(from, to, subject);
            Vector headers = this.getHeaderFields(content);
            if (headers != null) {
                Enumeration e = headers.elements();
                while (e.hasMoreElements()) {
                    String _header = (String)e.nextElement();
                    if (!this.isSetable(_header) || (field = this.getFromHeader(content, _header + ":")) == null) continue;
                    header.addHeaderField(_header, field);
                }
            }
            writer.write(header.toString());
            writer.write(this.getMessage(content));
            writer.close();
            if (!this._client.completePendingCommand()) {
                return new LogicalConcept(false);
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "sendFailed", ex.getMessage());
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    private final boolean isSetable(String field) {
        return field != null && !field.equalsIgnoreCase("from") && !field.equalsIgnoreCase("to") && !field.equalsIgnoreCase("subject") && !field.equalsIgnoreCase("received") && !field.equalsIgnoreCase("message-id") && !field.equalsIgnoreCase("return-path") && !field.equalsIgnoreCase("delivered-to");
    }

    private final Vector getHeaderFields(String content) throws Exception {
        Vector<String> headers = new Vector<String>();
        String line = null;
        BufferedReader reader = new BufferedReader(new StringReader(content));
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() < 1) break;
            if (line.indexOf(": ") <= 0 || line.lastIndexOf(" ", line.indexOf(": ")) != -1) continue;
            headers.add(line.substring(0, line.indexOf(":")));
        }
        reader.close();
        return headers;
    }

    private final String getEmailAddress(String str) {
        int poz = str.indexOf("<");
        if (poz != -1) {
            if ((poz = str.indexOf(":", poz)) == -1) {
                poz = str.indexOf("<");
            }
            return str.substring(poz + 1, str.indexOf(">", poz) != -1 ? str.indexOf(">", poz) : str.length()).trim();
        }
        return str;
    }

    private final String getFromHeader(String content, String txt) throws Exception {
        String line = null;
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = new BufferedReader(new StringReader(content));
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() < 1) break;
            if (!line.toLowerCase().startsWith(txt.toLowerCase())) continue;
            sb.append(line.substring(line.indexOf(":") + 1).trim());
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() < 1 || line.indexOf(": ") > 0 && line.lastIndexOf(" ", line.indexOf(": ")) == -1) break;
                sb.append("\n" + line);
            }
            return sb.toString();
        }
        reader.close();
        return sb.toString();
    }

    private final String getMessage(String content) throws Exception {
        String line = null;
        StringBuffer sb = new StringBuffer();
        boolean isHeader = true;
        BufferedReader reader = new BufferedReader(new StringReader(content));
        while ((line = reader.readLine()) != null) {
            if (!isHeader) {
                sb.append(line + "\n");
            }
            if (line.trim().length() >= 1) continue;
            isHeader = false;
        }
        reader.close();
        return sb.toString();
    }

    public ConceptDefinition getConceptDefinition() {
        return SMTPHandlerDefinition.getReference();
    }

    public Object clone() {
        if (this._url != null) {
            return new SMTPHandler(new StringConcept(this._url));
        }
        return new URIHandler();
    }

    public SMTPHandler() {
    }

    public SMTPHandler(StringConcept url) {
        this._url = url.toString();
    }
}

