/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.net.MalformedURLException;
import java.net.URL;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.SMTPHandler;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandlerDefinition;
import org.media.mn8.mn8JavaMethod;

public class SMTPHandlerDefinition
extends URIHandlerDefinition {
    private static SeriesConcept _inheritedConcepts = new SeriesConcept("Concept");
    private static SMTPHandlerDefinition _reference = new SMTPHandlerDefinition();

    public LogicalConcept acceptsURI(StringConcept uri) {
        try {
            URL url = new URL(uri.toString());
            if (url.getProtocol().equalsIgnoreCase("smtp")) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
        catch (MalformedURLException ex) {
            if (uri.toString().toLowerCase().startsWith("smtp:")) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
    }

    public static ConceptDefinition getReference() {
        return _reference;
    }

    public Concept getConceptInstance() {
        return new SMTPHandler();
    }

    public StringConcept getConceptLabel() {
        return new StringConcept("SMTPHandler");
    }

    public StringConcept getConceptType() {
        return new StringConcept("SMTPHandler");
    }

    public SeriesConcept getInheritedConcepts() {
        return _inheritedConcepts;
    }

    protected SMTPHandlerDefinition() {
        try {
            _inheritedConcepts.add(new StringConcept("URIHandler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SMTPHandler", "initialize:org.media.mn8.concepts.MapConcept", "initialize:Map", "SMTPHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SMTPHandler", "closeConnection:", "closeConnection:", "SMTPHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SMTPHandler", "openConnection:", "openConnection:", "SMTPHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SMTPHandler", "getContent:", "getContent:", "SMTPHandler", "Concept"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SMTPHandler", "setContent:org.media.mn8.Concept", "setContent:Concept", "SMTPHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SMTPHandler", "create:org.media.mn8.concepts.StringConcept", "create:String", "SMTPHandler", "SMTPHandler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SMTPHandlerDefinition", true, "acceptsURI:org.media.mn8.concepts.StringConcept", "acceptsURI:String", "SMTPHandler", "Logical"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

