/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.DummyFieldConcept;
import org.media.mn8.FieldDefinition;
import org.media.mn8.Helper;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.CharacterConcept;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.RealConcept;
import org.media.mn8.concepts.Series;
import org.media.mn8.concepts.SeriesDefinition;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.TransparentElement;
import org.media.mn8.concepts.TypedSeries;
import org.media.mn8.event.ElementNotFoundException;
import org.media.mn8.event.FieldNotFoundException;
import org.media.mn8.mn8Interpreter;
import org.media.mn8.util.ConceptNavPatterns;
import org.media.mn8.util.SimpleExpression;

public class SeriesConcept
extends JavaConcept
implements Series {
    protected Vector _contents = new Vector();
    protected Vector _navCache = new Vector();
    protected IntegerConcept _index = new IntegerConcept(0L);
    protected IntegerConcept _length = new IntegerConcept(0L);
    protected LogicalConcept _hasNext = new LogicalConcept(false);
    protected LogicalConcept _hasPrevious = new LogicalConcept(true);
    public AttributeConcept length = new AttributeConcept("length", "length", this._length);
    public AttributeConcept index = new AttributeConcept("index", "index", this._index);
    public AttributeConcept hasNext = new AttributeConcept("hasNext", "hasNext", this._hasNext);
    public AttributeConcept hasPrevious = new AttributeConcept("hasPrevious", "hasPrevious", this._hasPrevious);

    public void setIndex(IntegerConcept where) {
        this.setIndex(where.getLong());
    }

    public void add(Concept newValue) {
        this._contents.add(newValue);
        this._length.setValue(this._contents.size());
        this._navCache.add(this.extractNavName(newValue));
        this.updateNavigationFans();
    }

    public void addSeries(SeriesConcept series) {
        Vector newElemVect = series.getVector();
        int i = 0;
        while (i < newElemVect.size()) {
            this.add((Concept)newElemVect.elementAt(i));
            ++i;
        }
        this.updateNavigationFans();
        this.updateNameCache();
    }

    public LogicalConcept contains(Concept key) {
        return new LogicalConcept(this._contents.contains(key));
    }

    public IntegerConcept indexOf(Concept key) {
        int idx = this._contents.indexOf(key);
        if (idx == -1) {
            return new IntegerConcept(idx);
        }
        return new IntegerConcept(idx + 1);
    }

    public Concept remove() {
        int idx;
        if (this._index.getInt() == 0) {
            boolean bl = false;
        } else {
            idx = this._index.getInt() - 1;
        }
        Concept result = (Concept)this._contents.remove(idx);
        this.updateNavigationFans();
        this.updateNameCache();
        this._length.setValue(this._contents.size());
        return result;
    }

    public Concept remove(IntegerConcept ind) {
        int idx;
        if (ind.getInt() == 0) {
            boolean bl = false;
        } else {
            idx = ind.getInt() - 1;
        }
        Concept result = (Concept)this._contents.remove(idx);
        this.updateNavigationFans();
        this.updateNameCache();
        this._length.setValue(this._contents.size());
        return result;
    }

    public Concept next() {
        if (this._hasNext.getValue()) {
            this._index.opIntegerINC();
            Concept result = (Concept)this._contents.get(this._index.getInt() - 1);
            this.updateNavigationFans();
            return result;
        }
        return new NilConcept();
    }

    public Concept current() {
        if (this._index.getLong() >= 1L && this._index.getLong() <= (long)this._contents.size()) {
            Concept result = (Concept)this._contents.get(this._index.getInt() - 1);
            return result;
        }
        return new NilConcept();
    }

    public Concept previous() {
        if (this._hasPrevious.getValue()) {
            this._index.opIntegerDEC();
            Concept result = (Concept)this._contents.get(this._index.getInt() - 1);
            this.updateNavigationFans();
            return result;
        }
        return new NilConcept();
    }

    public void insert(Concept newValue) {
        this.insert(this._index, newValue);
    }

    public void insert(IntegerConcept position, Concept newValue) {
        try {
            this._contents.add(position.getInt() - 1, newValue);
            this._navCache.add(position.getInt() - 1, this.extractNavName(newValue));
            this._length.setValue(this._contents.size());
            this.updateNavigationFans();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            new ErrorConcept("error", "invalidIndex", "Cannot insert to this position: " + position.getInt());
        }
    }

    public void sort(Concept sorter) {
    }

    public StringConcept toTXT() {
        StringBuffer buffer = new StringBuffer();
        int cnt = 0;
        while (cnt < this._contents.size()) {
            buffer.append(((Concept)this._contents.elementAt(cnt)).toTXT().getValue());
            if (cnt < this._contents.size() - 1) {
                buffer.append(mn8Interpreter.EOL);
            }
            ++cnt;
        }
        if (!this.showEmpty().getValue() && buffer.toString().trim().equals("")) {
            return new StringConcept();
        }
        return new StringConcept(buffer.toString());
    }

    public StringConcept toXML() {
        StringBuffer buffer = new StringBuffer();
        String current = null;
        int cnt = 0;
        while (cnt < this._contents.size()) {
            current = ((Concept)this._contents.elementAt(cnt)).toXML().toString();
            buffer.append(current);
            if (!Helper.endsWithEOL(current) && current.trim().startsWith("<") && current.trim().endsWith(">") && cnt < this._contents.size() - 1) {
                buffer.append(mn8Interpreter.EOL);
            }
            ++cnt;
        }
        if (!this.showEmpty().getValue() && buffer.toString().trim().equals("")) {
            return new StringConcept();
        }
        return new StringConcept(buffer.toString());
    }

    public Vector getVector() {
        return this._contents;
    }

    public void setVector(Vector contents) {
        this._contents = contents;
        this._length.setValue(this._contents.size());
        this.updateNameCache();
        this.updateNavigationFans();
    }

    public Vector getValue() {
        return this._contents;
    }

    public void setValue(Vector contents) {
        this.setVector(contents);
    }

    public ConceptDefinition getConceptDefinition() {
        return SeriesDefinition.getReference();
    }

    public boolean hasNext() {
        return this._hasNext.getValue();
    }

    public boolean hasPrevious() {
        return this._hasPrevious.getValue();
    }

    public Concept elementAt(IntegerConcept position) {
        if (this.getLength() < position.getInt()) {
            return new NilConcept();
        }
        return this.elementAt(position.getInt());
    }

    public Concept elementAt(int position) {
        return (Concept)this._contents.elementAt(position - 1);
    }

    public int getLength() {
        return this._contents.size();
    }

    public long getIndex() {
        return this._index.getInt();
    }

    public void setIndex(long idx) {
        this._index.setValue(idx);
        this.updateNavigationFans();
    }

    protected void updateNameCache() {
        this._navCache.clear();
        int i = 0;
        while (i < this._contents.size()) {
            this._navCache.add(this.extractNavName((Concept)this._contents.elementAt(i)));
            ++i;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof SeriesConcept && ((SeriesConcept)obj).getVector().equals(this._contents);
    }

    public LogicalConcept equals(SeriesConcept target) {
        return new LogicalConcept(target.getVector().equals(this._contents));
    }

    protected void updateNavigationFans() {
        if (this._contents.size() - this._index.getInt() > 0) {
            this._hasNext.setValue(true);
        } else {
            this._hasNext.setValue(false);
            this._index.setValue(this._contents.size());
        }
        if (this._index.getInt() >= 1) {
            if (this._index.getInt() > 1) {
                this._hasPrevious.setValue(true);
            } else {
                this._hasPrevious.setValue(false);
            }
        } else {
            this._hasPrevious.setValue(false);
            this._index.setValue(0L);
        }
    }

    public Concept getConceptElement(StringConcept name) {
        Concept result = null;
        try {
            result = super.getConceptElement(name);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        int i = -1;
        i = this._navCache.indexOf(new StringConcept(name));
        try {
            if (i == -1) {
                i = new Integer(name.toString());
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (i <= this._contents.size() && i > 0) {
            if (Helper.isElement((Concept)this._contents.elementAt(i - 1))) {
                return (ElementConcept)this._contents.elementAt(i - 1);
            }
            return new TransparentElement(((StringConcept)this._navCache.elementAt(i - 1)).toString(), ((Concept)this._contents.elementAt(i - 1)).getConceptLabel().toString(), (Concept)this._contents.elementAt(i - 1), null);
        }
        throw new ElementNotFoundException("Series", name.toString());
    }

    public LogicalConcept hasConceptElement(StringConcept name) {
        return new LogicalConcept(this.hasConceptElement(name.toString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LogicalConcept hasPath(String fullpath) {
        String firstItem = ConceptNavPatterns.getFirstItem(fullpath);
        String remainingItems = ConceptNavPatterns.getRemainingItems(fullpath);
        if (ConceptNavPatterns.isAbsolutePath(firstItem)) {
            if (ConceptNavPatterns.isAttribute(firstItem)) {
                if (this.hasConceptAttribute(new StringConcept(ConceptNavPatterns.getAttributeName(firstItem))).getValue()) return LogicalConcept.FALSE;
                return LogicalConcept.FALSE;
            }
            StringConcept elmName = new StringConcept(ConceptNavPatterns.getElementName(firstItem));
            int idx = this._navCache.indexOf(elmName);
            if (idx == -1) return this.subElementHasPath(ConceptNavPatterns.getElementName(firstItem), remainingItems);
            if (remainingItems == null) {
                return LogicalConcept.TRUE;
            }
            int a = 0;
            while (a < this._navCache.size()) {
                LogicalConcept tmpRes;
                if (this._navCache.elementAt(a).equals(elmName) && (tmpRes = ((Concept)this._contents.elementAt(a)).hasPath(remainingItems)).getValue()) {
                    return LogicalConcept.TRUE;
                }
                ++a;
            }
            return LogicalConcept.FALSE;
        }
        if (ConceptNavPatterns.isAttribute(firstItem)) {
            StringConcept attribute = new StringConcept(ConceptNavPatterns.getAttributeName(firstItem));
            if (this.hasConceptAttribute(attribute).getValue()) {
                return LogicalConcept.TRUE;
            }
            LogicalConcept result = LogicalConcept.FALSE;
            int j = 0;
            while (j < this._contents.size()) {
                result = ((Concept)this._contents.elementAt(j)).hasPath(firstItem);
                if (result.getValue()) {
                    return result;
                }
                ++j;
            }
            return result;
        }
        StringConcept first = new StringConcept(firstItem);
        int idx = this._navCache.indexOf(first);
        if (idx != -1) {
            if (remainingItems == null) {
                return LogicalConcept.TRUE;
            }
            LogicalConcept result = null;
            int j = 0;
            while (j < this._navCache.size()) {
                if (((StringConcept)this._navCache.elementAt(j)).toString().equals(firstItem) && (result = ((Concept)this._contents.elementAt(j)).hasPath(remainingItems)).getValue()) {
                    return result;
                }
                ++j;
            }
            return result;
        }
        LogicalConcept result = null;
        int j = 0;
        while (j < this._contents.size()) {
            result = ((Concept)this._contents.elementAt(j)).hasPath(fullpath);
            if (result.getValue()) {
                return result;
            }
            ++j;
        }
        return result;
    }

    public boolean hasConceptElement(String name) {
        if (this._navCache.contains(new StringConcept(name))) {
            return true;
        }
        try {
            int i = new Integer(name.toString());
            if (i <= this._contents.size() && i > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public SeriesConcept getConceptElementFields() {
        TypedSeries result = new TypedSeries();
        int i = 0;
        while (i < this._contents.size()) {
            result.add(new DummyFieldConcept(((StringConcept)this._navCache.elementAt(i)).toString(), new TransparentElement(((StringConcept)this._navCache.elementAt(i)).toString(), ((Concept)this._contents.elementAt(i)).getConceptLabel().toString(), (Concept)this._contents.elementAt(i), null), false, ((Concept)this._contents.elementAt(i)).getConceptLabel().toString(), ((Concept)this._contents.elementAt(i)).getConceptType().toString()));
            ++i;
        }
        return result;
    }

    public FieldDefinition getConceptElementField(StringConcept elemenName) {
        return this.getConceptElementField(elemenName.toString());
    }

    public FieldDefinition getConceptElementField(String elementName) {
        FieldDefinition result = null;
        StringConcept elNameStrCon = new StringConcept(elementName);
        try {
            result = super.getConceptElementField(elementName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (result != null) {
            return result;
        }
        int i = -1;
        i = this._navCache.indexOf(new StringConcept(elementName)) + 1;
        if (this._navCache.indexOf(new StringConcept(elementName), i) != -1) {
            TypedSeries multiple = new TypedSeries();
            int j = 0;
            while ((j = this._navCache.indexOf(elNameStrCon, j)) != -1) {
                multiple.add((Concept)this._contents.elementAt(j));
                ++j;
            }
            return new DummyFieldConcept(elementName, new TransparentElement(elementName, elementName, multiple, null), false, elementName, "Series");
        }
        try {
            if (i == 0) {
                i = new Integer(elementName.toString());
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (i <= this._contents.size() && i > 0) {
            return new DummyFieldConcept(((StringConcept)this._navCache.elementAt(i - 1)).toString(), Helper.isElement((Concept)this._contents.elementAt(i - 1)) ? (Concept)this._contents.elementAt(i - 1) : new TransparentElement(((StringConcept)this._navCache.elementAt(i - 1)).toString(), ((Concept)this._contents.elementAt(i - 1)).getConceptLabel().toString(), (Concept)this._contents.elementAt(i - 1), null), false, ((Concept)this._contents.elementAt(i - 1)).getConceptLabel().toString(), ((Concept)this._contents.elementAt(i - 1)).getConceptType().toString());
        }
        throw new FieldNotFoundException("Series", elementName);
    }

    public SeriesConcept getConceptElements() {
        TypedSeries result = new TypedSeries();
        int i = 0;
        while (i < this._contents.size()) {
            result.add(new TransparentElement(((StringConcept)this._navCache.elementAt(i)).toString(), ((Concept)this._contents.elementAt(i)).getConceptLabel().toString(), (Concept)this._contents.elementAt(i), null));
            ++i;
        }
        return result;
    }

    public Object clone() {
        Vector<Object> newVect = new Vector<Object>(this._contents.size());
        int i = 0;
        while (i < this._contents.size()) {
            newVect.add(((Concept)this._contents.elementAt(i)).clone());
            ++i;
        }
        return new SeriesConcept(newVect);
    }

    protected StringConcept extractNavName(Concept concept) {
        return Helper.extractName(concept);
    }

    public void loadContent(Concept from) {
        if (from instanceof SeriesConcept) {
            Vector elements = ((SeriesConcept)from).getVector();
            int i = 0;
            while (i < elements.size()) {
                if (elements.elementAt(i) instanceof TransparentElement) {
                    this.add(((TransparentElement)elements.elementAt(i)).getValue());
                } else {
                    this.add((Concept)elements.elementAt(i));
                }
                ++i;
            }
        } else {
            this.add(from);
        }
    }

    public SeriesConcept selectSIMEXP(String expr) {
        SeriesConcept result = new SeriesConcept();
        int i = 0;
        while (i < this._contents.size()) {
            if (SimpleExpression.match(((Concept)this._contents.elementAt(i)).toTXT().toString().trim(), expr)) {
                result.add((Concept)this._contents.elementAt(i));
            }
            ++i;
        }
        return result;
    }

    public SeriesConcept searchDeeperForPath(SeriesConcept holder, String path) {
        int i = 0;
        while (i < this._contents.size()) {
            holder = ((Concept)this._contents.elementAt(i)).getConceptsAtPath(holder, path);
            ++i;
        }
        return holder;
    }

    /*
     * Unable to fully structure code
     */
    public LogicalConcept subElementHasPath(String elementName, String subPath) {
        idx = this._navCache.indexOf(new StringConcept(elementName));
        if (idx == -1) {
            return LogicalConcept.FALSE;
        }
        cnt = idx;
        con = (Concept)this._contents.elementAt(idx);
        result = con.hasPath(subPath);
        if (!con.hasPath(subPath).getValue()) ** GOTO lbl14
        return LogicalConcept.TRUE;
lbl-1000:
        // 1 sources

        {
            con = (Concept)this._contents.elementAt(idx);
            result = con.hasPath(subPath);
            if (result.getValue()) {
                return LogicalConcept.TRUE;
            }
            cnt = idx;
lbl14:
            // 2 sources

            ** while ((idx = this._navCache.indexOf((Object)new StringConcept((String)elementName), (int)(cnt + 1))) != -1 && cnt < this._navCache.size())
        }
lbl15:
        // 1 sources

        return LogicalConcept.FALSE;
    }

    public boolean areThereMoreElemenents(String path) {
        return this._navCache.indexOf(new StringConcept(path)) != -1;
    }

    public Vector getMeAllElements(String path) {
        int cnt = -1;
        int idx = -1;
        Vector<Concept> result = new Vector<Concept>();
        while ((idx = this._navCache.indexOf(new StringConcept(path), cnt + 1)) != -1 && cnt < this._navCache.size()) {
            Concept con = (Concept)this._contents.elementAt(idx);
            result.add(con);
            cnt = idx;
        }
        return result;
    }

    public SeriesConcept() {
        LogicalConcept true_value = new LogicalConcept(true);
        this.length.setHidden(true_value);
        this.index.setHidden(true_value);
        this.hasPrevious.setHidden(true_value);
        this.hasNext.setHidden(true_value);
    }

    public SeriesConcept(Vector values) {
        this._contents = values;
        this._length.setValue(values.size());
        this.updateNameCache();
        this.updateNavigationFans();
    }

    public SeriesConcept(String value) {
        this._contents.add(new StringConcept(value));
        this._length.setValue(this._contents.size());
        this.updateNameCache();
        this.updateNavigationFans();
    }

    public SeriesConcept(CharacterConcept from, CharacterConcept to, IntegerConcept step) {
        char i = from.getValue();
        while (i <= to.getValue()) {
            this._contents.add(new CharacterConcept(i));
            this._length.setValue(this._length.getLong() + 1L);
            i = (char)(i + step.getInt());
        }
        this.updateNameCache();
        this.updateNavigationFans();
    }

    public SeriesConcept(IntegerConcept from, IntegerConcept to, IntegerConcept step) {
        long i = from.getLong();
        while (i <= to.getLong()) {
            this._contents.add(new IntegerConcept(i));
            this._length.setValue(this._length.getLong() + 1L);
            i += step.getLong();
        }
        this.updateNameCache();
        this.updateNavigationFans();
    }

    public SeriesConcept(IntegerConcept from, IntegerConcept to, RealConcept step) {
        float i = from.getLong();
        while (i <= (float)to.getLong()) {
            this._contents.add(new RealConcept(i));
            this._length.setValue(this._length.getLong() + 1L);
            i += step.getFloat();
        }
        this.updateNameCache();
        this.updateNavigationFans();
    }

    public SeriesConcept(RealConcept from, RealConcept to, RealConcept step) {
        float i = from.getFloat();
        while (i <= to.getFloat()) {
            this._contents.add(new RealConcept(i));
            this._length.setValue(this._length.getLong() + 1L);
            i += step.getFloat();
        }
        this.updateNameCache();
        this.updateNavigationFans();
    }

    public SeriesConcept(RealConcept from, RealConcept to, IntegerConcept step) {
        float i = from.getFloat();
        while (i <= to.getFloat()) {
            this._contents.add(new RealConcept(i));
            this._length.setValue(this._length.getLong() + 1L);
            i += step.getFloat();
        }
        this.updateNameCache();
        this.updateNavigationFans();
    }
}

