/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.Collection;
import java.util.Iterator;
import org.apache.oro.text.regex.MalformedPatternException;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.ExpressionConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.SimplexDefinition;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.util.SimpleExpression;

public class SimplexConcept
extends ExpressionConcept {
    private String _pattern = null;

    public void setPattern(StringConcept pattern) throws MalformedPatternException {
        this._pattern = pattern.toString();
    }

    public ExpressionConcept create(StringConcept pattern) throws MalformedPatternException {
        this.setPattern(pattern);
        return this;
    }

    public StringConcept getPattern() {
        return new StringConcept(this._pattern);
    }

    public LogicalConcept matches(StringConcept string) {
        return new LogicalConcept(SimpleExpression.match(string.toString(), this._pattern));
    }

    public LogicalConcept contains(StringConcept string) {
        return new LogicalConcept(SimpleExpression.contains(string.toString(), this._pattern));
    }

    public SeriesConcept getMatches(StringConcept string) {
        SeriesConcept result = new SeriesConcept();
        Collection matches = SimpleExpression.select(string.toString(), this._pattern);
        return this.collectionToSeries(result, matches);
    }

    private final SeriesConcept collectionToSeries(SeriesConcept in, Collection from) {
        Object inst = null;
        SeriesConcept currRes = in;
        if (from != null) {
            Iterator matIter = from.iterator();
            while (matIter.hasNext()) {
                inst = matIter.next();
                if (inst instanceof String[]) {
                    String[] res = inst;
                    int i = 0;
                    while (i < res.length) {
                        currRes.add(new StringConcept(res[i]));
                        ++i;
                    }
                    continue;
                }
                if (inst instanceof String) {
                    currRes.add(new StringConcept(inst));
                    continue;
                }
                if (!(inst instanceof Collection)) continue;
                currRes.add(this.collectionToSeries(new SeriesConcept(), inst));
            }
        }
        return currRes;
    }

    public Object clone() {
        try {
            if (this._pattern != null) {
                return new SimplexConcept(this.getPattern());
            }
            return new SimplexConcept();
        }
        catch (MalformedPatternException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public StringConcept toTXT() {
        return this.getPattern();
    }

    public ConceptDefinition getConceptDefinition() {
        return SimplexDefinition.getReference();
    }

    public SimplexConcept() {
    }

    public SimplexConcept(StringConcept pattern) throws MalformedPatternException {
        this._pattern = pattern.toString();
    }
}

