/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.StringTokenizer;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.CharacterConcept;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.ExpressionConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.RealConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringDefinition;
import org.media.mn8.util.LineWrapper;
import org.media.mn8.util.Normalizer;

public class StringConcept
extends JavaConcept {
    private String _value = "";

    public StringConcept toStringConcept() {
        return this;
    }

    public StringConcept opPlus(IntegerConcept value) {
        return new StringConcept(this._value + value.getLong());
    }

    public StringConcept opPlus(RealConcept value) {
        return new StringConcept(this._value + value.getFloat());
    }

    public StringConcept opPlus(Concept value) {
        return new StringConcept(this._value + value.toTXT().toString());
    }

    public StringConcept opPlus(LogicalConcept value) {
        if (value.getValue()) {
            return new StringConcept(this._value + "true");
        }
        return new StringConcept(this._value + "false");
    }

    public LogicalConcept opEquals(StringConcept value) {
        return new LogicalConcept(this._value.equals(value.toString()));
    }

    public StringConcept opPlus(StringConcept value) {
        return new StringConcept(this._value + value.getValue());
    }

    public StringConcept opPlus(CharacterConcept value) {
        return new StringConcept(this._value + value.getValue());
    }

    public StringConcept opPlus(NilConcept value) {
        return new StringConcept(this._value);
    }

    public LogicalConcept opLT(StringConcept value) {
        return new LogicalConcept(this._value.compareTo(value.getValue()) < 0);
    }

    public LogicalConcept opGT(StringConcept value) {
        return new LogicalConcept(this._value.compareTo(value.getValue()) > 0);
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void main(SeriesConcept param) {
        System.out.println(this._value);
    }

    public ConceptDefinition getConceptDefinition() {
        return StringDefinition.getReference();
    }

    public SeriesConcept select(ExpressionConcept expression) {
        return expression.getMatches(this.toTXT());
    }

    public LogicalConcept matches(ExpressionConcept expression) {
        return expression.matches(this.toTXT());
    }

    public LogicalConcept contains(ExpressionConcept expression) {
        return expression.contains(this.toTXT());
    }

    public LogicalConcept contains(StringConcept expression) {
        return new LogicalConcept(this._value.indexOf(expression.toString()) != -1);
    }

    public int hashCode() {
        return this._value.toLowerCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringConcept) {
            if (((StringConcept)obj).getValue().equalsIgnoreCase(this._value)) {
                return true;
            }
            if (obj instanceof String && ((String)obj).equalsIgnoreCase(this._value)) {
                return true;
            }
        }
        return false;
    }

    public LogicalConcept hasPath(StringConcept path) {
        return LogicalConcept.FALSE;
    }

    public LogicalConcept hasPath(String path) {
        return LogicalConcept.FALSE;
    }

    public SeriesConcept getConceptsAtPath(StringConcept path) {
        return new SeriesConcept();
    }

    public String toString() {
        return this._value;
    }

    public StringConcept toTXT() {
        return new StringConcept(this.toString());
    }

    public StringConcept toXML() {
        return new StringConcept(Normalizer.normalize(this.toString()));
    }

    public Object clone() {
        return new StringConcept(this._value);
    }

    public CharacterConcept charAt(IntegerConcept at) {
        return new CharacterConcept(this._value.charAt(at.getInt() - 1));
    }

    public LogicalConcept equalsIgnoreCase(StringConcept value) {
        return new LogicalConcept(this._value.equalsIgnoreCase(value.toString()));
    }

    public IntegerConcept compareTo(StringConcept value) {
        return new IntegerConcept(this._value.compareTo(value.toString()));
    }

    public LogicalConcept startsWith(StringConcept value) {
        return new LogicalConcept(this._value.startsWith(value.toString()));
    }

    public LogicalConcept startsWith(StringConcept value, IntegerConcept offset) {
        return new LogicalConcept(this._value.startsWith(value.toString(), offset.getInt() - 1));
    }

    public LogicalConcept endsWith(StringConcept value) {
        return new LogicalConcept(this._value.endsWith(value.toString()));
    }

    public IntegerConcept indexOf(StringConcept value) {
        if (this._value.indexOf(value.toString()) != -1) {
            return new IntegerConcept(this._value.indexOf(value.toString()) + 1);
        }
        return new IntegerConcept(-1L);
    }

    public IntegerConcept indexOf(StringConcept value, IntegerConcept startFrom) {
        int result = this._value.indexOf(value.toString(), startFrom.getInt() - 1);
        if (result == -1) {
            return new IntegerConcept(result);
        }
        return new IntegerConcept(result + 1);
    }

    public IntegerConcept lastIndexOf(StringConcept value) {
        int result = this._value.lastIndexOf(value.toString());
        if (result == -1) {
            return new IntegerConcept(result);
        }
        return new IntegerConcept(result + 1);
    }

    public IntegerConcept lastIndexOf(StringConcept value, IntegerConcept startFrom) {
        int result = this._value.lastIndexOf(value.toString(), startFrom.getInt() - 1);
        if (result == -1) {
            return new IntegerConcept(result);
        }
        return new IntegerConcept(result + 1);
    }

    public StringConcept substring(IntegerConcept from) {
        return new StringConcept(this._value.substring(from.getInt() - 1));
    }

    public StringConcept substring(IntegerConcept from, IntegerConcept to) {
        return new StringConcept(this._value.substring(from.getInt() - 1, to.getInt() - 1));
    }

    public StringConcept replace(CharacterConcept oldChar, CharacterConcept newChar) {
        return new StringConcept(this._value.replace(oldChar.getValue(), newChar.getValue()));
    }

    public StringConcept trim() {
        return new StringConcept(this._value.trim());
    }

    public StringConcept toLowerCase() {
        return new StringConcept(this._value.toLowerCase());
    }

    public StringConcept toUpperCase() {
        return new StringConcept(this._value.toUpperCase());
    }

    public SeriesConcept getLines() {
        return this.getTokens(new StringConcept("\r\n\r\n\f"));
    }

    public SeriesConcept getTokens(StringConcept delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(this._value, delimiters.toString());
        SeriesConcept result = new SeriesConcept();
        while (tokenizer.hasMoreTokens()) {
            result.add(new StringConcept(tokenizer.nextToken()));
        }
        return result;
    }

    public SeriesConcept getTokensWithDelimiters(StringConcept delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(this._value, delimiters.toString(), true);
        SeriesConcept result = new SeriesConcept();
        while (tokenizer.hasMoreTokens()) {
            result.add(new StringConcept(tokenizer.nextToken()));
        }
        return result;
    }

    public StringConcept wrap() {
        return new StringConcept(LineWrapper.alignText(this._value, 72, "left"));
    }

    public StringConcept wrap(IntegerConcept colon) {
        return new StringConcept(LineWrapper.alignText(this._value, colon.getInt(), "left"));
    }

    public StringConcept wrap(IntegerConcept colon, StringConcept align) {
        return new StringConcept(LineWrapper.alignText(this._value, colon.getInt(), align.toString()));
    }

    public IntegerConcept getLength() {
        return new IntegerConcept(this._value.length());
    }

    public void loadContent(Concept from) {
        if (from instanceof StringConcept) {
            this._value = from.toString();
        } else if (from instanceof ElementConcept && ((ElementConcept)from).getValue() instanceof StringConcept) {
            this._value = ((ElementConcept)from).getValue().toString();
        }
    }

    public StringConcept() {
    }

    public StringConcept(String value) {
        if (value != null) {
            this._value = value;
        }
    }

    public StringConcept(StringConcept value) {
        new StringConcept(value.getValue());
    }
}

