/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.InputStream;
import java.util.Enumeration;
import org.media.mn8.Concept;
import org.media.mn8.ConceptConceptDefinition;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.ConceptRegister;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8Interpreter;
import org.media.mn8.mn8JavaMethod;

public class SystemDefinition
extends ConceptConceptDefinition {
    private static SeriesConcept _inheritedConcepts = new SeriesConcept("Concept");
    private static SystemDefinition _reference = new SystemDefinition();

    public SeriesConcept getLoadedConcepts() {
        Enumeration enumeration = ConceptRegister.getReference().listConceptsName();
        SeriesConcept result = new SeriesConcept();
        while (enumeration.hasMoreElements()) {
            result.add(new StringConcept((String)enumeration.nextElement()));
        }
        return result;
    }

    public static final IntegerConcept getCurrentTime() {
        return new IntegerConcept(System.currentTimeMillis());
    }

    public static final IntegerConcept getFreeMemory() {
        return new IntegerConcept(Runtime.getRuntime().freeMemory());
    }

    public static final IntegerConcept getTotalMemory() {
        return new IntegerConcept(Runtime.getRuntime().totalMemory());
    }

    public static final StringConcept getMN8Version() {
        return new StringConcept(mn8Interpreter.VERSION);
    }

    public static final StringConcept getMN8Info() {
        return new StringConcept(mn8Interpreter.IDENTIFIER);
    }

    public void pause(IntegerConcept time) {
        try {
            if (time.getLong() == 0L) {
                InputStream in = System.in;
                while (in.available() <= 0) {
                    Thread.currentThread();
                    Thread.yield();
                }
                while (in.available() > 0) {
                    in.read();
                }
            } else {
                Thread.currentThread();
                Thread.sleep(time.getLong());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ConceptDefinition getReference() {
        return _reference;
    }

    public Concept getConceptInstance() {
        return new NilConcept();
    }

    public StringConcept getConceptLabel() {
        return new StringConcept("System");
    }

    public StringConcept getConceptType() {
        return new StringConcept("System");
    }

    public SeriesConcept getInheritedConcepts() {
        return _inheritedConcepts;
    }

    private SystemDefinition() {
        try {
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SystemDefinition", true, "pause:org.media.mn8.concepts.IntegerConcept", "pause:Integer", "System", null));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SystemDefinition", true, "getLoadedConcepts:", "getLoadedConcepts:", "System", "Series"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SystemDefinition", true, "getMN8Version:", "getMN8Version:", "System", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SystemDefinition", true, "getMN8Info:", "getMN8Info:", "System", "String"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SystemDefinition", true, "getCurrentTime:", "getCurrentTime:", "System", "Integer"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SystemDefinition", true, "getFreeMemory:", "getFreeMemory:", "System", "Integer"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.SystemDefinition", true, "getTotalMemory:", "getTotalMemory:", "System", "Integer"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

