/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.TarDefinition;
import org.media.mn8.util.tar.TarEntry;
import org.media.mn8.util.tar.TarInputStream;
import org.media.mn8.util.tar.TarOutputStream;

public class TarConcept
extends JavaConcept {
    private String tarName;
    private boolean compressed;

    public TarConcept create(StringConcept path, LogicalConcept compress) {
        this.tarName = path.toString();
        this.compressed = compress.getValue();
        return this;
    }

    public void add(StringConcept path) {
        OutputStream os = null;
        InputStream is = null;
        TarInputStream tarIn = null;
        boolean exists = new File(this.tarName).exists();
        try {
            if (exists) {
                new File(this.tarName).renameTo(new File(this.tarName + ".tmp"));
                is = new FileInputStream(this.tarName + ".tmp");
                if (this.compressed) {
                    is = new GZIPInputStream(is);
                }
                tarIn = new TarInputStream(is);
            }
            os = new FileOutputStream(this.tarName);
            if (this.compressed) {
                os = new GZIPOutputStream(os);
            }
            TarOutputStream tarOut = new TarOutputStream(os);
            if (exists && tarIn != null) {
                this.readd(tarIn, tarOut);
            }
            this.addDirectory(tarOut, path.toString());
            tarOut.close();
            if (exists) {
                tarIn.close();
                new File(this.tarName + ".tmp").delete();
            }
        }
        catch (IOException ioe) {
            new ErrorConcept("error", "openTarFailed", "Unable to open '" + this.tarName + "' tar file.");
        }
    }

    public void add(StringConcept text, StringConcept path) {
        OutputStream os = null;
        InputStream is = null;
        TarInputStream tarIn = null;
        boolean exists = new File(this.tarName).exists();
        try {
            if (exists) {
                new File(this.tarName).renameTo(new File(this.tarName + ".tmp"));
                is = new FileInputStream(this.tarName + ".tmp");
                if (this.compressed) {
                    is = new GZIPInputStream(is);
                }
                tarIn = new TarInputStream(is);
            }
            os = new FileOutputStream(this.tarName);
            if (this.compressed) {
                os = new GZIPOutputStream(os);
            }
            TarOutputStream tarOut = new TarOutputStream(os);
            if (exists && tarIn != null) {
                this.readd(tarIn, tarOut);
            }
            this.addIS(tarOut, new ByteArrayInputStream(text.toString().getBytes()), path.toString(), text.toString().length());
            tarOut.close();
            if (exists) {
                tarIn.close();
                new File(this.tarName + ".tmp").delete();
            }
        }
        catch (IOException ioe) {
            new ErrorConcept("error", "openTarFailed", "Unable to open '" + this.tarName + "' tar file.");
        }
    }

    public SeriesConcept list() {
        SeriesConcept result = new SeriesConcept();
        InputStream f = null;
        TarEntry te = null;
        String longLink = null;
        try {
            f = new FileInputStream(this.tarName);
            if (this.compressed) {
                f = new GZIPInputStream(f);
            }
            TarInputStream tarIn = new TarInputStream(new BufferedInputStream(f));
            while ((te = tarIn.getNextEntry()) != null) {
                if (te.getName().equals("././@LongLink")) {
                    longLink = this.getLongLink(tarIn);
                    continue;
                }
                if (longLink == null) {
                    result.add(new StringConcept(te.getName()));
                } else {
                    result.add(new StringConcept(longLink));
                }
                longLink = null;
            }
            tarIn.close();
        }
        catch (IOException ioe) {
            new ErrorConcept("error", "openTarFailed", "Unable to open '" + this.tarName + "' tar file.\n" + ioe.getMessage());
        }
        return result;
    }

    public StringConcept view(StringConcept path) {
        StringBuffer result = new StringBuffer();
        boolean found = false;
        InputStream f = null;
        TarEntry te = null;
        String fileName = null;
        byte[] _buff = new byte[32768];
        try {
            f = new FileInputStream(this.tarName);
            if (this.compressed) {
                f = new GZIPInputStream(f);
            }
            TarInputStream in = new TarInputStream(new BufferedInputStream(f));
            while ((te = in.getNextEntry()) != null && !found) {
                if (te.getName().equals("././@LongLink")) {
                    fileName = this.getLongLink(in);
                    continue;
                }
                if (fileName == null) {
                    fileName = te.getName();
                }
                if (path.toString().equals(fileName)) {
                    int nb;
                    while ((nb = in.read(_buff)) != -1) {
                        result.append(new String(_buff, 0, nb));
                    }
                    found = true;
                }
                fileName = null;
            }
            in.close();
            if (!found) {
                new ErrorConcept("warning", "pathNotFound", "File '" + path + "' doesn't exists.");
            }
        }
        catch (IOException ioex) {
            new ErrorConcept("error", "readFailed", "Could not read '" + path.toString() + "' from  '" + this.tarName + "'.\n" + ioex.getMessage());
        }
        return new StringConcept(result.toString());
    }

    public void delete(StringConcept path) {
        OutputStream os = null;
        InputStream is = null;
        TarEntry te = null;
        byte[] _buff = new byte[32768];
        String fileName = null;
        if (!new File(this.tarName).exists()) {
            new ErrorConcept("error", "openTarFailed", "Unable to open '" + this.tarName + "' tar file.");
            return;
        }
        try {
            new File(this.tarName).renameTo(new File(this.tarName + ".tmp"));
            is = new FileInputStream(this.tarName + ".tmp");
            os = new FileOutputStream(this.tarName);
            if (this.compressed) {
                is = new GZIPInputStream(is);
                os = new GZIPOutputStream(os);
            }
            TarInputStream tarIn = new TarInputStream(is);
            TarOutputStream tarOut = new TarOutputStream(os);
            while ((te = tarIn.getNextEntry()) != null) {
                int nb;
                if (te.getName().equals("././@LongLink")) {
                    fileName = this.getLongLink(tarIn);
                    if (fileName.equals(path.toString())) {
                        tarIn.getNextEntry();
                        continue;
                    }
                    tarOut.putNextEntry(te);
                    tarOut.write(fileName.getBytes(), 0, fileName.length());
                    tarOut.closeEntry();
                    continue;
                }
                if (fileName == null && te.getName().equals(path.toString())) continue;
                tarOut.putNextEntry(te);
                while ((nb = tarIn.read(_buff, 0, _buff.length)) != -1) {
                    tarOut.write(_buff, 0, nb);
                }
                tarOut.closeEntry();
                fileName = null;
            }
            tarOut.closeEntry();
            tarOut.close();
            tarIn.close();
        }
        catch (IOException ioex) {
            new ErrorConcept("error", "removeFailed", "Could not remove '" + path.toString() + "' from '" + this.tarName + "'.\n" + ioex.getMessage());
        }
    }

    public void extractAll(StringConcept dir) {
        this.extract(dir.toString(), null);
    }

    public void extract(StringConcept dir, StringConcept path) {
        this.extract(dir.toString(), path.toString());
    }

    public ConceptDefinition getConceptDefinition() {
        return TarDefinition.getReference();
    }

    public Object clone() {
        return this;
    }

    private final void extract(String directory, String path) {
        InputStream f = null;
        TarEntry te = null;
        String fileName = null;
        try {
            File currentDir;
            if (!directory.endsWith(File.separator)) {
                directory = directory.concat(File.separator);
            }
            if (!(currentDir = new File(directory)).exists()) {
                currentDir.mkdirs();
            }
            f = new FileInputStream(this.tarName);
            if (this.compressed) {
                f = new GZIPInputStream(f);
            }
            TarInputStream in = new TarInputStream(new BufferedInputStream(f));
            while ((te = in.getNextEntry()) != null) {
                if (te.getName().equals("././@LongLink")) {
                    fileName = this.getLongLink(in);
                    continue;
                }
                if (fileName == null) {
                    fileName = te.getName();
                }
                if (path != null && !fileName.equals(path)) {
                    fileName = null;
                    continue;
                }
                String dest = directory.concat(fileName);
                fileName = null;
                File filetemp = new File(dest);
                if (filetemp.exists()) {
                    new ErrorConcept("warning", "fileExist", filetemp.toString() + " already exists");
                }
                if (!te.isDirectory()) {
                    int nb;
                    File _dir;
                    if (filetemp.getPath() != null && !(_dir = new File(filetemp.getParent())).exists()) {
                        _dir.mkdirs();
                    }
                    filetemp.createNewFile();
                    FileOutputStream out = new FileOutputStream(new String(dest));
                    byte[] _buff = new byte[32768];
                    while ((nb = in.read(_buff)) != -1) {
                        out.write(_buff, 0, nb);
                    }
                    out.flush();
                    out.close();
                    continue;
                }
                filetemp.mkdirs();
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            new ErrorConcept("error", "readFailed", "Could not read '" + this.tarName + "'.\n" + e.getMessage());
        }
        catch (IOException ioex) {
            new ErrorConcept("error", "readFailed", "Could not read '" + this.tarName + "'.\n" + ioex.getMessage());
        }
    }

    private final void addDirectory(TarOutputStream out, String path) {
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileList = file.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    if (fileList[i].isDirectory()) {
                        this.addDirectory(out, fileList[i].getPath());
                    } else if (fileList[i].isFile()) {
                        this.addFile(out, fileList[i].getPath());
                    }
                    ++i;
                }
            } else if (file.isFile()) {
                this.addFile(out, path);
            }
        } else {
            new ErrorConcept("error", "pathNotFound", "Directory or file '" + path + "' doesn't exists.");
        }
    }

    private final void addFile(TarOutputStream out, String path) {
        try {
            this.addIS(out, new FileInputStream(path), path, (int)new File(path).length());
        }
        catch (IOException ioex) {
            new ErrorConcept("warning", "addtoTarFailed", "Could not add '" + path + "' file to '" + this.tarName + "'.\n" + ioex.getMessage());
        }
    }

    private final void addIS(TarOutputStream out, InputStream is, String path, int length) {
        try {
            int nr;
            if (path.startsWith(File.separator)) {
                path = path.substring(1);
            }
            if (path.length() >= 100) {
                TarEntry te = new TarEntry("././@LongLink", path.length());
                out.putNextEntry(te);
                out.write(path.getBytes(), 0, path.length());
                out.closeEntry();
                path = path.substring(0, 100);
            }
            BufferedInputStream in = new BufferedInputStream(is);
            TarEntry te = new TarEntry(path, length);
            out.putNextEntry(te);
            byte[] buf = new byte[32768];
            while ((nr = in.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, nr);
            }
            in.close();
            out.closeEntry();
        }
        catch (IOException ioex) {
            new ErrorConcept("warning", "addtoTarFailed", "Could not add '" + path + "' file to '" + this.tarName + "'.\n" + ioex.getMessage());
        }
    }

    private final void readd(TarInputStream in, TarOutputStream out) {
        String fName = "";
        TarEntry te = null;
        byte[] _buff = new byte[32768];
        try {
            while ((te = in.getNextEntry()) != null) {
                int nb;
                out.putNextEntry(te);
                while ((nb = in.read(_buff, 0, _buff.length)) != -1) {
                    out.write(_buff, 0, nb);
                }
                out.closeEntry();
            }
        }
        catch (IOException ioex) {
            new ErrorConcept("warning", "addtoTarFailed", "Could not readd '" + fName + "' file to '" + this.tarName + "'.\n" + ioex.getMessage());
        }
    }

    private final String getLongLink(TarInputStream tarIn) throws IOException {
        int nb;
        StringBuffer fileName = new StringBuffer();
        byte[] _buff = new byte[32768];
        while ((nb = tarIn.read(_buff, 0, _buff.length)) != -1) {
            fileName.append(new String(_buff, 0, nb));
        }
        return fileName.toString().trim();
    }
}

