/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.util.Vector;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.Helper;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.Element;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.TypedSeriesDefinition;
import org.media.mn8.mn8Loader;
import org.media.mn8.mn8RuntimeFlags;

public class TypedSeries
extends SeriesConcept {
    protected StringConcept _type = new StringConcept("Nil");
    protected StringConcept _label = null;

    public TypedSeries create(StringConcept type) {
        this._type = type;
        return this;
    }

    public TypedSeries create(StringConcept type, SeriesConcept values) {
        this.addSeries(values);
        this._type = type;
        return this;
    }

    public Concept createNewEntry() {
        JavaConcept instance = mn8Loader.instantiateConcept(this._type.toString());
        if (this._label != null) {
            instance.setConceptLabel(this._label);
        }
        super.add(instance);
        return this.lastEntry();
    }

    public void addEntry(Concept value) {
        this.createNewEntry();
        ElementConcept last = (ElementConcept)this._contents.elementAt(this._contents.size() - 1);
        last.setValue(value);
    }

    public Concept lastEntry() {
        if (this._contents.size() <= 0) {
            return new NilConcept();
        }
        return this.elementAt(this._contents.size());
    }

    public void add(Concept value) {
        if (!this._type.toString().equalsIgnoreCase("nil") && this._label != null) {
            value.setConceptLabel(this._label);
            super.add(value);
        } else {
            super.add(value);
        }
    }

    public void setType(StringConcept type) {
        this._type = type;
    }

    public StringConcept getType() {
        return this._type;
    }

    public Object clone() {
        return new TypedSeries((Vector)this._contents.clone(), this._type.toString());
    }

    public void loadContent(Concept from) {
        if (mn8RuntimeFlags.isDebug()) {
            System.err.println("--> in typed:" + Helper.getConceptInfo(this) + "->" + Helper.getConceptInfo(from));
        }
        if (from instanceof SeriesConcept) {
            ConceptDefinition def = mn8Loader.getConceptDefinition(this._type.toString());
            Vector elements = ((SeriesConcept)from).getVector();
            Concept el = null;
            int i = 0;
            while (i < elements.size()) {
                el = (Concept)elements.elementAt(i);
                if (el.getConceptType().toString().equalsIgnoreCase(this._type.toString())) {
                    this.add(el);
                } else if (el instanceof Element && (def.getConceptLabel().toString().equalsIgnoreCase(el.getConceptLabel().toString()) || this._type.toString().equalsIgnoreCase("nil") || this._type.toString().equalsIgnoreCase("element"))) {
                    this.createNewEntry();
                    ((Concept)this._contents.elementAt(this._contents.size() - 1)).loadContent(from);
                    this.updateNameCache();
                    this.updateNavigationFans();
                }
                ++i;
            }
        } else {
            ConceptDefinition def = mn8Loader.getConceptDefinition(this._type.toString());
            if (this.getConceptLabel().toString().equalsIgnoreCase(from.getConceptLabel().toString()) || this._type.toString().equalsIgnoreCase("nil") || this._type.toString().equalsIgnoreCase("element")) {
                this.createNewEntry();
                ((Concept)this._contents.elementAt(this._contents.size() - 1)).loadContent(from);
                this.updateNameCache();
                this.updateNavigationFans();
            }
        }
    }

    public ConceptDefinition getConceptDefinition() {
        return TypedSeriesDefinition.getReference();
    }

    public TypedSeries() {
        LogicalConcept true_value = new LogicalConcept(true);
        this.length.setHidden(true_value);
        this.index.setHidden(true_value);
        this.hasPrevious.setHidden(true_value);
        this.hasNext.setHidden(true_value);
    }

    public TypedSeries(String type, String typeLabel) {
        this._type = new StringConcept(type);
        if (typeLabel != null) {
            this._label = new StringConcept(typeLabel);
        }
    }

    public TypedSeries(Vector values) {
        super(values);
    }

    public TypedSeries(Vector values, String type) {
        super(values);
        this._type = new StringConcept(type);
    }
}

