/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.naming.NamingException;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.NamingManager;
import org.media.mn8.concepts.AttributeConcept;
import org.media.mn8.concepts.ElementConcept;
import org.media.mn8.concepts.FileHandlerDefinition;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIDefinition;
import org.media.mn8.concepts.URIHandler;
import org.media.mn8.concepts.URIHandlerDefinition;
import org.media.mn8.event.mn8NoURIHandler;
import org.media.mn8.mn8Loader;
import org.media.mn8.mn8Method;

public class URI
extends JavaConcept {
    public AttributeConcept uri = new AttributeConcept("uri", "uri", new NilConcept());
    public AttributeConcept contentType = new AttributeConcept("contentType", "contentType", new NilConcept());
    public AttributeConcept length = new AttributeConcept("length", "length", new IntegerConcept(-1L));
    public ElementConcept options = new ElementConcept("opt", "opt", new MapConcept(), null);

    protected void init(StringConcept url) {
        try {
            URL _url = new URL(url.toString());
            URLConnection uc = _url.openConnection();
            this.length.setAttributeValue(new IntegerConcept(uc.getContentLength()));
            String _contentType = uc.getContentType();
            if (_contentType != null) {
                this.contentType.setAttributeValue(new StringConcept(_contentType));
            }
        }
        catch (MalformedURLException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public URI create(StringConcept url) {
        this.uri.setAttributeValue(url);
        this.init(url);
        return this;
    }

    public ConceptDefinition getConceptDefinition() {
        return URIDefinition.getReference();
    }

    public void setUri(StringConcept url) {
        this.length.setAttributeValue(new IntegerConcept(-1L));
        this.contentType.setAttributeValue(new NilConcept());
        this.uri.setAttributeValue(url);
        this.init(url);
    }

    public Concept getURIHandler() {
        int endpos = -1;
        String protocol = "file";
        if (this.uri.getAttributeType().toLowerCase().equals("string")) {
            String handlerConceptType;
            ConceptDefinition handlerDef;
            Object uhandler;
            endpos = this.uri.getAttributeValue().toString().indexOf(":");
            if (endpos != -1) {
                protocol = this.uri.getAttributeValue().toString().substring(0, endpos);
            } else {
                String _uri = this.uri.getAttributeValue().toString().trim();
                if (!_uri.startsWith("/")) {
                    _uri = "/" + _uri;
                }
                this.uri.setAttributeValue(new StringConcept("file:" + _uri));
            }
            try {
                NamingManager.getReference();
                uhandler = NamingManager.lookup("mem:/system/protocols/" + protocol);
                if (uhandler != null && ((URIHandlerDefinition)(handlerDef = (URIHandlerDefinition)mn8Loader.getConceptDefinition(handlerConceptType = ((StringConcept)uhandler).toString()))).acceptsURI((StringConcept)this.uri.getAttributeValue()).getValue()) {
                    return ((URIHandler)((URIHandlerDefinition)handlerDef).getConceptInstance()).create((StringConcept)this.uri.getAttributeValue());
                }
            }
            catch (NamingException nex) {
                // empty catch block
            }
            try {
                StringConcept methodName;
                uhandler = null;
                try {
                    NamingManager.getReference();
                    uhandler = NamingManager.lookup("env:/system/protocols/" + protocol);
                }
                catch (NamingException ex) {
                    if (((FileHandlerDefinition)FileHandlerDefinition.getReference()).acceptsURI((StringConcept)this.uri.getAttributeValue()).getValue()) {
                        uhandler = FileHandlerDefinition.getReference().getConceptType();
                    }
                    throw new NamingException(ex.getMessage());
                }
                if (uhandler != null && (handlerDef = mn8Loader.getConceptDefinition(handlerConceptType = ((StringConcept)uhandler).toString())).hasConceptMethod(methodName = new StringConcept("acceptsURI:String")).getValue()) {
                    mn8Method method = handlerDef.getConceptMethod(methodName);
                    SeriesConcept param = new SeriesConcept();
                    param.add((StringConcept)this.uri.getAttributeValue());
                    Concept concept = handlerDef.getConceptInstance();
                    Concept result = method.invoke(concept, param);
                    if (result instanceof LogicalConcept && ((LogicalConcept)result).getValue()) {
                        method = handlerDef.getConceptConstructor(new StringConcept("create:String"));
                        result = method.invoke(concept, param);
                        return result;
                    }
                    return new NilConcept();
                }
            }
            catch (NamingException nex) {
                throw new mn8NoURIHandler(protocol);
            }
        }
        throw new mn8NoURIHandler(protocol);
    }

    public Object clone() {
        URI newuri = new URI();
        newuri.uri = (AttributeConcept)this.uri.clone();
        newuri.contentType = (AttributeConcept)this.contentType.clone();
        newuri.length = (AttributeConcept)this.length.clone();
        newuri.options = (ElementConcept)this.options.clone();
        return newuri;
    }

    public URI() {
    }

    public URI(StringConcept url) {
        this.uri.setAttributeValue(url);
        this.init(url);
    }
}

