/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.DateConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.IntegerConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.RealConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.XMLRPCClientConceptDefinition;

public class XMLRPCClientConcept
extends JavaConcept {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 10300;
    private static final String DEFAULT_USER = "guest";
    private static final String DEFAULT_PWD = "guest";
    protected URL _url;
    protected XmlRpcClient _client;
    private StringConcept DEFAULT_URL = new StringConcept("xmlrpc://guest:guest@localhost:10300/");

    public XMLRPCClientConcept create(StringConcept url) {
        this.initialize(url);
        return this;
    }

    protected boolean initialize(StringConcept url) {
        URL givenURL = null;
        try {
            givenURL = new URL(url.toString());
            if (givenURL == null || givenURL.getProtocol().equalsIgnoreCase("xmlrpc")) {
                if (givenURL != null) {
                    this._url = givenURL;
                    String _host = givenURL.getHost();
                    int _port = givenURL.getPort();
                    String ui = givenURL.getUserInfo();
                    String _user = null;
                    String _pwd = null;
                    if (ui != null) {
                        if (ui.indexOf(":") != -1) {
                            _user = ui.substring(0, ui.indexOf(":"));
                            _pwd = ui.substring(ui.indexOf(":") + 1);
                        } else {
                            _user = ui;
                        }
                    }
                    if (_host == null || _host.length() < 1) {
                        _host = DEFAULT_HOST;
                    }
                    if (_port == -1) {
                        _port = 10300;
                    }
                    if (_user != null && _user.length() < 1) {
                        _user = null;
                    }
                    if (_pwd != null && _pwd.length() < 1) {
                        _pwd = null;
                    }
                    this._client = new XmlRpcClient("http://" + _host + ":" + _port + "/");
                    if (_user != null && _pwd != null) {
                        this._client.setBasicAuthentication(_user, _pwd);
                    }
                }
            } else if (givenURL != null) {
                this._client = new XmlRpcClient(givenURL.toString());
            } else {
                new ErrorConcept("error", "unsupportedProtocol", "'" + givenURL.getProtocol() + "' protocol not supported by XMLRPCClient");
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return false;
        }
        return true;
    }

    public Concept executeCmd(StringConcept method, SeriesConcept params) {
        try {
            Vector<Object> _param = new Vector<Object>();
            int i = 0;
            while (i < params.getValue().size()) {
                if (params.getValue().elementAt(i) instanceof StringConcept) {
                    StringConcept param = (StringConcept)params.getValue().elementAt(i);
                    _param.add(param.toString());
                } else if (params.getValue().elementAt(i) instanceof LogicalConcept) {
                    _param.add(new Boolean(((LogicalConcept)params.getValue().elementAt(i)).getValue()));
                } else if (params.getValue().elementAt(i) instanceof IntegerConcept) {
                    _param.add(new Integer(((IntegerConcept)params.getValue().elementAt(i)).getInt()));
                } else if (params.getValue().elementAt(i) instanceof RealConcept) {
                    Float fl = new Float(((RealConcept)params.getValue().elementAt(i)).getFloat());
                    _param.add(new Double(fl.doubleValue()));
                } else if (params.getValue().elementAt(i) instanceof DateConcept) {
                    _param.add(new Date(((DateConcept)params.getValue().elementAt(i)).getValue()));
                } else if (params.getValue().elementAt(i) instanceof MapConcept) {
                    Hashtable htable = new Hashtable();
                    MapConcept map = (MapConcept)params.getValue().elementAt(i);
                    int j = 0;
                    while (j < map.getLength()) {
                        htable.put(map.getKeyVector().elementAt(j), map.getValuesVector().elementAt(j));
                        ++j;
                    }
                    _param.add(htable);
                } else if (params.getValue().elementAt(i) instanceof SeriesConcept) {
                    _param.add(((SeriesConcept)params.getValue().elementAt(i)).getValue());
                }
                ++i;
            }
            Object obj = this._client.execute(method.toString(), _param);
            return this.getConcept(obj);
        }
        catch (XmlRpcException ex) {
            new ErrorConcept("error", "executeFailed", "XMLRPC -> " + ex.getMessage());
            return new StringConcept("");
        }
        catch (Exception _ex) {
            new ErrorConcept("error", "executeFailed", _ex.getMessage());
            return new StringConcept("");
        }
    }

    public Concept getConcept(Object obj) {
        if (obj instanceof String) {
            return this.getStringConcept(obj);
        }
        if (obj instanceof Integer) {
            return this.getIntegerConcept(obj);
        }
        if (obj instanceof Boolean) {
            return this.getLogicalConcept(obj);
        }
        if (obj instanceof Double) {
            return this.getRealConcept(obj);
        }
        if (obj instanceof Date) {
            return this.getDateConcept(obj);
        }
        if (obj instanceof Hashtable) {
            return this.getMapConcept(obj);
        }
        if (obj instanceof Vector) {
            return this.getSeriesConcept(obj);
        }
        if (obj.getClass().isArray()) {
            byte[] data = (byte[])obj;
            return new StringConcept(new String(data));
        }
        return new StringConcept((String)obj);
    }

    public ConceptDefinition getConceptDefinition() {
        return XMLRPCClientConceptDefinition.getReference();
    }

    public Object clone() {
        return this;
    }

    private final StringConcept getStringConcept(Object obj) {
        return new StringConcept((String)obj);
    }

    private final IntegerConcept getIntegerConcept(Object obj) {
        return new IntegerConcept(((Integer)obj).longValue());
    }

    private final LogicalConcept getLogicalConcept(Object obj) {
        return new LogicalConcept((Boolean)obj);
    }

    private final RealConcept getRealConcept(Object obj) {
        return new RealConcept(((Double)obj).floatValue());
    }

    private final DateConcept getDateConcept(Object obj) {
        return new DateConcept(new IntegerConcept(((Date)obj).getTime()));
    }

    private final MapConcept getMapConcept(Object obj) {
        return new MapConcept(this.getVector(((Hashtable)obj).keys()), this.getVector(((Hashtable)obj).elements()));
    }

    private final SeriesConcept getSeriesConcept(Object obj) {
        return new SeriesConcept(this.getVector(((Vector)obj).elements()));
    }

    private final Vector getVector(Enumeration en) {
        Vector<JavaConcept> result = new Vector<JavaConcept>();
        Enumeration e = en;
        while (e.hasMoreElements()) {
            Object _obj = e.nextElement();
            if (_obj instanceof String) {
                result.add(this.getStringConcept(_obj));
                continue;
            }
            if (_obj instanceof Integer) {
                result.add(this.getIntegerConcept(_obj));
                continue;
            }
            if (_obj instanceof Boolean) {
                result.add(this.getLogicalConcept(_obj));
                continue;
            }
            if (_obj instanceof Double) {
                result.add(this.getRealConcept(_obj));
                continue;
            }
            if (_obj instanceof Date) {
                result.add(this.getDateConcept(_obj));
                continue;
            }
            if (_obj instanceof Hashtable) {
                result.add(this.getMapConcept(_obj));
                continue;
            }
            if (_obj instanceof Vector) {
                result.add(this.getSeriesConcept(_obj));
                continue;
            }
            result.add(this.getStringConcept(_obj));
        }
        return result;
    }

    public XMLRPCClientConcept() {
        this.initialize(this.DEFAULT_URL);
    }

    public XMLRPCClientConcept(StringConcept url) {
        this.initialize(url);
    }
}

