/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.net.URL;
import java.util.StringTokenizer;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.MapConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandler;
import org.media.mn8.concepts.URIHandlerDefinition;
import org.media.mn8.concepts.XMLRPCClientConcept;
import org.media.mn8.concepts.XMLRPCHandlerDefinition;

public class XMLRPCHandler
extends URIHandler {
    private String _url = null;
    private String _uname = null;
    private String _pwd = null;
    private MapConcept _options;
    private XMLRPCClientConcept _client;

    public URIHandler create(StringConcept url) {
        this._url = url.toString();
        return this;
    }

    public LogicalConcept acceptsURI(StringConcept uri) {
        return ((URIHandlerDefinition)this.getConceptDefinition()).acceptsURI(uri);
    }

    public LogicalConcept initialize(MapConcept options) {
        URL givenURL = null;
        this._options = options;
        if (options.containsKey(new StringConcept("user")).getValue()) {
            this._uname = options.getValue(new StringConcept("user")).toTXT().toString();
        }
        if (options.containsKey(new StringConcept("pwd")).getValue()) {
            this._pwd = options.getValue(new StringConcept("pwd")).toTXT().toString();
        }
        try {
            givenURL = new URL(this._url);
            if (givenURL != null && givenURL.getProtocol().equalsIgnoreCase("xmlrpc") && this._uname != null && this._uname.trim().length() > 0 && this._pwd != null && this._pwd.trim().length() > 0) {
                this._url = givenURL.getProtocol() + "://";
                this._url = this._url + this._uname + ":" + this._pwd + "@";
                if (givenURL.getHost() != null) {
                    this._url = this._url + givenURL.getHost();
                }
                if (givenURL.getPort() != -1) {
                    this._url = this._url + ":" + givenURL.getPort();
                }
                if (givenURL.getPath() != null) {
                    this._url = this._url + givenURL.getPath();
                }
                if (givenURL.getQuery() != null) {
                    this._url = this._url + "?" + givenURL.getQuery();
                }
                if (givenURL.getRef() != null) {
                    this._url = this._url + "#" + givenURL.getRef();
                }
            }
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return new LogicalConcept(false);
        }
        return new LogicalConcept(true);
    }

    public LogicalConcept closeConnection() {
        return new LogicalConcept(true);
    }

    public LogicalConcept openConnection() {
        this._client = new XMLRPCClientConcept(new StringConcept(this._url));
        return new LogicalConcept(true);
    }

    public Concept getContent() {
        String methodName = "";
        SeriesConcept params = new SeriesConcept();
        try {
            URL url = new URL(this._url);
            String file = url.getFile();
            String qu = url.getQuery();
            if (file.equals("/") || file.trim().length() < 1) {
                new ErrorConcept("error", "missingMethod", "Missing method parameter from URL");
                return new StringConcept("");
            }
            methodName = file.indexOf("?") < 0 ? file.substring(1) : file.substring(1, file.indexOf("?"));
            if (methodName.indexOf(".") < 0) {
                new ErrorConcept("error", "badMathod", "The method name must contain the handler eg.:\nxmlrpc://user:password@host:port/handler.method?param1=...&param2=...&...");
                return new StringConcept("");
            }
            if (qu == null || qu.indexOf("=") < 0) {
                new ErrorConcept("error", "badQuery", "The query structure is: ?name1=parameter1&name2=parameter2&...\n");
                return new StringConcept("");
            }
            if (qu.trim().length() != 0) {
                StringTokenizer pt = new StringTokenizer(qu, "&");
                while (pt.hasMoreTokens()) {
                    String t = pt.nextToken();
                    params.add(new StringConcept(t.substring(t.indexOf("=") + 1)));
                }
            }
            return this._client.executeCmd(new StringConcept(methodName), params);
        }
        catch (Exception ex) {
            new ErrorConcept("error", "badURL", ex.getMessage());
            return new StringConcept("");
        }
    }

    public LogicalConcept setContent(Concept value) {
        return new LogicalConcept(false);
    }

    public ConceptDefinition getConceptDefinition() {
        return XMLRPCHandlerDefinition.getReference();
    }

    public Object clone() {
        if (this._url != null) {
            return new XMLRPCHandler(new StringConcept(this._url));
        }
        return new URIHandler();
    }

    public XMLRPCHandler() {
    }

    public XMLRPCHandler(StringConcept url) {
        this._url = url.toString();
    }
}

