/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.net.MalformedURLException;
import java.net.URL;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.concepts.LogicalConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.URIHandlerDefinition;
import org.media.mn8.concepts.XMLRPCHandler;
import org.media.mn8.mn8JavaMethod;

public class XMLRPCHandlerDefinition
extends URIHandlerDefinition {
    private static SeriesConcept _inheritedConcepts = new SeriesConcept("Concept");
    private static XMLRPCHandlerDefinition _reference = new XMLRPCHandlerDefinition();

    public LogicalConcept acceptsURI(StringConcept uri) {
        try {
            URL url = new URL(uri.toString());
            if (url.getProtocol().equalsIgnoreCase("xmlrpc")) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
        catch (MalformedURLException ex) {
            if (uri.toString().toLowerCase().startsWith("xmlrpc:")) {
                return new LogicalConcept(true);
            }
            return new LogicalConcept(false);
        }
    }

    public static ConceptDefinition getReference() {
        return _reference;
    }

    public Concept getConceptInstance() {
        return new XMLRPCHandler();
    }

    public StringConcept getConceptLabel() {
        return new StringConcept("XMLRPCHandler");
    }

    public StringConcept getConceptType() {
        return new StringConcept("XMLRPCHandler");
    }

    public SeriesConcept getInheritedConcepts() {
        return _inheritedConcepts;
    }

    protected XMLRPCHandlerDefinition() {
        try {
            _inheritedConcepts.add(new StringConcept("URIHandler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.XMLRPCHandler", "initialize:org.media.mn8.concepts.MapConcept", "initialize:Map", "XMLRPCHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.XMLRPCHandler", "closeConnection:", "closeConnection:", "XMLRPCHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.XMLRPCHandler", "openConnection:", "openConnection:", "XMLRPCHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.XMLRPCHandler", "getContent:", "getContent:", "XMLRPCHandler", "Concept"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.XMLRPCHandler", "setContent:org.media.mn8.Concept", "setContent:Concept", "XMLRPCHandler", "Logical"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.XMLRPCHandler", "create:org.media.mn8.concepts.StringConcept", "create:String", "XMLRPCHandler", "XMLRPCHandler"));
            this.putMethod(new mn8JavaMethod("org.media.mn8.concepts.XMLRPCHandlerDefinition", true, "acceptsURI:org.media.mn8.concepts.StringConcept", "acceptsURI:String", "XMLRPCHandler", "Logical"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

