/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.concepts;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.Helper;
import org.media.mn8.JavaConcept;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.concepts.ZipDefinition;
import org.media.mn8.mn8RuntimeFlags;

public class ZipConcept
extends JavaConcept {
    private String zipName;
    private Hashtable zip;
    private ZipOutputStream zipOut;
    private ZipFile zipIn;

    public ZipConcept create(StringConcept path) {
        this.zipName = path.toString();
        this.zip = new Hashtable();
        if (new File(this.zipName).exists()) {
            this.readZip();
        } else {
            try {
                URL url = new URL(this.zipName);
                this.zipName = url.toString();
                this.readZip();
            }
            catch (MalformedURLException mex) {
                new ErrorConcept("error", "openZipFailed", "Unable to open '" + this.zipName + "' zip file." + "\nThe error seems to be:" + mex.getMessage());
            }
        }
        return this;
    }

    public void add(StringConcept path) {
        boolean exists = new File(this.zipName).exists();
        try {
            if (exists) {
                new File(this.zipName).renameTo(new File(this.zipName + ".tmp"));
                this.zipIn = new ZipFile(this.zipName + ".tmp");
            }
            this.zipOut = new ZipOutputStream(new FileOutputStream(this.zipName));
            if (exists) {
                this.readd();
            }
            this.addDirectory(path.toString());
            this.zipOut.close();
            if (exists) {
                this.zipIn.close();
                new File(this.zipName + ".tmp").delete();
            }
        }
        catch (IOException ioe) {
            new ErrorConcept("error", "openZipFailed", "Unable to open '" + this.zipName + "' zip file.");
        }
    }

    public void add(StringConcept text, StringConcept path) {
        boolean exists = new File(this.zipName).exists();
        try {
            if (exists) {
                new File(this.zipName).renameTo(new File(this.zipName + ".tmp"));
                this.zipIn = new ZipFile(this.zipName + ".tmp");
            }
            this.zipOut = new ZipOutputStream(new FileOutputStream(this.zipName));
            if (exists) {
                this.readd();
            }
            this.addIS(new ByteArrayInputStream(text.toString().getBytes()), path.toString());
            this.zipOut.close();
            if (exists) {
                this.zipIn.close();
                new File(this.zipName + ".tmp").delete();
            }
        }
        catch (IOException ioe) {
            new ErrorConcept("error", "openZipFailed", "Unable to open '" + this.zipName + "' zip file.");
        }
    }

    public SeriesConcept list() {
        SeriesConcept result = new SeriesConcept();
        Enumeration e = this.zip.keys();
        while (e.hasMoreElements()) {
            result.add(new StringConcept((String)e.nextElement()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public StringConcept view(StringConcept path) {
        try {
            ZipEntry ze;
            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.zipName)));
            while ((ze = zin.getNextEntry()) != null) {
                int c;
                void var3_4;
                if (!var3_4.getName().equals(path.toString())) continue;
                StringBuffer result = new StringBuffer();
                while ((c = ((InflaterInputStream)zin).read()) != -1) {
                    void var5_6;
                    result.append((char)var5_6);
                }
                zin.close();
                return new StringConcept(result.toString());
            }
            zin.close();
            new ErrorConcept("error", "pathNotFound", "File '" + path + "' doesn't exists.");
        }
        catch (IOException ioex) {
            new ErrorConcept("error", "readFailed", "Could not read '" + path.toString() + "' from  '" + this.zipName + "'.\n" + ioex.getMessage());
        }
        return new StringConcept("");
    }

    /*
     * WARNING - void declaration
     */
    public void delete(StringConcept path) {
        if (!new File(this.zipName).exists()) {
            new ErrorConcept("error", "openZipFailed", "Unable to open '" + this.zipName + "' zip file.");
            return;
        }
        try {
            new File(this.zipName).renameTo(new File(this.zipName + ".tmp"));
            this.zipIn = new ZipFile(this.zipName + ".tmp");
            this.zipOut = new ZipOutputStream(new FileOutputStream(this.zipName));
            Enumeration<? extends ZipEntry> e = this.zipIn.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (!ze.getName().equals(path.toString())) {
                    int c;
                    BufferedReader in = new BufferedReader(new InputStreamReader(this.zipIn.getInputStream(ze)));
                    this.zipOut.putNextEntry(ze);
                    while ((c = in.read()) != -1) {
                        void var2_4;
                        this.zipOut.write((int)var2_4);
                    }
                    in.close();
                    continue;
                }
                this.zip.remove(path.toString());
            }
            this.zipOut.close();
            this.zipIn.close();
        }
        catch (IOException ioex) {
            new ErrorConcept("error", "removeFailed", "Could not remove '" + path.toString() + "' from '" + this.zipName + "'.\n" + ioex.getMessage());
        }
    }

    public void extractAll(StringConcept dir) {
        this.extract(dir.toString(), null);
    }

    public void extract(StringConcept dir, StringConcept path) {
        this.extract(dir.toString(), path.toString());
    }

    public ConceptDefinition getConceptDefinition() {
        return ZipDefinition.getReference();
    }

    public Object clone() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private final void extract(String directory, String path) {
        String dst = null;
        try {
            ZipEntry ze;
            File currentDir;
            if (!directory.endsWith(File.separator)) {
                directory = directory.concat(File.separator);
            }
            if (!(currentDir = new File(directory)).exists()) {
                currentDir.mkdirs();
            }
            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(this.getZipContentAsStream()));
            while ((ze = zin.getNextEntry()) != null) {
                String dest;
                void var6_8;
                if (path != null && !var6_8.getName().equals(path)) continue;
                dst = dest = Helper.fileNameFix(directory.concat(var6_8.getName()));
                File filetemp = new File(dest);
                if (!var6_8.isDirectory()) {
                    int c;
                    File _dir;
                    if (filetemp.getPath() != null && !(_dir = new File(filetemp.getParent())).exists()) {
                        _dir.mkdirs();
                    }
                    filetemp.createNewFile();
                    FileOutputStream out = new FileOutputStream(filetemp.toString());
                    while ((c = ((InflaterInputStream)zin).read()) != -1) {
                        void var10_12;
                        out.write((int)var10_12);
                    }
                    out.flush();
                    out.close();
                    continue;
                }
                filetemp.mkdirs();
            }
            zin.close();
        }
        catch (FileNotFoundException e) {
            if (mn8RuntimeFlags.isDebug()) {
                e.printStackTrace();
            }
            new ErrorConcept("error", "readFailed", "Could not read '" + this.zipName + "'.\n" + e.getMessage());
        }
        catch (IOException ioex) {
            if (mn8RuntimeFlags.isDebug()) {
                ioex.printStackTrace();
            }
            new ErrorConcept("error", "readFailed", "Error extracting zip file: " + dst + "\n" + ioex.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readZip() {
        try {
            ZipEntry ze;
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(this.getZipContentAsStream()));
            while ((ze = in.getNextEntry()) != null) {
                void var1_3;
                this.zip.put(var1_3.toString(), var1_3);
            }
            in.close();
        }
        catch (IOException ioe) {
            if (mn8RuntimeFlags.isDebug()) {
                ioe.printStackTrace();
            }
            new ErrorConcept("error", "openZipFailed", "Unable to open '" + this.zipName + "' zip file.");
        }
    }

    private final InputStream getZipContentAsStream() throws IOException {
        InputStream is = null;
        try {
            URL furl = new URL(this.zipName);
            is = furl.openStream();
        }
        catch (Exception ex) {
            is = new FileInputStream(this.zipName);
        }
        return is;
    }

    private final void addDirectory(String path) {
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileList = file.listFiles();
                int i = 0;
                while (i < fileList.length) {
                    if (fileList[i].isDirectory()) {
                        this.addDirectory(fileList[i].getPath());
                    } else if (fileList[i].isFile()) {
                        this.addFile(fileList[i].getPath());
                    }
                    ++i;
                }
            } else if (file.isFile()) {
                this.addFile(path);
            }
        } else {
            new ErrorConcept("error", "pathNotFound", "Directory or file '" + path + "' doesn't exists.");
        }
    }

    private final void addFile(String path) {
        try {
            this.addIS(new FileInputStream(path), path);
        }
        catch (IOException ioex) {
            new ErrorConcept("warning", "addtoZipFailed", "Could not add '" + path + "' file to '" + this.zipName + "'.\n" + ioex.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addIS(InputStream is, String path) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            ZipEntry zt = new ZipEntry(path);
            if (this.zip.get(zt.toString()) == null) {
                int c;
                this.zip.put(zt.toString(), zt);
                this.zipOut.putNextEntry(zt);
                while ((c = in.read()) != -1) {
                    void var3_6;
                    this.zipOut.write((int)var3_6);
                }
            } else {
                new ErrorConcept("warning", "addtoZipFailed", "Could not add '" + path + "' file to '" + this.zipName + "'.Already exists.");
            }
            in.close();
        }
        catch (IOException ioex) {
            new ErrorConcept("warning", "addtoZipFailed", "Could not add '" + path + "' file to '" + this.zipName + "'.\n" + ioex.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readd() {
        String fName = "";
        try {
            Enumeration<? extends ZipEntry> e = this.zipIn.entries();
            while (e.hasMoreElements()) {
                int c;
                ZipEntry ze = e.nextElement();
                BufferedReader in = new BufferedReader(new InputStreamReader(this.zipIn.getInputStream(ze)));
                this.zipOut.putNextEntry(ze);
                while ((c = in.read()) != -1) {
                    void var1_4;
                    this.zipOut.write((int)var1_4);
                }
                in.close();
            }
        }
        catch (IOException ioex) {
            new ErrorConcept("warning", "addtoZipFailed", "Could not readd '" + fName + "' file to '" + this.zipName + "'.\n" + ioex.getMessage());
        }
    }
}

