/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.conf;

import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NamingException;
import org.media.mn8.NamingManager;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8RuntimeFlags;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContextConf {
    private static ContextConf _reference = new ContextConf();
    private static Hashtable _bindsTable = new Hashtable();

    public void cleanAll() {
        _bindsTable.clear();
    }

    public void initialize(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equalsIgnoreCase("bind")) {
                this.extractBind(node);
            }
            node = node.getNextSibling();
        }
    }

    public static ContextConf getRef() {
        return _reference;
    }

    public void uploadBinds() {
        Iterator keys = _bindsTable.keySet().iterator();
        Object key = null;
        while (keys.hasNext()) {
            key = keys.next();
            try {
                if (((String)key).toLowerCase().startsWith("env:")) {
                    NamingManager.getReference();
                    NamingManager.envBind(key, new StringConcept((String)_bindsTable.get(key)));
                }
                if (!((String)key).toLowerCase().startsWith("mem:")) continue;
                NamingManager.getReference();
                NamingManager.bind(key, new StringConcept((String)_bindsTable.get(key)));
            }
            catch (NamingException nex) {
                if (!mn8RuntimeFlags.isDebug()) continue;
                nex.printStackTrace();
            }
        }
    }

    protected void extractBind(Node pathNode) {
        String path = ((Element)pathNode).getAttribute("path");
        String value = ((Element)pathNode).getAttribute("value");
        if (path != null && value != null) {
            _bindsTable.put(path, value);
        }
    }

    protected ContextConf() {
    }
}

