/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.conf;

import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.NamingException;
import org.media.mn8.NamingManager;
import org.media.mn8.concepts.StringConcept;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaConceptsConf {
    private static JavaConceptsConf _reference = new JavaConceptsConf();
    private static Hashtable _javaConceptsTable = new Hashtable();

    public void cleanAll() {
        _javaConceptsTable.clear();
    }

    public void initialize(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equalsIgnoreCase("concept")) {
                this.extractJavaConcept(node);
            }
            node = node.getNextSibling();
        }
    }

    public static JavaConceptsConf getRef() {
        return _reference;
    }

    public void uploadJavaConcepts() {
        Iterator keys = _javaConceptsTable.keySet().iterator();
        Object key = null;
        while (keys.hasNext()) {
            key = keys.next();
            try {
                NamingManager.getReference();
                NamingManager.envBind("env://concept/javaConcepts/" + key, new StringConcept((String)_javaConceptsTable.get(key)));
            }
            catch (NamingException nex) {
                System.err.println(nex.getMessage());
            }
        }
    }

    protected void extractJavaConcept(Node pathNode) {
        String name = ((Element)pathNode).getAttribute("name");
        String className = ((Element)pathNode).getAttribute("class");
        if (name != null && className != null) {
            _javaConceptsTable.put(name, className);
        }
    }

    protected JavaConceptsConf() {
    }
}

