/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.conf;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.media.mn8.LogManager;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.conf.ConceptsConf;
import org.media.mn8.conf.ContextConf;
import org.media.mn8.conf.JavaPropertiesConf;
import org.media.mn8.conf.NamingHandlerBase;
import org.media.mn8.util.SimpleExpression;
import org.media.mn8.util.SystemEnvReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class NamingConf {
    public static final String _SYSTEM_OUT_URI = "env://system/out";
    public static final String _SYSTEM_ERR_URI = "env://system/err";
    public static final String _SYSTEM_IN_URI = "env://system/err";
    private static final String _NAMING_CONFIG_FILE = "/conf/mn8config.xml";
    private static NamingHandlerBase _namingHandler = new NamingHandlerBase();
    private static NamingConf _namingConf = new NamingConf();
    private static Hashtable _envLoad = null;

    public static void cleanAll() {
        _envLoad.clear();
    }

    public static NamingConf getReference() {
        return _namingConf;
    }

    public Hashtable getInitialContextProperties() {
        return _namingHandler.getInitialContextProperties();
    }

    public Hashtable getEnvProperties() {
        Vector<String> loadPatterns = _namingHandler.getEnvLoad();
        Vector exceptPatterns = _namingHandler.getEnvLoadExcept();
        Properties sysProp = System.getProperties();
        _envLoad = new Hashtable();
        if (loadPatterns == null) {
            loadPatterns = new Vector<String>();
        }
        if (loadPatterns.size() < 1) {
            loadPatterns.add("*");
        }
        if (exceptPatterns == null) {
            exceptPatterns = new Vector();
        }
        _envLoad.put(_SYSTEM_OUT_URI, new StringConcept("System.out"));
        _envLoad.put("env://system/err", new StringConcept("System.err"));
        _envLoad.put("env://system/in", new StringConcept("System.in"));
        this.applyEnvLoadConditions(sysProp, loadPatterns, exceptPatterns);
        this.applyEnvLoadConditions(this.getSystemEnvironment(), loadPatterns, exceptPatterns);
        return _envLoad;
    }

    public String getEnvMapping() {
        return _namingHandler.getEnvMapping();
    }

    public String getMemMapping() {
        return _namingHandler.getMemMapping();
    }

    private final void applyEnvLoadConditions(Properties from, Vector loadPatterns, Vector exceptPatterns) {
        Enumeration<?> propEnum = from.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propKey = (String)propEnum.nextElement();
            boolean isExcept = false;
            int cnt = 0;
            while (cnt < loadPatterns.size() && !isExcept) {
                if (SimpleExpression.match(propKey, (String)loadPatterns.elementAt(cnt))) {
                    int i = 0;
                    while (i < exceptPatterns.size() && !isExcept) {
                        if (SimpleExpression.match(propKey, (String)exceptPatterns.elementAt(i))) {
                            isExcept = true;
                        }
                        ++i;
                    }
                }
                ++cnt;
            }
            if (isExcept) continue;
            _envLoad.put("env://system/properties/" + propKey, new StringConcept(from.getProperty(propKey)));
        }
    }

    private final Properties getSystemEnvironment() {
        Hashtable osCmdEnvMap = _namingHandler.getEnvCommands();
        String currentOs = System.getProperty("os.name");
        String cmd = "";
        Properties result = null;
        if (osCmdEnvMap == null || osCmdEnvMap.isEmpty()) {
            return null;
        }
        if (osCmdEnvMap.containsKey(currentOs.toLowerCase())) {
            cmd = (String)osCmdEnvMap.get(currentOs.toLowerCase());
        } else {
            Enumeration keys = osCmdEnvMap.keys();
            while (keys.hasMoreElements()) {
                String tmp_str = (String)keys.nextElement();
                if (currentOs.toLowerCase().indexOf(tmp_str) == -1) continue;
                cmd = (String)osCmdEnvMap.get(tmp_str);
            }
        }
        try {
            result = SystemEnvReader.getSystemEnvironment(cmd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private NamingConf() {
        block13: {
            Object streamNaminXML = null;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                Class<?> _thisClass = Class.forName("org.media.mn8.conf.NamingConf");
                URL resURL = _thisClass.getResource(_NAMING_CONFIG_FILE);
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setValidating(false);
                DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
                if (resURL != null) {
                    factory.setValidating(true);
                    SAXParser saxParser = factory.newSAXParser();
                    saxParser.parse(resURL.toString(), (DefaultHandler)_namingHandler);
                    Document document = domBuilder.parse(resURL.toString());
                    Node node = document.getDocumentElement().getFirstChild();
                    while (node != null) {
                        if (node.getNodeType() == 1) {
                            if (((Element)node).getTagName().equalsIgnoreCase("concepts")) {
                                ConceptsConf.getRef().initialize((Element)node);
                            } else if (((Element)node).getTagName().equalsIgnoreCase("java.properties")) {
                                JavaPropertiesConf.getRef().initialize((Element)node);
                            } else if (((Element)node).getTagName().equalsIgnoreCase("context")) {
                                ContextConf.getRef().initialize((Element)node);
                            }
                        }
                        node = node.getNextSibling();
                    }
                    break block13;
                }
                throw new RuntimeException();
            }
            catch (ClassNotFoundException cex) {
                LogManager.message("warning", "conf.file_missing", _NAMING_CONFIG_FILE);
                throw new RuntimeException();
            }
            catch (SAXParseException saxex) {
                LogManager.message("warning", "conf.parse_exception", "/conf/mn8config.xml\n" + saxex.getMessage());
                saxex.printStackTrace();
                throw new RuntimeException();
            }
            catch (RuntimeException rex) {
                LogManager.message("warning", "conf.file_missing", _NAMING_CONFIG_FILE);
                throw new RuntimeException();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

