/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import antlr.ASTFactory;
import antlr.BaseAST;
import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.collections.AST;
import antlr.debug.misc.ASTFrame;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.NamingException;
import org.media.mn8.Concept;
import org.media.mn8.ConceptRegister;
import org.media.mn8.ExecutionStack;
import org.media.mn8.GlobalScope;
import org.media.mn8.NamingManager;
import org.media.mn8.ScopeStack;
import org.media.mn8.concepts.ErrorConcept;
import org.media.mn8.concepts.NilConcept;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.conf.NamingConf;
import org.media.mn8.conf.StaticSystemSetup;
import org.media.mn8.event.mn8ExitEvent;
import org.media.mn8.mn8Concept;
import org.media.mn8.mn8ConceptDefinition;
import org.media.mn8.mn8EOLFixupTokenStream;
import org.media.mn8.mn8InterpretThread;
import org.media.mn8.mn8Loader;
import org.media.mn8.mn8RuntimeFlags;
import org.media.mn8.mn8ScriptMethod;
import org.media.mn8.parser.mn8Lexer;
import org.media.mn8.parser.mn8Parser;
import org.media.mn8.parser.mn8TokenTypes;
import org.media.mn8.parser.mn8TreeWalker;

public class mn8Interpreter {
    public static String VERSION = "0.6a";
    public static String IDENTIFIER = "MN8 Ver. " + VERSION + " [ http://mappa.mundi.net/spacemapper/ ]";
    private static NamingManager _namingManager = NamingManager.getReference();
    private static ConceptRegister _conceptRegister = ConceptRegister.getReference();
    private static mn8TreeWalker _currentTW = null;
    public static String EOL = System.getProperty("line.separator");
    private static Hashtable _outStreams = new Hashtable();
    private static Hashtable _errStreams = new Hashtable();
    private static Hashtable _inStreams = new Hashtable();
    private static Hashtable _interpreters = new Hashtable();
    public static PrintStream GLOBAL_OUT_STREAM = System.out;
    public static PrintStream GLOBAL_ERR_STREAM = System.err;
    public static InputStream GLOBAL_IN_STREAM = System.in;
    private String _scriptName = "";

    public static void reInitialize() {
        mn8Interpreter.cleanAll();
        System.gc();
        ConceptRegister.initialize();
        StaticSystemSetup.setup();
        mn8Interpreter.findEOLType();
        if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
            System.err.println("mn8 Reinitialization performed");
        }
    }

    private static final void cleanAll() {
        _currentTW = null;
        GlobalScope.cleanAll();
        ExecutionStack.cleanAll();
        ConceptRegister.getReference();
        ConceptRegister.cleanAll();
        StaticSystemSetup.cleanAll();
        mn8ScriptMethod.cleanAll();
        NamingConf.cleanAll();
    }

    public static void initialize() {
        StaticSystemSetup.setup();
        mn8Interpreter.findEOLType();
        if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
            System.err.println("mn8 Initialization performed");
        }
    }

    public static mn8TreeWalker getCurrentWalker() {
        return _currentTW;
    }

    public static final void executeURL(String scriptURL, SeriesConcept arguments) {
        mn8Interpreter.executeURL(scriptURL, null, arguments);
    }

    public static final void threadExecuteURLRun(String scriptURL, String concept, SeriesConcept arguments) {
        new mn8InterpretThread(scriptURL, concept, arguments).run();
    }

    public static final Thread threadExecuteURL(String scriptURL, String concept, SeriesConcept arguments) {
        mn8InterpretThread interpr = new mn8InterpretThread(scriptURL, concept, arguments);
        return interpr;
    }

    public static final void executeURL(String scriptURL, String concept, SeriesConcept arguments) {
        String conceptType = mn8Loader.loadConceptFromURL(scriptURL, concept);
        mn8ScriptMethod main = (mn8ScriptMethod)mn8Loader.getConceptDefinition(conceptType).getConceptMethod("main:series");
        if (main.isStatic().getValue()) {
            main.invoke(conceptType, arguments);
        }
    }

    public static final void interpret(String command) {
        block5: {
            try {
                String conceptType = new mn8Loader().loadConceptFromReader(new StringReader(command), null);
                mn8ScriptMethod main = (mn8ScriptMethod)mn8Loader.getConceptDefinition(conceptType).getConceptMethod("main:series");
                if (main.isStatic().getValue()) {
                    SeriesConcept arguments = new SeriesConcept();
                    arguments.add(new SeriesConcept());
                    main.invoke(conceptType, arguments);
                }
            }
            catch (mn8ExitEvent ev) {
                if (mn8RuntimeFlags.isDebug() || mn8RuntimeFlags.isVerbose()) {
                    System.err.println("Exit request received, exiting...");
                }
            }
            catch (Exception ex) {
                System.err.println("exception: " + ex);
                if (!mn8RuntimeFlags.isDebug()) break block5;
                System.err.println("/---: The stack trace is :----------------------------------\\");
                ex.printStackTrace();
                System.err.println("\\------------------------------------------------------------/");
            }
        }
    }

    static final synchronized Concept interpretAST(AST tree, mn8Concept on, mn8ScriptMethod method, ScopeStack scopeStack) {
        if (tree == null) {
            return null;
        }
        if (mn8RuntimeFlags.isShowTree()) {
            mn8ConceptDefinition mnConcDef = null;
            mnConcDef = on == null ? (mn8ConceptDefinition)mn8Loader.getConceptDefinition(method.getDeclaringConcept().toString()) : (mn8ConceptDefinition)mn8Loader.getConceptDefinition(on.getConceptType().getValue());
            CommonAST cfr_ignored_0 = (CommonAST)tree;
            BaseAST.setVerboseStringConversion((boolean)true, (String[])mnConcDef.getTokenNames());
            ASTFactory factory = new ASTFactory();
            AST r = factory.create(0, "AST ROOT");
            r.setFirstChild(tree);
            ASTFrame frame = new ASTFrame("mn8 " + mnConcDef.getConceptType().toString() + " AST", r);
            frame.setVisible(true);
        }
        try {
            mn8TreeWalker mn8TreeWalker2;
            _currentTW = mn8TreeWalker2 = new mn8TreeWalker();
            return mn8TreeWalker2.interpretationUnit(tree, on, method, scopeStack);
        }
        catch (mn8ExitEvent ev) {
            throw ev;
        }
        catch (RecognitionException ex) {
            new ErrorConcept("warning", "recognitionWarning", ex.toString());
            return new NilConcept();
        }
    }

    public static void interruptInterpret() {
        if (_currentTW != null) {
            _currentTW.exit();
        }
    }

    public static boolean isExitAsked() {
        if (_currentTW != null) {
            return mn8Interpreter._currentTW.readyToReturn;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static final mn8Parser parseTokenStream(TokenStream tokStream) {
        try {
            void ex;
            mn8Parser parser = new mn8Parser(tokStream);
            parser.mn8ScriptFile(null);
            return ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final mn8Parser parseTokenStream(TokenStream tokStream, String conceptName) {
        try {
            void ex;
            mn8Parser parser = new mn8Parser(tokStream);
            parser.mn8ScriptFile(conceptName);
            return ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static final TokenStream getLexer(Reader stream) {
        mn8Lexer mn8Lexer2 = new mn8Lexer(stream);
        mn8Lexer2.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        TokenStreamHiddenTokenFilter lexer = new TokenStreamHiddenTokenFilter((TokenStream)new mn8EOLFixupTokenStream(mn8Lexer2));
        lexer.hide(mn8TokenTypes.WS);
        lexer.hide(mn8TokenTypes.LCONT);
        if (mn8RuntimeFlags.isTrace()) {
            System.out.println("In trace!");
            try {
                Token tok = lexer.nextToken();
                while (tok.getText() != null) {
                    System.out.print(tok);
                    tok = lexer.nextToken();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.exit(0);
        }
        return lexer;
    }

    static final synchronized void preparingTreeAction(AST tree, String[] tokenNames) {
        if (tree == null) {
            return;
        }
        if (mn8RuntimeFlags.isShowTree()) {
            CommonAST cfr_ignored_0 = (CommonAST)tree;
            BaseAST.setVerboseStringConversion((boolean)true, (String[])tokenNames);
            ASTFactory factory = new ASTFactory();
            AST r = factory.create(0, "AST ROOT");
            r.setFirstChild(tree);
            ASTFrame frame = new ASTFrame("mn8 AST", r);
            frame.setVisible(true);
        }
    }

    static final synchronized String processTree(AST codeAST, String[] tokenNames) {
        mn8ConceptDefinition _currentConcept;
        if (mn8ConceptDefinition.ismn8ConceptDefinition(codeAST, tokenNames)) {
            String result = mn8ConceptDefinition.getConceptTypeFromAST(codeAST, tokenNames);
            return result;
        }
        String result = "_current_";
        if (ConceptRegister.getReference().isConceptNamed("_current_")) {
            mn8ConceptDefinition mn8ConceptDefinition2 = (mn8ConceptDefinition)ConceptRegister.getReference().lookup("_current_");
        } else {
            _currentConcept = mn8ConceptDefinition.makeTempConcept();
            _currentConcept.setTokenNames(tokenNames);
            ConceptRegister.getReference().register("_current_", _currentConcept);
        }
        ((mn8ScriptMethod)_currentConcept.getConceptMethod("main:series")).setCodeAST(codeAST);
        return result;
    }

    private static final void findEOLType() {
        block13: {
            Object nen;
            String eol = EOL;
            try {
                nen = NamingManager.lookup("env:/system/properties/EOL");
                if (nen != null) {
                    eol = ((StringConcept)nen).toString();
                }
            }
            catch (NamingException nex) {
                // empty catch block
            }
            try {
                nen = NamingManager.lookup("mem:/system/properties/EOL");
                if (nen != null && nen instanceof StringConcept) {
                    eol = ((StringConcept)nen).toString();
                }
            }
            catch (NamingException nex) {
                // empty catch block
            }
            if (eol.equals("\\r\\n")) {
                eol = "\r\n";
            } else if (eol.equals("\\r")) {
                eol = "\r";
            } else if (eol.equals("\\n")) {
                eol = "\n";
            }
            EOL = eol;
            try {
                NamingManager.envBind("env:/system/properties/EOL", new StringConcept(EOL));
            }
            catch (Exception ex) {
                if (!mn8RuntimeFlags.isDebug()) break block13;
                ex.printStackTrace();
            }
        }
    }

    public static synchronized PrintStream getOut(Thread thread) {
        if (_outStreams.containsKey(thread)) {
            return (PrintStream)_outStreams.get(thread);
        }
        return GLOBAL_OUT_STREAM;
    }

    public static synchronized PrintStream getErr(Thread thread) {
        if (_errStreams.containsKey(thread)) {
            return (PrintStream)_errStreams.get(thread);
        }
        return GLOBAL_ERR_STREAM;
    }

    public static InputStream getIn(Thread thread) {
        if (_inStreams.containsKey(thread)) {
            return (InputStream)_inStreams.get(thread);
        }
        return GLOBAL_IN_STREAM;
    }

    public static synchronized void printTDebug(Thread curr, String message) {
        if (curr != null) {
            System.err.println("->" + message + " " + curr.hashCode());
        }
        System.err.println("\t Out: " + _outStreams.size() + " Err: " + _errStreams.size() + " In: " + _inStreams.size());
        System.err.println("\tOut: " + GLOBAL_OUT_STREAM.toString());
        Enumeration keys = _outStreams.keys();
        while (keys.hasMoreElements()) {
            Thread key = (Thread)keys.nextElement();
            System.err.println("\t\t" + key.hashCode() + " - " + _outStreams.get(key).toString());
        }
    }

    public static PrintStream getOut() {
        return mn8Interpreter.getOut(Thread.currentThread());
    }

    public static PrintStream getErr() {
        return mn8Interpreter.getErr(Thread.currentThread());
    }

    public static InputStream getIn() {
        return mn8Interpreter.getIn(Thread.currentThread());
    }

    public static void addInterpreter(mn8InterpretThread interp, Thread inThread) {
        _interpreters.put(inThread, interp);
    }

    public static void delInterpreter(mn8InterpretThread interp, Thread inThread) {
        _interpreters.remove(inThread);
    }

    public static mn8InterpretThread getInterpreter(Thread inThread) {
        return (mn8InterpretThread)_interpreters.get(inThread);
    }

    public static void setOut(PrintStream out, Thread inThread) {
        _outStreams.put(inThread, out);
    }

    public static void setErr(PrintStream err, Thread inThread) {
        _errStreams.put(inThread, err);
    }

    public static void setIn(InputStream in, Thread inThread) {
        _interpreters.put(inThread, in);
    }

    public static void setOut(PrintStream out) {
        mn8Interpreter.setOut(out, Thread.currentThread());
    }

    public static void setErr(PrintStream err) {
        mn8Interpreter.setErr(err, Thread.currentThread());
    }

    public static void setIn(InputStream in) {
        mn8Interpreter.setIn(in, Thread.currentThread());
    }

    public static void cleanStreams(Thread inThread) {
        if (_outStreams.containsKey(inThread)) {
            _outStreams.remove(inThread);
        }
        if (_errStreams.containsKey(inThread)) {
            _errStreams.remove(inThread);
        }
        if (_inStreams.containsKey(inThread)) {
            _inStreams.remove(inThread);
        }
    }
}

