/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8;

import antlr.TokenStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractList;
import java.util.Iterator;
import javax.naming.NamingException;
import org.media.mn8.Concept;
import org.media.mn8.ConceptDefinition;
import org.media.mn8.ConceptRegister;
import org.media.mn8.JavaConcept;
import org.media.mn8.LogManager;
import org.media.mn8.MessageFormatter;
import org.media.mn8.NamingManager;
import org.media.mn8.concepts.SeriesConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.conf.SearchPathConf;
import org.media.mn8.event.ConceptNotFoundException;
import org.media.mn8.event.mn8ConceptInstantiationException;
import org.media.mn8.event.mn8ResourceLoadingException;
import org.media.mn8.mn8FileFilter;
import org.media.mn8.mn8Interpreter;
import org.media.mn8.mn8RuntimeFlags;
import org.media.mn8.parser.mn8Parser;
import org.media.mn8.parser.mn8TreeWalker;

public class mn8Loader {
    private static ConceptRegister _register = ConceptRegister.getReference();
    private static NamingManager _namingManager = NamingManager.getReference();
    private static String _scriptName = "";
    private static /* synthetic */ Class class$Lorg$media$mn8$ConceptDefinition;

    public static void setScriptName(String name) {
        _scriptName = name;
    }

    public static String getScriptName() {
        return _scriptName;
    }

    public static synchronized Concept instantiateConceptFromURL(String conceptURL) throws ConceptNotFoundException {
        mn8Loader loader = new mn8Loader();
        return loader.getConceptInstance(mn8Loader.loadConceptFromURL(conceptURL, null));
    }

    public static synchronized JavaConcept instantiateConcept(String name) throws ConceptNotFoundException {
        mn8Loader loader = new mn8Loader();
        return loader.getConceptInstance(name);
    }

    public static synchronized void loadConcept(String name) throws ConceptNotFoundException {
        mn8Loader loader;
        if (!mn8Loader.isConceptAvailable(name) && !(loader = new mn8Loader()).loadJavaConcept(name)) {
            String url = loader.findConcept(name);
            if (mn8RuntimeFlags.isDebug()) {
                System.err.println("loading concept: " + name + " from url: " + url);
            }
            mn8Loader.loadConceptFromURL(url, name);
        }
    }

    public static ConceptDefinition getConceptDefinition(String concept) {
        Object conceptSomething;
        if (!mn8Loader.isConceptAvailable(concept.toLowerCase())) {
            mn8Loader.loadConcept(concept);
        }
        if ((conceptSomething = _register.lookup(concept)) instanceof ConceptDefinition) {
            return (ConceptDefinition)conceptSomething;
        }
        return null;
    }

    public static boolean isConceptAvailable(String conceptName) {
        return _register.lookup(conceptName) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized String getContent(String resourceURL) {
        try {
            int chr;
            StringBuffer buffer = new StringBuffer();
            InputStream is = null;
            try {
                URL url = new URL(resourceURL);
                URLConnection uc = url.openConnection();
                is = uc.getInputStream();
            }
            catch (MalformedURLException mex) {
                File resFile = new File(resourceURL);
                if (resFile.exists() && resFile.isFile()) {
                    is = new FileInputStream(resFile);
                }
                throw mex;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((chr = reader.read()) != -1) {
                void resFile;
                buffer.append((char)resFile);
            }
            return buffer.toString();
        }
        catch (MalformedURLException ex) {
            String message = MessageFormatter.getReference().getMessage("warning", "net.malformed_url", resourceURL);
            LogManager.message(message);
            throw new mn8ResourceLoadingException(message);
        }
        catch (IOException ex) {
            String message = MessageFormatter.getReference().getMessage("warning", "net.connection_error", resourceURL, ex.getMessage());
            LogManager.message(message);
            throw new mn8ResourceLoadingException(message);
        }
        catch (Exception ex) {
            String message = MessageFormatter.getReference().getMessage("warning", "net.unexpected_error", resourceURL, ex.getMessage());
            LogManager.message(message);
            throw new mn8ResourceLoadingException(message);
        }
    }

    public static synchronized String resolveClassName(String className) {
        return _register.resolveClass(className);
    }

    private final JavaConcept getConceptInstance(String name) throws ConceptNotFoundException {
        Object conceptDef;
        JavaConcept result = null;
        if (!mn8Loader.isConceptAvailable(name)) {
            mn8Loader.loadConcept(name);
        }
        if ((conceptDef = _register.lookup(name)) != null) {
            if (conceptDef instanceof ConceptDefinition) {
                result = (JavaConcept)mn8TreeWalker.executeStaticMethod("create:", ((ConceptDefinition)conceptDef).getConceptType().toString(), new SeriesConcept(), -1);
            }
        } else {
            throw new RuntimeException("Unable to find concept: " + name);
        }
        return result;
    }

    private final boolean loadJavaConcept(String name) {
        try {
            Method refMethod;
            Class<?> conceptClass;
            String className = ((StringConcept)NamingManager.lookup("env://concept/javaConcepts/" + name.toLowerCase())).toString();
            if (className != null && (class$Lorg$media$mn8$ConceptDefinition != null ? class$Lorg$media$mn8$ConceptDefinition : (class$Lorg$media$mn8$ConceptDefinition = mn8Loader.class$("org.media.mn8.ConceptDefinition"))).isAssignableFrom(conceptClass = Class.forName(className)) && (refMethod = conceptClass.getMethod("getReference", null)) != null && Modifier.isStatic(refMethod.getModifiers())) {
                ConceptDefinition conceptDef = (ConceptDefinition)refMethod.invoke((Object)this, null);
                _register.register(name, conceptDef);
                return true;
            }
            return false;
        }
        catch (NamingException nex) {
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println(cnfe.getMessage());
            return false;
        }
        catch (NoSuchMethodException cnfe) {
            System.err.println(cnfe.getMessage());
            return false;
        }
        catch (IllegalAccessException cnfe) {
            System.err.println(cnfe.getMessage());
            return false;
        }
        catch (InvocationTargetException cnfe) {
            System.err.println(cnfe.getMessage());
            return false;
        }
    }

    public static synchronized String loadConceptFromURL(String conceptURL, String name) throws ConceptNotFoundException {
        try {
            mn8Loader.setScriptName(conceptURL);
            String conceptName = "String";
            if (conceptURL.indexOf("/") == -1 && conceptURL.indexOf("\\") == -1 && conceptURL.indexOf(".") == -1) {
                conceptName = conceptURL;
                conceptURL = new mn8Loader().findConcept(conceptName);
            }
            String conceptContent = mn8Loader.getContent(conceptURL);
            StringReader sreader = new StringReader(conceptContent);
            return new mn8Loader().loadConceptFromReader(sreader, name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String message = MessageFormatter.getReference().getMessage("error", "concept.instantiation_location_error", conceptURL);
            LogManager.message(message);
            throw new mn8ConceptInstantiationException(message);
        }
    }

    public String loadConceptFromReader(Reader reader, String name) {
        try {
            TokenStream scriptTokens = mn8Interpreter.getLexer(reader);
            mn8Parser parser = mn8Interpreter.parseTokenStream(scriptTokens, name);
            if (name == null) {
                String conceptName = mn8Interpreter.processTree(parser.getAST(), parser.getTokenNames());
                mn8Interpreter.preparingTreeAction(parser.getAST(), parser.getTokenNames());
                return conceptName;
            }
            if (_register.isConceptNamed(name)) {
                return name;
            }
            String conceptName = null;
            if (name != null) {
                conceptName = mn8Interpreter.processTree(parser.getAST(), parser.getTokenNames());
            }
            if (!_register.isConceptNamed(conceptName)) {
                throw new ConceptNotFoundException(name);
            }
            return conceptName;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String message = MessageFormatter.getReference().getMessage("error", "concept.instantiation_location_error", "");
            LogManager.message(message);
            throw new mn8ConceptInstantiationException(message);
        }
    }

    public String findConcept(String name) throws ConceptNotFoundException {
        SearchPathConf searchPathConf = SearchPathConf.getRef();
        Iterator searchPaths = ((AbstractList)searchPathConf).iterator();
        String path = null;
        File currentPath = null;
        File[] resultPaths = null;
        if (name.trim().indexOf(":") != -1) {
            name = name.trim().substring(0, name.trim().indexOf(":"));
        }
        if (!name.trim().toLowerCase().endsWith(".mn8")) {
            name = name.trim().toLowerCase() + ".mn8";
        }
        try {
            mn8FileFilter fileFilter = new mn8FileFilter(name);
            while (searchPaths.hasNext()) {
                path = ((StringConcept)searchPaths.next()).toString();
                currentPath = new File(path);
                resultPaths = currentPath.listFiles(fileFilter);
                if (resultPaths == null || resultPaths.length <= 0) continue;
                return resultPaths[0].toURL().toString();
            }
            throw new ConceptNotFoundException(name);
        }
        catch (MalformedURLException mex) {
            if (mn8RuntimeFlags.isDebug()) {
                mex.printStackTrace();
            } else if (mn8RuntimeFlags.isVerbose()) {
                System.err.println(mex.getMessage());
            }
            throw new ConceptNotFoundException(name);
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("Content of: " + args[0] + " is \n" + mn8Loader.instantiateConceptFromURL(args[0]));
        }
        catch (Exception ex) {
            System.out.println("/---: The stack trace is :----------------------------------\\");
            ex.printStackTrace();
            System.out.println("\\------------------------------------------------------------/");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

