/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.beep;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.beepcore.beep.core.Channel;
import org.beepcore.beep.core.DataStream;
import org.beepcore.beep.core.InputStreamDataStream;
import org.beepcore.beep.core.Message;
import org.beepcore.beep.core.ProfileRegistry;
import org.beepcore.beep.core.ReplyListener;
import org.beepcore.beep.core.Session;
import org.beepcore.beep.core.StringDataStream;
import org.beepcore.beep.lib.Reply;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.profile.sasl.otp.SASLOTPProfile;
import org.beepcore.beep.profile.sasl.otp.algorithm.md5.MD5;
import org.beepcore.beep.profile.sasl.otp.algorithm.sha1.SHA1;
import org.beepcore.beep.profile.sasl.otp.database.UserDatabasePool;
import org.beepcore.beep.transport.tcp.AutomatedTCPSessionCreator;
import org.beepcore.beep.transport.tcp.TCPSession;
import org.media.mn8.protocol.beep.BeepURITable;

class BeepURLConnection
extends URLConnection {
    private static final String DEF_HOST = "localhost";
    private static final int DEF_PORT = 10288;
    private static final String DEF_USER = "guest";
    private static final String DEF_PASSWORD = "guest";
    private static String URI_PROPERTY = "mn8.protocol.beep.uri";
    private static String SECURITY = "none";
    private final String hashMethod;
    private final String seed;
    private final int seq;
    private Channel channel = null;
    private BEEPOutputStream os = null;
    private URL url;

    public void connect() throws IOException {
        String host = this.host();
        int port = this.port();
        String user = this.user();
        String pwd = this.pwd();
        String file = this.file();
        String profile = this.profile(file);
        String path = this.path(file);
        String dbName = this.dbName();
        String URI2 = this.loadURI(profile);
        this.setVariablesFromQuery();
        if (URI2 == null) {
            throw new IOException("\nProfile: " + profile + " without URI specification!\n" + "To set the URI use the following system property:\n\t" + URI_PROPERTY + "=\"profile1=URI1|profile2=URI2| ...\"\n");
        }
        this.getConnection(host, port, user, pwd, profile, dbName, path, URI2);
    }

    private final String host() {
        if (this.url.getHost().length() == 0) {
            return DEF_HOST;
        }
        return this.url.getHost();
    }

    private final int port() {
        if (this.url.getPort() < 1) {
            return 10288;
        }
        return this.url.getPort();
    }

    private final String file() throws IOException {
        String file = this.url.getFile();
        if (file.equals("/") || file.trim().length() < 1) {
            throw new IOException("Missing profile parameter from URL");
        }
        file = file.indexOf("?") < 0 ? file.substring(1) : file.substring(1, file.indexOf("?"));
        return file;
    }

    private final String profile(String file) {
        if (file.indexOf("/") > 0) {
            return file.substring(0, file.indexOf("/"));
        }
        return file;
    }

    private final String path(String file) {
        if (file.indexOf("/") > 0) {
            return file.substring(file.indexOf("/") + 1);
        }
        return null;
    }

    private final String user() {
        String user;
        String string;
        String ui = this.url.getUserInfo();
        if (ui == null || ui.trim().length() < 1) {
            string = "guest";
        } else {
            if (ui.indexOf(":") != -1) {
                string = ui.substring(0, ui.indexOf(":"));
            } else {
                user = ui;
            }
            if (user.trim().length() < 1) {
                user = "guest";
            }
        }
        return user;
    }

    private final String pwd() {
        String password;
        String string;
        String ui = this.url.getUserInfo();
        if (ui == null || ui.trim().length() < 1) {
            string = "guest";
        } else {
            if (ui.indexOf(":") != -1) {
                string = ui.substring(ui.indexOf(":") + 1);
            } else {
                password = "guest";
            }
            if (password.trim().length() < 1) {
                password = "guest";
            }
        }
        return password;
    }

    private final String dbName() {
        if (this.url.getRef() == null || this.url.getRef().trim().length() == 0) {
            return null;
        }
        return this.url.getRef();
    }

    private final void setVariablesFromQuery() throws IOException {
        String qu = this.url.getQuery();
        if (qu != null && qu.trim().length() != 0) {
            StringTokenizer pt = new StringTokenizer(qu, "&");
            try {
                while (pt.hasMoreTokens()) {
                    String t = pt.nextToken();
                    String t_name = t.substring(0, t.indexOf("="));
                    String t_val = t.substring(t.indexOf("=") + 1);
                    if (!t_name.equalsIgnoreCase("security")) continue;
                    SECURITY = t_val;
                }
            }
            catch (Exception e) {
                throw new IOException("\n\tInvalid query attributes in: " + qu);
            }
        }
    }

    private final String loadURI(String profile) throws IOException {
        Hashtable ut = BeepURITable.profiles();
        String pURI = System.getProperty(URI_PROPERTY);
        if (pURI != null) {
            StringTokenizer st = new StringTokenizer(pURI, "|");
            try {
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    String t_name = t.substring(0, t.indexOf("="));
                    String t_uri = t.substring(t.indexOf("=") + 1);
                    ut.put(t_name, t_uri);
                }
            }
            catch (Exception e) {
                throw new IOException("\n\tInvalid property keys in: " + URI_PROPERTY);
            }
        }
        return (String)ut.get(profile);
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.channel == null) {
            this.connect();
        }
        return this.os.getInputStream();
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.channel == null) {
            this.connect();
        }
        if (this.channel != null) {
            this.os = new BEEPOutputStream(this.channel);
            return this.os;
        }
        return null;
    }

    private final void getConnection(String host, int port, String user, String password, String profile, String dbName, String path, String URI2) throws IOException {
        this.channel = this.openChannel(host, port, user, password, profile, dbName, URI2);
        if (this.channel == null) {
            throw new IOException("Can't initialize the profile: " + profile);
        }
        if (profile.equals("sep") && dbName != null) {
            try {
                Reply reply = new Reply();
                Message result = null;
                this.channel.sendMSG((DataStream)new StringDataStream("SEP:" + dbName), (ReplyListener)reply);
                result = reply.getNextReply();
                if (result != null && result.getMessageType() == 3) {
                    throw new RuntimeException("Connection failed to " + dbName);
                }
            }
            catch (Exception e) {
                throw new IOException("Connection failed to " + dbName);
            }
            if (path != null) {
                this.answerForURLSubtreePath(path);
            }
        }
    }

    private final void answerForURLSubtreePath(String path) throws IOException {
        String fetch = "<request reqno='1'><fetch><union><intersect><compare subtree='" + path + "'><path/>" + "<value></value></compare>" + "</intersect></union></fetch></request>";
        String pathType = this.decideThePathType(path);
        try {
            PrintStream pstream = new PrintStream(this.getOutputStream());
            if (pathType.equals("document")) {
                pstream.println(fetch);
            }
            if (pathType.equals("tree")) {
                pstream.println(this.listTree(path, "false"));
            }
            pstream.flush();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private final String decideThePathType(String path) throws IOException {
        this.sendRequest(this.listTree(path, "true"));
        String pathType = this.readResponse();
        StringTokenizer pt = new StringTokenizer(pathType, ">");
        String t = pt.nextToken();
        t = pt.nextToken();
        t = pt.nextToken();
        t = pt.nextToken();
        t = t.substring(0, 1);
        if (t.equals("-")) {
            return "document";
        }
        if (t.equals("t")) {
            return "tree";
        }
        throw new IOException("Invalid subtree or document name: " + path);
    }

    private final void sendRequest(String sep) throws IOException {
        try {
            PrintStream pstream = new PrintStream(this.getOutputStream());
            pstream.println(sep);
            pstream.flush();
        }
        catch (Exception e) {
            throw new IOException("Error while deciding subtree type: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String readResponse() throws IOException {
        String resp = "";
        try {
            String nextLine;
            BufferedReader input = new BufferedReader(new InputStreamReader(this.getInputStream()));
            while ((nextLine = input.readLine()) != null) {
                void var2_4;
                resp = resp + var2_4.trim();
            }
            input.close();
        }
        catch (Exception e) {
            throw new IOException("Error while reading response: " + e.getMessage());
        }
        return resp;
    }

    private final String listTree(String path, String isTree) {
        String ret = "<request reqno='1'><store action='update'><block name='_admin.trees'><tree action='list' long='true' tree='" + isTree + "'>" + "<subtree>" + path + "</subtree>" + "</tree></block></store></request>";
        return ret;
    }

    private final Channel openChannel(String host, int port, String user, String password, String profile, String dbName, String URI2) throws IOException {
        if (profile.equals("sep") && dbName == null) {
            throw new IOException("Can't initialize the session: Database name missing.");
        }
        try {
            return this.initChannel(this.initSession(host, port, user, password, dbName), URI2);
        }
        catch (Exception e) {
            throw new IOException("Can't initialize the session: " + e.getMessage());
        }
    }

    private final Channel initChannel(Session ses, String URI2) throws Exception {
        Channel chan = null;
        if (ses == null) {
            return null;
        }
        chan = ses.startChannel(URI2);
        return chan;
    }

    private final Session initSession(String host, int port, String user, String password, String dbName) throws Exception {
        TCPSession ses = AutomatedTCPSessionCreator.initiate((String)host, (int)port, (ProfileRegistry)new ProfileRegistry());
        ses = this.tls((Session)ses, SECURITY);
        ses = this.authenticate((Session)ses, user, password, dbName);
        return ses;
    }

    private final String preDigest(String pwd) throws Exception {
        return SASLOTPProfile.convertBytesToHex((byte[])new MD5().generateHash(pwd.getBytes()));
    }

    private final String getPasswdHash(String pwd) throws Exception {
        byte[] pw = ("xyz" + pwd).getBytes();
        int cx = 0;
        while (cx <= 1) {
            if ("otp-md5".equals("otp-md5")) {
                pw = new MD5().generateHash(pw);
            } else if ("otp-md5".equals("otp-sha1")) {
                pw = new SHA1().generateHash(pw);
            } else {
                throw new Exception("\nInvalid algorithm method:otp-md5\n");
            }
            ++cx;
        }
        return SASLOTPProfile.convertBytesToHex((byte[])pw);
    }

    private final Session authenticate(Session sess, String user, String pwd, String dbName) throws Exception {
        SASLOTPProfile otp = new SASLOTPProfile();
        if (dbName != null) {
            try {
                pwd = this.preDigest(pwd);
                String newHash = this.getPasswdHash(pwd);
                otp.init("http://iana.org/beep/SASL/OTP", new ProfileConfiguration());
                new UserDatabasePool().addUser(user, "otp-md5", newHash, "xyz", "1");
                sess = SASLOTPProfile.AuthenticateSASLOTPWithInit((Session)sess, (String)(dbName + "_"), (String)user, (String)pwd, (String)"otp-md5", (String)newHash, (String)"xyz", (String)"1");
            }
            catch (Exception e) {
                sess = null;
                throw e;
            }
        }
        return sess;
    }

    private final Session tls(Session tlsSes, String privacy) throws Exception {
        return tlsSes;
    }

    BeepURLConnection(URL getURL) {
        super(getURL);
        this.hashMethod = "otp-md5";
        this.seed = "xyz";
        this.seq = 1;
        try {
            this.url = new URL(URLDecoder.decode(getURL.toString()));
        }
        catch (Exception e) {
            System.out.println("Can't decode the URL: " + getURL.toString());
        }
    }

    private class BEEPOutputStream
    extends OutputStream {
        private CharInputStream cis;
        private Channel channel;
        private InputStream istream;

        public void write(int b) throws IOException {
            this.cis.write(b);
        }

        public void flush() throws IOException {
            Reply reply = new Reply();
            try {
                this.channel.sendMSG((DataStream)new InputStreamDataStream(this.cis.getInputStream(), (long)this.cis.getInputStream().available()), (ReplyListener)reply);
                this.istream = reply.getNextReply().getDataStream().getInputStream();
                this.cis.flush();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public InputStream getInputStream() {
            return this.istream;
        }

        public BEEPOutputStream(Channel ch) {
            this.channel = ch;
            BeepURLConnection beepURLConnection2 = BeepURLConnection.this;
            if (beepURLConnection2 == null) {
                throw null;
            }
            this.cis = beepURLConnection2.new CharInputStream();
            this.istream = null;
        }
    }

    private class CharInputStream {
        private StringWriter writer = new StringWriter();

        public void write(int ch) {
            this.writer.write(ch);
        }

        public void flush() {
            this.close();
            this.writer = new StringWriter();
        }

        public InputStream getInputStream() {
            this.close();
            return new ByteArrayInputStream(this.writer.toString().getBytes());
        }

        private final void close() {
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

