/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.env;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.media.mn8.NamingManager;
import org.media.mn8.concepts.StringConcept;

class EnvURLConnection
extends URLConnection {
    private URL url;
    private String path;
    private StringBuffer result = new StringBuffer();

    public void connect() throws IOException {
        this.path = this.file();
        this.getConnection(this.path);
    }

    private final String file() throws IOException {
        String file = this.url.getFile();
        if (file.equals("/") || file.trim().length() < 1) {
            throw new IOException("Missing path parameter from URL");
        }
        file = file.indexOf("?") < 0 ? file.substring(1) : file.substring(1, file.indexOf("?"));
        return file;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new ByteArrayInputStream(this.result.toString().getBytes());
    }

    private final void getConnection(String path) throws IOException {
        try {
            NamingManager.getReference();
            String value = ((StringConcept)NamingManager.lookup(path)).toString();
            this.result.append(value);
        }
        catch (Exception ex) {
            try {
                NamingManager.getReference();
                NamingEnumeration ne = NamingManager.list(path);
                while (ne.hasMore()) {
                    Object obj = ne.next();
                    if (obj instanceof NameClassPair) {
                        String _path = (path.endsWith("/") ? path : path + "/") + ((NameClassPair)obj).getName() + "/";
                        this.result.append(_path + "\n");
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    this.result.append((String)obj + "\n");
                }
            }
            catch (NamingException nex) {
                throw new IOException(nex.getMessage());
            }
        }
    }

    EnvURLConnection(URL getURL) {
        super(getURL);
        try {
            this.url = new URL(URLDecoder.decode(getURL.toString()));
        }
        catch (Exception e) {
            System.out.println("Can't decode the URL: " + getURL.toString());
        }
    }
}

