/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.media.mn8.protocol.http.CookieLoader;

public class Cookie {
    private String name;
    private String value;
    private String domain;
    private String path;
    private String expires;
    private String secure;

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public void setSecure(String secure) {
        this.secure = secure;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public String getExpires() {
        return this.expires;
    }

    public String getSecure() {
        return this.secure;
    }

    public String toXMLString() {
        return "<?xml version=\"1.0\"?>\n<cookie version=\"0\">\n    <domain>" + this.normalize(this.domain) + "</domain>\n" + "    <path>" + this.normalize(this.path) + "</path>\n" + "    <secure>" + this.normalize(this.secure) + "</secure>\n" + "    <expires>" + this.normalize(this.expires) + "</expires>\n" + "    <name>" + this.normalize(this.name) + "</name>\n" + "    <value>" + this.normalize(this.value) + "</value>\n" + "</cookie>";
    }

    public String toString() {
        return "Name   : " + this.name + "\n" + "Value  : " + this.value + "\n" + "Domain : " + this.domain + "\n" + "Path   : " + this.path + "\n" + "Expires: " + this.expires + "\n" + "Secure : " + this.secure + "\n";
    }

    private final String normalize(String str) {
        StringBuffer sb = new StringBuffer();
        int len = str != null ? str.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&#");
                    sb.append(Integer.toString("'".charAt(0)));
                    sb.append(";");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private final long makeTimeStamp(String val) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz", Locale.US);
            return df.parse(val).getTime();
        }
        catch (ParseException pe) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                return df.parse(val).getTime();
            }
            catch (ParseException parseException) {
                System.err.println("Unparseable date: " + val);
                return System.currentTimeMillis();
            }
        }
    }

    public String getCookieString(String uri, String xmlDir, boolean validate) {
        String cookieString = "";
        Vector cookies = this.readCookiesFromXML(uri, xmlDir, validate);
        if (cookies != null) {
            Enumeration en = cookies.elements();
            while (en.hasMoreElements()) {
                Cookie cookie = (Cookie)en.nextElement();
                cookieString = cookieString + ";" + cookie.getName() + "=" + cookie.getValue();
            }
            if (cookieString.length() > 0) {
                cookieString = cookieString.substring(1);
            }
        }
        return cookieString;
    }

    public Vector readCookiesFromXML(String uri, String xmlDir, boolean validate) {
        Vector<Cookie> result = new Vector<Cookie>();
        File xmlPath = null;
        File[] cookieFiles = null;
        String secure = "FALSE";
        String timeString = Long.toString(System.currentTimeMillis());
        String domain = "";
        String path = "";
        try {
            URL url = new URL(uri);
            domain = url.getHost();
            path = url.getPath();
            if (url.getProtocol().equalsIgnoreCase("https")) {
                secure = "TRUE";
            }
            if (!(xmlPath = new File(xmlDir)).exists()) {
                return null;
            }
            Vector<String> domains = new Vector<String>();
            domains.addElement(domain);
            StringTokenizer st = new StringTokenizer(domain, ".");
            int dots = st.countTokens() - 1;
            if (!uri.toLowerCase().startsWith("www") && dots == 2) {
                domains.addElement(domain.substring(domain.indexOf(46) + 1));
            }
            int cx = 0;
            while (cx < domains.size()) {
                cookieFiles = xmlPath.listFiles(new CookieFileFilter((String)domains.elementAt(cx)));
                while (true) {
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    int i = 0;
                    while (i < cookieFiles.length) {
                        Cookie cookie = new CookieLoader().getCookie(new FileInputStream(cookieFiles[i]), new Cookie());
                        if (cookie.getSecure().equalsIgnoreCase(secure)) {
                            String _path;
                            String string = _path = cookie.getPath() != null ? cookie.getPath() : "/";
                            if (!_path.endsWith("/")) {
                                _path = _path + "/";
                            }
                            if (path.equalsIgnoreCase(_path)) {
                                if (!validate) {
                                    result.addElement(cookie);
                                } else {
                                    String expires = cookie.getExpires();
                                    if (new Long(timeString) < new Long(expires)) {
                                        result.addElement(cookie);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    if (path.length() < 2) break;
                    path = path.substring(0, path.length() - 2);
                    path = path.substring(0, path.lastIndexOf("/") + 1);
                }
                ++cx;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    public void writeCookiesToXML(String domain, Vector cookies, String dest) {
        String fName = dest + File.separator + domain;
        if (!new File(dest).exists()) {
            new File(dest).mkdirs();
        }
        Enumeration e = cookies.elements();
        while (e.hasMoreElements()) {
            Cookie cookie = (Cookie)e.nextElement();
            int cookieNr = this.getCookieNr(dest, domain);
            try {
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fName + "[" + cookieNr + "].xml")));
                writer.println(cookie.toXMLString());
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public javax.servlet.http.Cookie getJavaCookie() {
        javax.servlet.http.Cookie cook = new javax.servlet.http.Cookie(this.getName(), "");
        if (!this.getExpires().equals("")) {
            try {
                cook.setMaxAge(new Integer(this.getExpires()).intValue());
            }
            catch (NumberFormatException ex) {
                System.err.println("Warning! Cookie: expires must me a numerical value, ignoring");
            }
        }
        if (!this.getDomain().equals("")) {
            cook.setDomain(this.getDomain());
        }
        if (!this.getPath().equals("")) {
            cook.setPath(this.getPath());
        }
        if (!this.getValue().equals("")) {
            cook.setValue(this.getValue());
        }
        if (!this.getSecure().equals("")) {
            cook.setSecure(new Boolean(this.getSecure()).booleanValue());
        }
        return cook;
    }

    private final int getCookieNr(String dest, String domain) {
        int nr = 1;
        String fName = dest + File.separator + domain;
        while (new File(fName + "[" + nr + "].xml").exists()) {
            ++nr;
        }
        return nr;
    }

    public boolean equals(Object obj) {
        Cookie cook;
        return obj instanceof Cookie && (cook = (Cookie)obj).getName().equalsIgnoreCase(this.name) && cook.getValue().equalsIgnoreCase(this.value) && cook.getDomain().equalsIgnoreCase(this.domain) && cook.getPath().equalsIgnoreCase(this.path) && cook.getExpires().equalsIgnoreCase(this.expires) && cook.getSecure().equalsIgnoreCase(this.secure);
    }

    public Cookie() {
        this.name = "";
        this.value = "";
        this.domain = "";
        this.path = "";
        this.expires = "";
        this.secure = "";
    }

    public Cookie(String acookie, String _domain) {
        if (acookie == null || acookie.trim().length() < 1) {
            throw new IllegalArgumentException("Cookie string is not valid!!!");
        }
        StringTokenizer st = new StringTokenizer(acookie, ";");
        boolean firstArg = true;
        Cookie cookie = new Cookie();
        this.domain = _domain;
        this.path = "";
        this.expires = System.currentTimeMillis() + "";
        this.secure = "FALSE";
        while (st.hasMoreTokens()) {
            int poz;
            String token = st.nextToken(";");
            if (firstArg) {
                poz = token.indexOf("=");
                if (poz != -1) {
                    this.name = token.substring(0, poz);
                    this.value = token.substring(poz + 1);
                } else {
                    this.name = token;
                    this.value = "";
                }
                firstArg = false;
                continue;
            }
            poz = token.indexOf("=");
            if (poz == -1) {
                this.secure = token;
                continue;
            }
            String key = token.substring(0, poz).trim();
            String val = token.substring(poz + 1).trim();
            if (key.equalsIgnoreCase("domain")) {
                this.domain = val;
            }
            if (key.equalsIgnoreCase("path")) {
                this.path = val;
            }
            if (!key.equalsIgnoreCase("expires")) continue;
            this.expires = this.makeTimeStamp(val) + "";
        }
        if (this.domain == null) {
            throw new IllegalArgumentException("Domain argument is not valid!!!");
        }
    }

    private class CookieFileFilter
    implements FilenameFilter {
        private String _filterName = null;

        public boolean accept(File dir, String name) {
            if (name != null) {
                String _name = name.trim().toLowerCase();
                int poz = -1;
                poz = _name.indexOf("[");
                if (poz != -1) {
                    _name = _name.substring(0, poz);
                }
                if (_name.startsWith(".")) {
                    _name = _name.substring(1);
                }
                return this._filterName.equals(_name);
            }
            return false;
        }

        public CookieFileFilter(String fName) {
            this._filterName = fName.toLowerCase();
        }
    }
}

