/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.media.mn8.protocol.http.Cookie;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CookieLoader
extends DefaultHandler {
    private Cookie cookie;
    private String errorMsg;
    private String parent;

    public String errorMsg() {
        return this.errorMsg;
    }

    public Cookie getCookie(InputStream src, Cookie cook) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        CookieLoader handler = new CookieLoader(cook);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(src, (DefaultHandler)handler);
            return cook;
        }
        catch (Exception e) {
            this.errorMsg = "Unable to parser XML.\n" + e.getMessage();
            return null;
        }
    }

    public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXException {
        this.parent = qname.trim();
    }

    public void endElement(String uri, String name, String qname) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String str = new String(ch, start, length);
        if (str.trim().length() > 0) {
            if (this.parent.equalsIgnoreCase("domain")) {
                this.cookie.setDomain(this.cookie.getDomain() != null ? this.cookie.getDomain() + str : str);
            }
            if (this.parent.equalsIgnoreCase("path")) {
                this.cookie.setPath(this.cookie.getPath() != null ? this.cookie.getPath() + str : str);
            }
            if (this.parent.equalsIgnoreCase("secure")) {
                this.cookie.setSecure(this.cookie.getSecure() != null ? this.cookie.getSecure() + str : str);
            }
            if (this.parent.equalsIgnoreCase("expires")) {
                this.cookie.setExpires(this.cookie.getExpires() != null ? this.cookie.getExpires() + str : str);
            }
            if (this.parent.equalsIgnoreCase("name")) {
                this.cookie.setName(this.cookie.getName() != null ? this.cookie.getName() + str : str);
            }
            if (this.parent.equalsIgnoreCase("value")) {
                this.cookie.setValue(this.cookie.getValue() != null ? this.cookie.getValue() + str : str);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public CookieLoader() {
    }

    protected CookieLoader(Cookie cookie) {
        this.cookie = cookie;
        this.errorMsg = null;
        this.parent = "";
    }
}

