/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.media.mn8.protocol.http.Cookie;

public class CookieTest {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java CookieTest url");
        } else {
            try {
                CookieTest ct = new CookieTest();
                URL u = new URL(args[0]);
                System.out.println("Connecting ...");
                ct.connectToURL(u);
            }
            catch (MalformedURLException ex) {
                System.err.println("Malformed url: " + args[0]);
            }
        }
    }

    public void connectToURL(URL u) {
        try {
            int data;
            URLConnection uconn = u.openConnection();
            uconn.connect();
            Cookie cookie = new Cookie(this.getCookie(uconn), u.getHost());
            BufferedInputStream bufIn = new BufferedInputStream(uconn.getInputStream());
            while ((data = bufIn.read()) != -1) {
                System.out.print((char)data);
            }
            if (cookie != null) {
                System.out.println("\nCookie\n" + cookie.toXMLString());
            } else {
                System.out.println("Cookie: None");
            }
        }
        catch (IOException ex) {
            System.err.println("Couldn't connect to " + u.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getCookie(URLConnection urlconn) {
        String hdrKey;
        int i = 1;
        String hdrString = null;
        while ((hdrKey = urlconn.getHeaderFieldKey(i)) != null) {
            void var3_4;
            if (var3_4.equalsIgnoreCase("set-cookie")) {
                hdrString = urlconn.getHeaderField(i);
            }
            ++i;
        }
        return hdrString;
    }
}

