/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

public class DefaultAttributes {
    private static final String[] attrNames = new String[]{"id", "class", "style", "title", "lang", "dir", "onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmosemove", "onmouseout", "onkeypress", "onkeydown", "onkeyup"};
    private String attrList = "";

    public void parse(String tag) {
        if (tag == null || tag.trim().length() < 1) {
            return;
        }
        String attrs = this.getAttrsFromTag(tag);
        if (attrs.trim().length() < 1) {
            return;
        }
        int i = 0;
        while (i < attrNames.length) {
            String value = this.getValueOf(attrs, attrNames[i]);
            if (value != null) {
                this.attrList = this.attrList + this.getAttrPair(attrNames[i], value);
            }
            ++i;
        }
    }

    public String getAttrList() {
        return this.attrList;
    }

    protected String getAttrsFromTag(String tag) {
        String attrs = tag.replace('<', ' ').replace('>', ' ').trim();
        if (attrs.endsWith("/")) {
            attrs = attrs.substring(0, attrs.length() - 2);
        }
        attrs = attrs.substring(attrs.indexOf(" ") != -1 ? attrs.indexOf(" ") : attrs.length());
        return attrs + " ";
    }

    protected String getValueOf(String tag, String attrName) {
        int poz = 0;
        String result = null;
        while ((poz = tag.toLowerCase().indexOf(attrName, poz)) != -1) {
            if (this.isAttrName(tag, poz - 1, attrName)) {
                result = this.getAttrValue(tag, poz + attrName.length());
                break;
            }
            poz += attrName.length();
        }
        return result == null ? null : result.trim();
    }

    protected String getAttrPair(String aname, String attr) {
        String ret = "";
        if (attr != null) {
            ret = aname + "=\"" + this.normalize(attr) + "\" ";
        }
        return ret;
    }

    private final boolean isWord(String tag, int start, int end) {
        if (!Character.isWhitespace(tag.charAt(start))) {
            return false;
        }
        return Character.isWhitespace(tag.charAt(end)) || tag.charAt(end) == '=';
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isAttrName(String tag, int poz, String attrName) {
        foundWord = false;
        if (poz <= 0 || this.isWord(tag, poz, poz + attrName.length() + 1)) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (Character.isWhitespace(tag.charAt(poz--))) continue;
            foundWord = true;
lbl6:
            // 3 sources

            ** while (poz > 0 && tag.charAt((int)poz) != '\"' && tag.charAt((int)poz) != '\'' && tag.charAt((int)poz) != '=')
        }
lbl7:
        // 1 sources

        if (poz > 0 && tag.charAt(poz) == '=' && !foundWord) {
            return false;
        }
        if (poz > 0 && tag.charAt(poz) == '\"' || tag.charAt(poz) == '\'') {
            while (poz > 0 && Character.isWhitespace(tag.charAt(poz))) {
                --poz;
            }
            if (tag.charAt(poz) == '=') {
                return false;
            }
        }
        return true;
    }

    private final String getAttrValue(String tag, int poz) {
        while (poz < tag.length() && Character.isWhitespace(tag.charAt(poz))) {
            ++poz;
        }
        if (poz >= tag.length() || tag.charAt(poz) != '=') {
            return "TRUE";
        }
        ++poz;
        while (poz < tag.length() && Character.isWhitespace(tag.charAt(poz))) {
            ++poz;
        }
        String sChar = " ";
        if (tag.charAt(poz) == '\"') {
            sChar = "\"";
            ++poz;
        }
        if (tag.charAt(poz) == '\'') {
            sChar = "'";
            ++poz;
        }
        return tag.substring(poz, tag.indexOf(sChar, poz) != -1 ? tag.indexOf(sChar, poz) : tag.length() - 1);
    }

    private final String normalize(String str) {
        StringBuffer sb = new StringBuffer();
        int len = str != null ? str.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&#");
                    sb.append(Integer.toString("'".charAt(0)));
                    sb.append(";");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

