/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.media.mn8.protocol.http.Cookie;
import org.media.mn8.protocol.http.CookieLoader;

public abstract class DefaultCookie {
    public abstract void writeCookiesToXML(String var1, String var2);

    public String getCookieString(String uri, String xmlDir, boolean validate) {
        String cookieString = "";
        Vector cookies = this.readCookiesFromXML(uri, xmlDir, validate);
        if (cookies != null) {
            Enumeration en = cookies.elements();
            while (en.hasMoreElements()) {
                Cookie cookie = (Cookie)en.nextElement();
                cookieString = cookieString + ";" + cookie.getName() + "=" + cookie.getValue();
            }
            if (cookieString.length() > 0) {
                cookieString = cookieString.substring(1);
            }
        }
        return cookieString;
    }

    public Vector readCookiesFromXML(String uri, String xmlDir, boolean validate) {
        Vector<Cookie> result = new Vector<Cookie>();
        File xmlPath = null;
        File[] cookieFiles = null;
        String secure = "FALSE";
        String timeString = Long.toString(System.currentTimeMillis());
        String domain = "";
        String path = "";
        try {
            URL url = new URL(uri);
            domain = url.getHost();
            path = url.getPath();
            if (url.getProtocol().equalsIgnoreCase("https")) {
                secure = "TRUE";
            }
            if (!(xmlPath = new File(xmlDir)).exists()) {
                return null;
            }
            cookieFiles = xmlPath.listFiles(new CookieFileFilter(domain));
            while (true) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                int i = 0;
                while (i < cookieFiles.length) {
                    Cookie cookie = new CookieLoader().getCookie(new FileInputStream(cookieFiles[i]), new Cookie());
                    if (cookie.getSecure().equalsIgnoreCase(secure)) {
                        String _path;
                        String string = _path = cookie.getPath() != null ? cookie.getPath() : "/";
                        if (!_path.endsWith("/")) {
                            _path = _path + "/";
                        }
                        if (path.equalsIgnoreCase(_path)) {
                            if (!validate) {
                                result.addElement(cookie);
                            } else {
                                String expires = cookie.getExpires();
                                if (new Long(timeString) < new Long(expires)) {
                                    result.addElement(cookie);
                                }
                            }
                        }
                    }
                    ++i;
                }
                if (path.length() >= 2) {
                    path = path.substring(0, path.length() - 2);
                    path = path.substring(0, path.lastIndexOf("/") + 1);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    protected void writeCookiesToXML(String domain, Vector cookies, String dest) {
        String fName = dest + File.separator + domain;
        if (!new File(dest).exists()) {
            new File(dest).mkdirs();
        }
        Enumeration e = cookies.elements();
        while (e.hasMoreElements()) {
            Cookie cookie = (Cookie)e.nextElement();
            int cookieNr = this.getCookieNr(dest, domain);
            try {
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fName + "[" + cookieNr + "].xml")));
                writer.println(cookie.toXMLString());
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private final int getCookieNr(String dest, String domain) {
        int nr = 1;
        String fName = dest + File.separator + domain;
        while (new File(fName + "[" + nr + "].xml").exists()) {
            ++nr;
        }
        return nr;
    }

    private class CookieFileFilter
    implements FilenameFilter {
        private String _filterName = null;

        public boolean accept(File dir, String name) {
            if (name != null) {
                String _name = name.trim().toLowerCase();
                int poz = -1;
                poz = _name.indexOf("[");
                if (poz != -1) {
                    _name = _name.substring(0, poz);
                }
                if (_name.startsWith(".")) {
                    _name = _name.substring(1);
                }
                return this._filterName.endsWith(_name);
            }
            return false;
        }

        public CookieFileFilter(String fName) {
            this._filterName = fName.toLowerCase();
        }
    }
}

