/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import org.media.mn8.protocol.http.Cookie;
import org.media.mn8.protocol.http.DefaultCookie;

public class ExplorerCookie
extends DefaultCookie {
    public void writeCookiesToXML(String src, String dest) {
        File file = new File(src);
        String[] files = file.list();
        if (!src.substring(src.length() - 1).equals(File.separator)) {
            src = src + File.separator;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].indexOf(".txt") > 0) {
                this.readCookieFile(src + files[i], dest);
            }
            ++i;
        }
    }

    private final void readCookieFile(String src, String dest) {
        FileInputStream is = null;
        String domain = "";
        Cookie cook = new Cookie();
        int cnt = 1;
        try {
            String line;
            is = new FileInputStream(src);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                String string;
                if (string.trim().startsWith("#") || string.trim().length() <= 0) continue;
                switch (cnt) {
                    case 1: {
                        cook.setName(string);
                        break;
                    }
                    case 2: {
                        cook.setValue(string);
                        break;
                    }
                    case 3: {
                        if (string.indexOf("/") > -1) {
                            domain = string.substring(0, string.indexOf("/"));
                            cook.setPath(string.substring(string.indexOf("/")));
                        } else {
                            domain = string;
                            cook.setPath("/");
                        }
                        cook.setDomain(domain);
                        break;
                    }
                    case 4: {
                        string = string.equals("0") ? "FALSE" : "TRUE";
                        cook.setSecure(string);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        string = string + "000";
                        cook.setExpires(string);
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        Vector<Cookie> cookies = new Vector<Cookie>();
                        cookies.addElement(cook);
                        this.writeCookiesToXML(domain, cookies, dest);
                        cnt = 0;
                        cook = new Cookie();
                        break;
                    }
                }
                ++cnt;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR:" + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("ERROR:" + e.getMessage());
        }
    }
}

