/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.media.mn8.protocol.http.DefaultAttributes;
import org.media.mn8.protocol.http.DefaultControl;
import org.media.mn8.protocol.http.DomainNameFilter;
import org.media.mn8.protocol.http.FormLoader;

public class Form
extends DefaultAttributes
implements DefaultControl {
    private static final String[] attrNames = new String[]{"action", "method", "name", "target", "enctype", "accept", "onsubmit", "onreset", "accept-charset"};
    private String action;
    private String method;
    private String name;
    private String target;
    private String encoding;
    private Vector controls = new Vector();
    private String attrList = "";
    private String _host = "";
    private String _path = "";

    public void setAction(String action) {
        this.action = action;
        this.attrList = this.attrList + this.getAttrPair("action", action);
    }

    public void setMethod(String method) {
        this.method = method;
        this.attrList = this.attrList + this.getAttrPair("method", method);
    }

    public void setName(String name) {
        this.name = name;
        this.attrList = this.attrList + this.getAttrPair("name", name);
    }

    public void setTarget(String target) {
        this.target = target;
        this.attrList = this.attrList + this.getAttrPair("target", target);
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
        this.attrList = this.attrList + this.getAttrPair("enctype", enc);
    }

    public boolean isSendable() {
        return true;
    }

    public String getAction() {
        return this.action;
    }

    public String getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public Vector getValues() {
        return null;
    }

    public String getTarget() {
        return this.target;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Vector getControls() {
        return this.controls;
    }

    public Form getSavedForm(String domain, String destDir) {
        if (!new File(destDir).exists()) {
            return null;
        }
        File[] formFiles = new File(destDir).listFiles(new DomainNameFilter(domain));
        int i = 0;
        while (i < formFiles.length) {
            try {
                Form form = new FormLoader().getForm(new FileInputStream(formFiles[i]), new Form(this._host, this._path));
                if (this.equals(form)) {
                    return form;
                }
            }
            catch (Exception e) {
                return null;
            }
            ++i;
        }
        return null;
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\"?>\n<FORM ");
        sb.append(this.getAttrList().trim() + ">");
        Enumeration e = this.controls.elements();
        while (e.hasMoreElements()) {
            sb.append("\n    " + ((DefaultControl)e.nextElement()).toXMLString());
        }
        sb.append("\n</FORM>");
        return sb.toString();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("FORM : \n" + this.getAttrList().replace(' ', '\n'));
        Enumeration e = this.controls.elements();
        while (e.hasMoreElements()) {
            ret.append("\n\n" + ((DefaultControl)e.nextElement()).toString());
        }
        return ret.toString();
    }

    public void parse(String tag) {
        super.parse(tag);
        if (tag == null || tag.trim().length() < 1) {
            return;
        }
        String attrs = this.getAttrsFromTag(tag);
        if (attrs.trim().length() > 0) {
            int i = 0;
            while (i < attrNames.length) {
                String value = super.getValueOf(attrs, attrNames[i]);
                if (value != null) {
                    if (attrNames[i].equals("action")) {
                        this.action = value;
                    } else {
                        if (attrNames[i].equals("name")) {
                            this.name = value;
                        }
                        if (attrNames[i].equals("method")) {
                            this.method = value;
                        }
                        if (attrNames[i].equals("target")) {
                            this.target = value;
                        }
                        this.attrList = this.attrList + this.getAttrPair(attrNames[i], value);
                    }
                }
                ++i;
            }
        }
        if (this.action == null) {
            this.action = this._host + this._path;
        } else if (this.action.indexOf(":/") == -1) {
            this.action = this.action.startsWith("/") ? this._host + this.action : this._host + (this._path.endsWith("/") ? this._path : this._path + "/") + this.action;
        }
        this.attrList = this.attrList + this.getAttrPair("action", this.action);
        if (this.method == null) {
            this.attrList = this.attrList + this.getAttrPair("method", "GET");
            this.method = "GET";
        }
    }

    public String getAttrList() {
        return this.attrList + super.getAttrList();
    }

    public void addControl(DefaultControl control) {
        this.controls.addElement(control);
    }

    public String getControlType() {
        return "FORM";
    }

    public boolean equals(DefaultControl dcontrol) {
        Form form = (Form)dcontrol;
        if (form == null) {
            return false;
        }
        if (form.action != null && !form.action.equalsIgnoreCase(this.action)) {
            return false;
        }
        if (form.method != null && !form.method.equalsIgnoreCase(this.method)) {
            return false;
        }
        if (form.target != null && !form.target.equalsIgnoreCase(this.target)) {
            return false;
        }
        if (form.name != null && !form.name.equalsIgnoreCase(this.name)) {
            return false;
        }
        if (form.getControlNr() != this.getControlNr()) {
            return false;
        }
        Enumeration e = form.controls.elements();
        while (e.hasMoreElements()) {
            DefaultControl control = (DefaultControl)e.nextElement();
            if (this.foundControl(control)) continue;
            return false;
        }
        return true;
    }

    private final boolean foundControl(DefaultControl control) {
        Enumeration e = this.controls.elements();
        while (e.hasMoreElements()) {
            DefaultControl lcontrol = (DefaultControl)e.nextElement();
            if (!control.getControlType().equals(lcontrol.getControlType()) || !control.equals(lcontrol)) continue;
            return true;
        }
        return false;
    }

    private final int getControlNr() {
        return this.controls.size();
    }

    public Form(String host, String path) {
        this._path = path;
        this._host = host;
    }
}

