/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.File;
import java.util.Vector;
import org.media.mn8.concepts.FileConcept;
import org.media.mn8.concepts.HTMLFormConcept;
import org.media.mn8.concepts.StringConcept;
import org.media.mn8.mn8RuntimeFlags;
import org.media.mn8.protocol.http.DefaultControl;
import org.media.mn8.protocol.http.DomainNameFilter;
import org.media.mn8.protocol.http.Form;
import org.media.mn8.protocol.http.InputControl;
import org.media.mn8.protocol.http.LinkExtractor;
import org.media.mn8.protocol.http.OptGroupControl;
import org.media.mn8.protocol.http.OptionControl;
import org.media.mn8.protocol.http.SelectControl;
import org.media.mn8.protocol.http.TextAreaControl;

public class FormExtractor
extends LinkExtractor {
    Vector forms = new Vector();
    boolean inForm = false;
    boolean inTextArea = false;
    boolean inSelect = false;
    boolean inOption = false;
    boolean formError = false;
    Form _form = null;
    StringBuffer _value = null;
    DefaultControl _control = null;
    OptGroupControl _optgrp = null;
    OptionControl _opt = null;
    HTMLFormConcept form = null;
    boolean isSendableForm = true;
    int linkNr = 0;

    public Vector getForms(String pageContent) {
        this.parsePage(pageContent);
        return this.forms;
    }

    public void tagFound(String tag) {
        block31: {
            String _host;
            block30: {
                super.tagFound(tag);
                if (this.links.size() > this.linkNr) {
                    ++this.linkNr;
                    return;
                }
                if (this.formError || this.baseURL == null) {
                    return;
                }
                if (this.inForm && this._form != null) {
                    if (this.inTextArea && !tag.toLowerCase().startsWith("/textarea")) {
                        this._value.append("<" + tag + ">");
                        return;
                    }
                    if (this.inOption && !tag.toLowerCase().startsWith("/option")) {
                        this._value.append("<" + tag + ">");
                        return;
                    }
                    if (tag.toLowerCase().startsWith("input ")) {
                        this._control = new InputControl();
                        ((InputControl)this._control).parse(tag);
                        this._form.addControl(this._control);
                        this._control = null;
                    }
                    if (tag.toLowerCase().startsWith("textarea ")) {
                        this._control = new TextAreaControl();
                        this._value = new StringBuffer();
                        this.inTextArea = true;
                        ((TextAreaControl)this._control).parse(tag);
                    }
                    if (tag.toLowerCase().startsWith("/textarea")) {
                        this.inTextArea = false;
                        ((TextAreaControl)this._control).setValue(this._value.toString());
                        this._form.addControl(this._control);
                        this._control = null;
                    }
                    if (tag.toLowerCase().startsWith("select ")) {
                        this._control = new SelectControl();
                        ((SelectControl)this._control).parse(tag);
                        this.inSelect = true;
                    }
                    if (tag.toLowerCase().startsWith("optgroup ") && this.inSelect) {
                        if (this._opt != null) {
                            ((SelectControl)this._control).addOption(this._opt);
                        }
                        this._opt = null;
                        this._optgrp = new OptGroupControl();
                        this._optgrp.parse(tag);
                    }
                    if (tag.toLowerCase().startsWith("/optgroup") && this.inSelect) {
                        if (this._opt != null) {
                            this._optgrp.addOption(this._opt);
                        }
                        ((SelectControl)this._control).addOptionGroup(this._optgrp);
                        this._optgrp = null;
                        this._opt = null;
                    }
                    if ((tag + " ").toLowerCase().startsWith("option ") && this.inSelect) {
                        if (this._opt != null && this._optgrp != null) {
                            this._optgrp.addOption(this._opt);
                        } else if (this._opt != null && this._control != null) {
                            ((SelectControl)this._control).addOption(this._opt);
                        }
                        this._opt = new OptionControl();
                        this._value = new StringBuffer();
                        this._opt.parse(tag);
                        this.inOption = true;
                    }
                    if (tag.toLowerCase().startsWith("/option") && this.inSelect) {
                        this._opt.setOptValue(this._value.toString());
                        this.inOption = false;
                    }
                    if (tag.toLowerCase().startsWith("/select")) {
                        if (this._opt != null) {
                            ((SelectControl)this._control).addOption(this._opt);
                        }
                        this._form.addControl(this._control);
                    }
                }
                if (tag.trim().toLowerCase().startsWith("form ")) {
                    this.inForm = true;
                    this.formError = false;
                    try {
                        _host = this.baseURL.getProtocol() + "://" + this.baseURL.getHost() + (this.baseURL.getPort() == -1 ? "" : ":" + this.baseURL.getPort());
                        String _path = this.baseURL.getPath();
                        if (!_path.endsWith("/") && _path.indexOf("/", _path.indexOf(".") == -1 ? _path.length() - 1 : _path.indexOf(".")) == -1) {
                            _path = _path.substring(0, _path.lastIndexOf("/") + 1);
                        }
                        this._form = new Form(_host, _path);
                        this._form.parse(tag);
                    }
                    catch (Exception ex) {
                        this.formError = true;
                        if (!mn8RuntimeFlags.isVerbose() && !mn8RuntimeFlags.isDebug()) break block30;
                        System.err.println(ex.getMessage());
                    }
                }
            }
            if (tag.trim().toLowerCase().startsWith("/form") || tag.trim().toLowerCase().startsWith("/html")) {
                this.inForm = false;
                try {
                    HTMLFormConcept loaded;
                    HTMLFormConcept saved;
                    _host = this.baseURL.getHost().trim().length() > 0 ? this.baseURL.getHost() : "localhost";
                    String _destDir = System.getProperty("user.home");
                    if (!_destDir.endsWith(File.separator)) {
                        _destDir = _destDir + File.separator;
                    }
                    if ((saved = this.loadForm(_destDir = _destDir + HTMLFormConcept.FORM_DB, _host, (loaded = new HTMLFormConcept(this._form)).getID())) != null) {
                        this.forms.add(saved);
                        this.isSendableForm = true;
                    } else {
                        this.forms.add(loaded);
                        this.isSendableForm = false;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (!mn8RuntimeFlags.isVerbose() && !mn8RuntimeFlags.isDebug()) break block31;
                    System.err.println(ex.getMessage());
                }
            }
        }
    }

    private final HTMLFormConcept loadForm(String destDir, String host, String id) {
        if (!new File(destDir).exists()) {
            return null;
        }
        String[] formFiles = new File(destDir).list(new DomainNameFilter(host));
        int i = 0;
        while (i < formFiles.length) {
            try {
                FileConcept xmlfile = new FileConcept(destDir + File.separator + formFiles[i]);
                StringConcept cont = (StringConcept)xmlfile.getContent();
                HTMLFormConcept xmlForm = (HTMLFormConcept)HTMLFormConcept.fromXML(cont);
                if (id.equals(xmlForm.getID())) {
                    return xmlForm;
                }
            }
            catch (Exception e) {
                return null;
            }
            ++i;
        }
        return null;
    }

    public void textFound(String text) {
        super.textFound(text);
        if (this.inTextArea) {
            this._value.append(text);
        }
        if (this.inOption) {
            this._value.append(text);
        }
    }
}

