/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.media.mn8.protocol.http.Form;
import org.media.mn8.protocol.http.InputControl;
import org.media.mn8.protocol.http.OptGroupControl;
import org.media.mn8.protocol.http.OptionControl;
import org.media.mn8.protocol.http.SelectControl;
import org.media.mn8.protocol.http.TextAreaControl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FormLoader
extends DefaultHandler {
    private Form form;
    private String errorMsg;
    private StringBuffer parents;
    private InputControl icontrol;
    private TextAreaControl tacontrol;
    private SelectControl scontrol;
    private OptionControl ocontrol;
    private OptGroupControl ogcontrol;
    private String tempValue;

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Form getForm(InputStream src, Form _form) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        FormLoader handler = new FormLoader(_form);
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(src, (DefaultHandler)handler);
            return _form;
        }
        catch (Exception e) {
            this.errorMsg = "Unable to parse XML.\n " + e.getMessage();
            return null;
        }
    }

    public void startDocument() throws SAXException {
        this.parents = new StringBuffer();
    }

    public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXException {
        String pName = this.getParentName();
        this.parents.append("," + qname);
        if (pName.equalsIgnoreCase("form") && qname.equalsIgnoreCase("input")) {
            this.icontrol = new InputControl();
        }
        if (pName.equalsIgnoreCase("form") && qname.equalsIgnoreCase("select")) {
            this.scontrol = new SelectControl();
        }
        if (pName.equalsIgnoreCase("select") && qname.equalsIgnoreCase("optgroup")) {
            this.ogcontrol = new OptGroupControl();
        }
        if (pName.equalsIgnoreCase("form") && qname.equalsIgnoreCase("textarea")) {
            this.tacontrol = new TextAreaControl();
            this.tempValue = "";
        }
        if (pName.equalsIgnoreCase("select") && qname.equalsIgnoreCase("option")) {
            this.ocontrol = new OptionControl();
            this.tempValue = "";
        }
        if (pName.equalsIgnoreCase("optgroup") && qname.equalsIgnoreCase("option")) {
            this.ocontrol = new OptionControl();
            this.tempValue = "";
        }
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                if (qname.equalsIgnoreCase("form")) {
                    if (attrs.getQName(i).equalsIgnoreCase("action")) {
                        this.form.setAction(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("method")) {
                        this.form.setMethod(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("name")) {
                        this.form.setName(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("target")) {
                        this.form.setTarget(attrs.getValue(i));
                    }
                } else if (pName.equalsIgnoreCase("form") && qname.equalsIgnoreCase("input")) {
                    if (attrs.getQName(i).equalsIgnoreCase("type")) {
                        this.icontrol.setType(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("name")) {
                        this.icontrol.setName(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("value")) {
                        this.icontrol.setValue(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("checked")) {
                        this.icontrol.setChecked(attrs.getValue(i));
                    }
                } else if (pName.equalsIgnoreCase("form") && qname.equalsIgnoreCase("textarea")) {
                    if (attrs.getQName(i).equalsIgnoreCase("name")) {
                        this.tacontrol.setName(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("rows")) {
                        this.tacontrol.setRows(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("cols")) {
                        this.tacontrol.setCols(attrs.getValue(i));
                    }
                } else if (pName.equalsIgnoreCase("form") && qname.equalsIgnoreCase("select")) {
                    if (attrs.getQName(i).equalsIgnoreCase("name")) {
                        this.scontrol.setName(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("size")) {
                        this.scontrol.setSize(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("multiple")) {
                        this.scontrol.setMultiple(attrs.getValue(i));
                    }
                } else if (pName.equalsIgnoreCase("select") && qname.equalsIgnoreCase("option")) {
                    if (attrs.getQName(i).equalsIgnoreCase("value")) {
                        this.ocontrol.setValue(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("selected")) {
                        this.ocontrol.setSelected(attrs.getValue(i));
                    }
                } else if (pName.equalsIgnoreCase("select") && qname.equalsIgnoreCase("optgroup")) {
                    if (attrs.getQName(i).equalsIgnoreCase("label")) {
                        this.ogcontrol.setLabel(attrs.getValue(i));
                    }
                } else if (pName.equalsIgnoreCase("optgroup") && qname.equalsIgnoreCase("option")) {
                    if (attrs.getQName(i).equalsIgnoreCase("value")) {
                        this.ocontrol.setValue(attrs.getValue(i));
                    }
                    if (attrs.getQName(i).equalsIgnoreCase("selected")) {
                        this.ocontrol.setSelected(attrs.getValue(i));
                    }
                }
                ++i;
            }
        }
    }

    public void endElement(String uri, String name, String qname) throws SAXException {
        String pName = this.parents.toString().trim();
        int poz = pName.lastIndexOf(",");
        if (poz != -1) {
            pName = pName.substring(poz + 1).trim();
        }
        if (poz < 0) {
            poz = 0;
        }
        if (!qname.equals(pName)) {
            throw new SAXException("Missing end element : '" + qname + "'");
        }
        if (qname.equalsIgnoreCase("input") && this.icontrol != null) {
            this.form.addControl(this.icontrol);
            this.icontrol = null;
        }
        if (qname.equalsIgnoreCase("select") && this.scontrol != null) {
            this.form.addControl(this.scontrol);
            this.scontrol = null;
        }
        if (qname.equalsIgnoreCase("optgroup") && this.ogcontrol != null && this.scontrol != null) {
            this.scontrol.addOptionGroup(this.ogcontrol);
            this.ogcontrol = null;
        }
        if (qname.equalsIgnoreCase("textarea") && this.tacontrol != null) {
            if (this.tempValue.trim().length() > 0) {
                this.tacontrol.setValue(this.tempValue);
            }
            this.form.addControl(this.tacontrol);
            this.tacontrol = null;
        }
        if (qname.equalsIgnoreCase("option") && this.ocontrol != null && this.scontrol != null) {
            if (this.tempValue.trim().length() > 0) {
                this.ocontrol.setOptValue(this.tempValue);
            }
            if (this.ogcontrol != null) {
                this.ogcontrol.addOption(this.ocontrol);
            } else {
                this.scontrol.addOption(this.ocontrol);
            }
            this.ocontrol = null;
        }
        this.parents.delete(poz, this.parents.length());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String pName = this.getParentName();
        if (pName.equalsIgnoreCase("textarea")) {
            this.tempValue = this.tempValue + new String(ch, start, length).trim();
        }
        if (pName.equalsIgnoreCase("option")) {
            this.tempValue = this.tempValue + new String(ch, start, length).trim();
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startDTD(String name, String pID, String sId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    private final String getParentName() {
        String pName = this.parents.toString().trim();
        int _poz = pName.lastIndexOf(",");
        if (_poz != -1) {
            pName = pName.substring(_poz + 1).trim();
        }
        return pName;
    }

    public FormLoader() {
    }

    protected FormLoader(Form form) {
        this.form = form;
        this.errorMsg = null;
        this.parents = new StringBuffer();
        this.icontrol = null;
        this.tacontrol = null;
        this.scontrol = null;
        this.ocontrol = null;
        this.ogcontrol = null;
        this.tempValue = "";
    }
}

