/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.media.mn8.protocol.http.Form;
import org.media.mn8.protocol.http.InputControl;
import org.media.mn8.protocol.http.OptGroupControl;
import org.media.mn8.protocol.http.OptionControl;
import org.media.mn8.protocol.http.SelectControl;
import org.media.mn8.protocol.http.TextAreaControl;

public class FormTest {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java FormTest url formDir");
        } else {
            try {
                FormTest ct = new FormTest();
                URL u = new URL(args[0]);
                ct.connectToURL(u, args[1]);
            }
            catch (Exception ex) {
                System.err.println("Malformed url: " + args[0]);
            }
        }
    }

    public void connectToURL(URL u, String destDir) {
        boolean inForm = false;
        Form form = null;
        try {
            URLConnection uconn = u.openConnection();
            uconn.connect();
            InputStream is = uconn.getInputStream();
            while (true) {
                boolean openTag = true;
                String tag = this.nextTag(is);
                if (tag != null) {
                    String _tag;
                    if ((tag = tag.substring(tag.lastIndexOf(60) != -1 ? tag.lastIndexOf(60) : 0)).trim().startsWith("</")) {
                        openTag = false;
                    }
                    if ((_tag = tag.replace('<', ' ').replace('>', ' ').trim() + " ").startsWith("/")) {
                        _tag = _tag.substring(1).trim() + " ";
                    }
                    if (inForm) {
                        if (_tag.toLowerCase().startsWith("input ")) {
                            InputControl icontrol = new InputControl();
                            icontrol.parse(_tag);
                            form.addControl(icontrol);
                        }
                        if (_tag.toLowerCase().startsWith("textarea ")) {
                            TextAreaControl tacontrol = new TextAreaControl();
                            String ta_value = "";
                            tacontrol.parse(_tag);
                            while ((_tag = this.nextTag(is)) != null) {
                                ta_value = ta_value + _tag;
                                String end_tag = _tag.substring(_tag.lastIndexOf(60) != -1 ? _tag.lastIndexOf(60) : 0);
                                if (!end_tag.trim().startsWith("</") || !(end_tag = end_tag.replace('<', ' ').replace('>', ' ').replace('/', ' ').trim() + " ").toLowerCase().startsWith("textarea ")) continue;
                                break;
                            }
                            tacontrol.setValue(ta_value.lastIndexOf("</") != -1 ? ta_value.substring(0, ta_value.lastIndexOf("</")) : ta_value);
                            form.addControl(tacontrol);
                            continue;
                        }
                        if (_tag.toLowerCase().startsWith("select ")) {
                            String end_tag;
                            String eName;
                            String innerTag;
                            SelectControl scontrol = new SelectControl();
                            String optValue = "";
                            OptionControl ocontrol = null;
                            OptGroupControl ogcontrol = null;
                            scontrol.parse(_tag);
                            while (!((innerTag = this.nextTag(is).trim()) == null || (eName = innerTag.substring(innerTag.lastIndexOf(60) != -1 ? innerTag.lastIndexOf(60) : 0)).startsWith("</") && (end_tag = eName.substring(2).replace('>', ' ').trim() + " ").toLowerCase().startsWith("select "))) {
                                if ((eName = eName.replace('<', ' ').replace('>', ' ').trim() + " ").toLowerCase().startsWith("optgroup ")) {
                                    if (ocontrol != null) {
                                        scontrol.addOption(ocontrol);
                                    }
                                    ocontrol = null;
                                    ogcontrol = new OptGroupControl();
                                    ogcontrol.parse(innerTag);
                                    continue;
                                }
                                if (eName.startsWith("/") && (eName.substring(1).trim() + " ").toLowerCase().startsWith("optgroup ")) {
                                    if (ocontrol != null) {
                                        ogcontrol.addOption(ocontrol);
                                    }
                                    scontrol.addOptionGroup(ogcontrol);
                                    ogcontrol = null;
                                    ocontrol = null;
                                    continue;
                                }
                                if (eName.toLowerCase().startsWith("option ")) {
                                    if (ocontrol != null && ogcontrol != null) {
                                        ogcontrol.addOption(ocontrol);
                                    } else if (ocontrol != null && scontrol != null) {
                                        scontrol.addOption(ocontrol);
                                    }
                                    ocontrol = new OptionControl();
                                    ocontrol.parse(innerTag);
                                    optValue = "";
                                    continue;
                                }
                                if (eName.startsWith("/") && (eName.substring(1).trim() + " ").toLowerCase().startsWith("option ")) {
                                    optValue = optValue + innerTag.substring(0, innerTag.lastIndexOf(60) != -1 ? innerTag.lastIndexOf(60) : innerTag.length() - 1);
                                    ocontrol.setOptValue(optValue);
                                    continue;
                                }
                                optValue = optValue + innerTag;
                            }
                            if (ocontrol != null) {
                                scontrol.addOption(ocontrol);
                            }
                            form.addControl(scontrol);
                            continue;
                        }
                    }
                    if (!_tag.toLowerCase().startsWith("form ")) continue;
                    if (openTag) {
                        inForm = true;
                        String host = u.getProtocol() + "://" + u.getHost() + (u.getPort() == -1 ? "" : ":" + u.getPort());
                        String path = u.getPath();
                        if (!path.endsWith("/") && path.indexOf("/", path.indexOf(".") == -1 ? path.length() - 1 : path.indexOf(".")) == -1) {
                            path = path.substring(0, path.lastIndexOf("/") + 1);
                        }
                        form = new Form(host, path);
                        form.parse(tag);
                        continue;
                    }
                    inForm = false;
                    String _host = u.getHost().trim().length() > 0 ? u.getHost() : "localhost";
                    Form sform = form.getSavedForm(_host, destDir);
                    if (sform != null) {
                        System.out.println(sform.toXMLString());
                        continue;
                    }
                    System.out.println("Saved form not found !!!");
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            System.err.println("Couldn't connect to " + u.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final String nextTag(InputStream is) {
        StringBuffer sb = new StringBuffer();
        try {
            int ch = 0;
            while ((ch = is.read()) != -1) {
                sb.append((char)ch);
                if (ch != 62) continue;
                if (sb.toString().trim().startsWith("<!--")) {
                    if (!sb.toString().trim().endsWith("-->")) continue;
                    return sb.toString();
                }
                return sb.toString();
            }
            return null;
        }
        catch (IOException ex) {
            System.err.println("Couldn't connect to URL ");
            return null;
        }
    }
}

