/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.util.Vector;
import org.media.mn8.protocol.http.DefaultAttributes;
import org.media.mn8.protocol.http.DefaultControl;

public class InputControl
extends DefaultAttributes
implements DefaultControl {
    private static final String[] attrNames = new String[]{"type", "value", "name", "checked", "disabled", "readonly", "size", "maxlength", "src", "alt", "usemap", "ismap", "tabindex", "accesskey", "onfocus", "onblur", "onselect", "onchange", "accept", "align", "alt"};
    private String type;
    private String name;
    private String value;
    private String checked;
    private String attrList = "";

    public void setType(String type) {
        this.type = type;
        this.attrList = this.attrList + this.getAttrPair("type", type);
    }

    public void setName(String name) {
        this.name = name;
        this.attrList = this.attrList + this.getAttrPair("name", name);
    }

    public void setValue(String value) {
        this.value = value;
        this.attrList = this.attrList + this.getAttrPair("value", value);
    }

    public void setChecked(String chk) {
        this.checked = chk;
        this.attrList = this.attrList + this.getAttrPair("checked", chk);
    }

    public boolean isSendable() {
        if (this.type.equalsIgnoreCase("submit") && (this.name == null || this.name.trim().length() < 1)) {
            this.name = this.type;
        }
        if ((this.type.equalsIgnoreCase("text") || this.type.equalsIgnoreCase("password") || this.type.equalsIgnoreCase("file") || this.type.equalsIgnoreCase("submit")) && this.name != null && this.name.trim().length() > 0) {
            return true;
        }
        return (this.type.equalsIgnoreCase("radio") || this.type.equalsIgnoreCase("checkbox") || this.type.equalsIgnoreCase("hidden")) && this.name != null && this.name.trim().length() > 0 && this.value != null && this.value.trim().length() > 0;
    }

    public String getName() {
        return this.name;
    }

    public Vector getValues() {
        Vector<String> result = new Vector<String>();
        result.add(this.value);
        return result;
    }

    public String getType() {
        return this.type;
    }

    public String toXMLString() {
        return "<INPUT " + this.getAttrList().trim() + "/>";
    }

    public String toString() {
        return "INPUT : \n" + this.getAttrList().replace(' ', '\n');
    }

    public void parse(String tag) {
        super.parse(tag);
        if (tag == null || tag.trim().length() < 1) {
            return;
        }
        String attrs = this.getAttrsFromTag(tag);
        if (attrs.trim().length() > 0) {
            int i = 0;
            while (i < attrNames.length) {
                String value = super.getValueOf(attrs, attrNames[i]);
                if (value != null) {
                    if (attrNames[i].equals("type")) {
                        this.type = value;
                    }
                    if (attrNames[i].equals("name")) {
                        this.name = value;
                    }
                    if (attrNames[i].equals("value")) {
                        this.value = value;
                    }
                    if (attrNames[i].equals("checked")) {
                        this.checked = value;
                    }
                    this.attrList = this.attrList + this.getAttrPair(attrNames[i], value);
                }
                ++i;
            }
        }
        if (this.value == null) {
            this.attrList = this.attrList + this.getAttrPair("value", "");
            this.value = "";
        }
        if (this.type == null) {
            this.attrList = this.attrList + this.getAttrPair("type", "text");
            this.type = "text";
        }
        if (this.checked == null && (this.type.equalsIgnoreCase("radio") || this.type.equalsIgnoreCase("checkbox"))) {
            this.attrList = this.attrList + this.getAttrPair("checked", "false");
        }
    }

    public String getAttrList() {
        return this.attrList + super.getAttrList();
    }

    public String getControlType() {
        return "INPUT";
    }

    public boolean equals(DefaultControl control) {
        InputControl icontrol = (InputControl)control;
        if (!icontrol.type.equalsIgnoreCase(this.type)) {
            return false;
        }
        return icontrol.name == null || icontrol.name.equalsIgnoreCase(this.name);
    }
}

