/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import org.media.mn8.protocol.http.Cookie;
import org.media.mn8.protocol.http.DefaultCookie;

public class NetscapeCookie
extends DefaultCookie {
    public void writeCookiesToXML(String src, String dest) {
        Vector domains = this.getDomains(src);
        Enumeration e = domains.elements();
        while (e.hasMoreElements()) {
            String domain = (String)e.nextElement();
            Vector cookies = this.readCookie(domain, src);
            this.writeCookiesToXML(domain, cookies, dest);
        }
    }

    private final Cookie cookieLine(String line) {
        Cookie cook = new Cookie();
        StringBuffer sb = new StringBuffer();
        int cnt = 1;
        int poz = 0;
        while (poz < line.length()) {
            char ch;
            if (Character.isWhitespace(ch = line.charAt(poz++))) {
                switch (cnt) {
                    case 1: {
                        cook.setDomain(sb.toString());
                        break;
                    }
                    case 3: {
                        cook.setPath(sb.toString());
                        break;
                    }
                    case 4: {
                        cook.setSecure(sb.toString());
                        break;
                    }
                    case 5: {
                        cook.setExpires(sb.toString() + "000");
                        break;
                    }
                    case 6: {
                        cook.setName(sb.toString());
                        break;
                    }
                    case 7: {
                        cook.setValue(sb.toString());
                        break;
                    }
                }
                sb = new StringBuffer();
                ++cnt;
                continue;
            }
            sb.append(ch);
        }
        return cook;
    }

    private final boolean isExist(Vector vector, String element) {
        boolean ret = false;
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            String domain = (String)e.nextElement();
            if (!element.equals(domain)) continue;
            return true;
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private final Vector readCookieFile(String domain, String src, String type) {
        FileInputStream is = null;
        Vector<Object> objects = new Vector<Object>();
        try {
            String line;
            is = new FileInputStream(src);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                void var6_7;
                if (var6_7.trim().startsWith("#") || var6_7.trim().length() <= 0) continue;
                int i = 0;
                while (!Character.isWhitespace(var6_7.charAt(i)) && i < var6_7.length() - 1) {
                    ++i;
                }
                String _domain = var6_7.substring(0, i);
                if (type.equals("domains")) {
                    if (this.isExist(objects, _domain)) continue;
                    objects.addElement(_domain);
                    continue;
                }
                if (!_domain.equals(domain)) continue;
                objects.addElement(this.cookieLine((String)var6_7 + "\n"));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR:" + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("ERROR:" + e.getMessage());
        }
        return objects;
    }

    private final Vector getDomains(String src) {
        return this.readCookieFile(null, src, "domains");
    }

    private final Vector readCookie(String domain, String src) {
        return this.readCookieFile(domain, src, "cooks");
    }
}

