/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.media.mn8.protocol.http.Cookie;
import org.media.mn8.protocol.http.DefaultCookie;

public class OperaCookie
extends DefaultCookie {
    private String name;
    private String value;
    private String path;
    private String secure;
    private String dest;
    private int expires;
    private int lastused;
    private Vector domains = new Vector();

    public void writeCookiesToXML(String src, String dest) {
        DataInputStream is = null;
        this.dest = dest;
        try {
            is = new DataInputStream(new FileInputStream(src));
            this.readFileVersionNumber(is);
            this.readAppVersionNumber(is);
            int id_length = this.readIdtagLength(is);
            int length_length = this.readLengthLength(is);
            this.readStructRecordItems(is, id_length, length_length);
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR:" + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("ERROR:" + e.getMessage());
        }
    }

    private final int readSequence(DataInputStream is, int type) {
        int ret = 100000;
        try {
            switch (type) {
                case 1: {
                    return is.readByte();
                }
                case 2: {
                    return is.readShort();
                }
                case 4: {
                    return is.readInt();
                }
            }
        }
        catch (EOFException e) {
            return ret;
        }
        catch (IOException e) {
            System.out.println("ERROR:" + e.getMessage());
        }
        return ret;
    }

    private final DataInputStream readPayload(DataInputStream is, int length) {
        DataInputStream bais = null;
        try {
            byte[] arry = new byte[length];
            is.read(arry);
            bais = new DataInputStream(new ByteArrayInputStream(arry));
        }
        catch (IOException e) {
            System.out.println("ERROR:" + e.getMessage());
        }
        return bais;
    }

    private final String readString(DataInputStream is) {
        String ret = "";
        try {
            int b = is.readShort();
            int x = 1;
            while (x <= b) {
                ret = ret + (char)is.readByte();
                ++x;
            }
        }
        catch (IOException e) {
            System.out.println("ERROR:" + e.getMessage());
        }
        return ret;
    }

    private final void readFileVersionNumber(DataInputStream is) {
        this.readSequence(is, 4);
    }

    private final void readAppVersionNumber(DataInputStream is) {
        this.readSequence(is, 4);
    }

    private final int readIdtagLength(DataInputStream is) {
        return this.readSequence(is, 2);
    }

    private final int readLengthLength(DataInputStream is) {
        return this.readSequence(is, 2);
    }

    private final void readDomainRecord(DataInputStream di) {
        boolean isend = false;
        int id = 0;
        while (!isend) {
            id = this.readSequence(di, 1);
            switch (id) {
                case -101: {
                    break;
                }
                case -123: {
                    break;
                }
                case -124: {
                    break;
                }
                case 100000: {
                    isend = true;
                    break;
                }
                case 30: {
                    this.domains.insertElementAt(this.readString(di), 0);
                    break;
                }
                case 31: {
                    int accepted = this.readSequence(di, this.readSequence(di, 2));
                    break;
                }
                case 33: {
                    int explicit = this.readSequence(di, this.readSequence(di, 2));
                    break;
                }
                case 37: {
                    int third = this.readSequence(di, this.readSequence(di, 2));
                    break;
                }
                default: {
                    System.out.println("Invalid ID in domain record: " + id);
                }
            }
        }
    }

    private final void readPathRecord(DataInputStream di) {
        int id = this.readSequence(di, 1);
        switch (id) {
            case -123: {
                break;
            }
            case -124: {
                break;
            }
            case 29: {
                this.path = this.path + "/" + this.readString(di);
                break;
            }
            default: {
                System.out.println("Invalid ID in path record: " + id);
            }
        }
    }

    private final void readCookieRecord(DataInputStream di) {
        boolean end_di = false;
        while (!end_di) {
            int id = this.readSequence(di, 1);
            switch (id) {
                case -101: {
                    break;
                }
                case -123: {
                    break;
                }
                case -124: {
                    break;
                }
                case -96: {
                    break;
                }
                case 100000: {
                    end_di = true;
                    break;
                }
                case 16: {
                    this.name = this.readString(di);
                    break;
                }
                case 17: {
                    this.value = this.readString(di);
                    break;
                }
                case 18: {
                    this.expires = this.readSequence(di, this.readSequence(di, 2));
                    break;
                }
                case 19: {
                    this.lastused = this.readSequence(di, this.readSequence(di, 2));
                    break;
                }
                case 20: {
                    String descr = this.readString(di);
                    break;
                }
                case 21: {
                    String urldescr = this.readString(di);
                    break;
                }
                case 22: {
                    String domain_ver1 = this.readString(di);
                    break;
                }
                case 23: {
                    String path_ver1 = this.readString(di);
                    break;
                }
                case 24: {
                    String portlim = this.readString(di);
                    break;
                }
                case 25: {
                    this.secure = "TRUE";
                    break;
                }
                case 26: {
                    int ver = this.readSequence(di, 1);
                    break;
                }
                case 27: {
                    break;
                }
                case 28: {
                    break;
                }
                case 32: {
                    break;
                }
                case 34: {
                    break;
                }
                case 35: {
                    break;
                }
                case 36: {
                    break;
                }
                default: {
                    System.out.println("Invalid ID in cookie record: " + id);
                }
            }
        }
    }

    private final void readStructRecordItems(DataInputStream is, int id_length, int length_length) {
        int id = 0;
        boolean end_is = false;
        block8: while (!end_is) {
            id = this.readSequence(is, id_length);
            switch (id) {
                case 100000: {
                    end_is = true;
                    break;
                }
                case -123: {
                    break;
                }
                case -124: {
                    if (this.domains.size() <= 0) continue block8;
                    this.domains.remove(0);
                    break;
                }
                case 1: {
                    this.path = "";
                    DataInputStream di = this.readPayload(is, this.readSequence(is, length_length));
                    this.readDomainRecord(di);
                    break;
                }
                case 2: {
                    DataInputStream di = this.readPayload(is, this.readSequence(is, length_length));
                    this.readPathRecord(di);
                    break;
                }
                case 3: {
                    this.expires = 0;
                    this.lastused = 0;
                    this.name = "";
                    this.value = "";
                    this.secure = "FALSE";
                    DataInputStream di = this.readPayload(is, this.readSequence(is, length_length));
                    this.readCookieRecord(di);
                    String domain = "";
                    Enumeration e = this.domains.elements();
                    while (e.hasMoreElements()) {
                        domain = domain + "." + (String)e.nextElement();
                    }
                    domain = domain.substring(1);
                    Cookie cook = new Cookie();
                    String _expires = this.expires + "000";
                    cook.setDomain(domain);
                    cook.setPath(this.path);
                    cook.setSecure(this.secure);
                    cook.setExpires(_expires);
                    cook.setName(this.name);
                    cook.setValue(this.value);
                    Vector<Cookie> cookies = new Vector<Cookie>();
                    cookies.addElement(cook);
                    this.writeCookiesToXML(domain, cookies, this.dest);
                    this.path = "";
                    break;
                }
                default: {
                    System.out.println("Invalid ID in record: " + id);
                }
            }
        }
    }
}

