/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.util.Vector;
import org.media.mn8.protocol.http.DefaultAttributes;
import org.media.mn8.protocol.http.DefaultControl;

public class OptionControl
extends DefaultAttributes
implements DefaultControl {
    private static final String[] attrNames = new String[]{"selected", "disabled", "label", "value"};
    private String optValue;
    private String value;
    private String selected;
    private String attrList = "";

    public void setValue(String value) {
        this.value = value;
        this.attrList = this.attrList + this.getAttrPair("value", value);
    }

    public void setSelected(String sel) {
        this.selected = sel;
        this.attrList = this.attrList + this.getAttrPair("selected", sel);
    }

    public void setOptValue(String attr) {
        this.optValue = attr;
    }

    public boolean isSendable() {
        return true;
    }

    public String getName() {
        return null;
    }

    public Vector getValues() {
        Vector<String> result = new Vector<String>();
        result.add(this.value);
        return result;
    }

    public String toXMLString() {
        String ret = "<OPTION " + this.getAttrList().trim() + ">";
        if (this.optValue != null && this.optValue.trim().length() > 0) {
            ret = ret + "<![CDATA[ " + this.optValue + " ]]>";
        }
        ret = ret + "</OPTION>";
        return ret;
    }

    public String toString() {
        return "OPTION  : \n" + this.getAttrList().replace(' ', '\n') + "\nOPTVALUE: " + this.optValue;
    }

    public void parse(String tag) {
        super.parse(tag);
        if (tag == null || tag.trim().length() < 1) {
            return;
        }
        String attrs = this.getAttrsFromTag(tag);
        if (attrs.trim().length() > 0) {
            int i = 0;
            while (i < attrNames.length) {
                String value = super.getValueOf(attrs, attrNames[i]);
                if (value != null) {
                    if (attrNames[i].equals("value")) {
                        this.value = value;
                    }
                    if (attrNames[i].equals("selected")) {
                        this.selected = value;
                    }
                    this.attrList = this.attrList + this.getAttrPair(attrNames[i], value);
                }
                ++i;
            }
        }
        if (this.selected == null) {
            this.attrList = this.attrList + this.getAttrPair("selected", "false");
        }
    }

    public String getAttrList() {
        return this.attrList + super.getAttrList();
    }

    public String getControlType() {
        return "OPTION";
    }

    public boolean equals(DefaultControl control) {
        return true;
    }
}

