/*
 * Decompiled with CFR 0.152.
 */
package org.media.mn8.protocol.http;

import java.util.Enumeration;
import java.util.Vector;
import org.media.mn8.protocol.http.DefaultAttributes;
import org.media.mn8.protocol.http.DefaultControl;
import org.media.mn8.protocol.http.OptGroupControl;
import org.media.mn8.protocol.http.OptionControl;

public class SelectControl
extends DefaultAttributes
implements DefaultControl {
    private static final String[] attrNames = new String[]{"name", "size", "multiple", "disabled", "tabindex", "onfocus", "onblur", "onchange"};
    private String name;
    private String size;
    private String multiple;
    private Vector options = new Vector();
    private String attrList = "";

    public void setName(String name) {
        this.name = name;
        this.attrList = this.attrList + this.getAttrPair("name", name);
    }

    public boolean isSendable() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public Vector getValues() {
        Vector<String> result = new Vector<String>();
        Vector values = null;
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj instanceof OptGroupControl) {
                values = ((OptGroupControl)obj).getValues();
            } else if (obj instanceof OptionControl) {
                values = ((OptionControl)obj).getValues();
            }
            Enumeration e1 = values.elements();
            while (e1.hasMoreElements()) {
                String value = (String)e1.nextElement();
                result.add(value);
            }
        }
        return result;
    }

    public void setSize(String size) {
        this.size = size;
        this.attrList = this.attrList + this.getAttrPair("size", size);
    }

    public void setMultiple(String mtp) {
        this.multiple = mtp;
        this.attrList = this.attrList + this.getAttrPair("multiple", mtp);
    }

    public String toXMLString() {
        StringBuffer sb = new StringBuffer("<SELECT " + this.getAttrList().trim() + ">");
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj instanceof OptGroupControl) {
                sb.append("\n        " + ((OptGroupControl)obj).toXMLString());
            }
            if (!(obj instanceof OptionControl)) continue;
            sb.append("\n        " + ((OptionControl)obj).toXMLString());
        }
        sb.append("\n    </SELECT>");
        return sb.toString();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("SELECT : \n" + this.getAttrList().replace(' ', '\n'));
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj instanceof OptGroupControl) {
                ret.append("\n\n" + ((OptGroupControl)obj).toString());
            }
            if (!(obj instanceof OptionControl)) continue;
            ret.append("\n\n" + ((OptionControl)obj).toString());
        }
        return ret.toString();
    }

    public void parse(String tag) {
        super.parse(tag);
        if (tag == null || tag.trim().length() < 1) {
            return;
        }
        String attrs = this.getAttrsFromTag(tag);
        if (attrs.trim().length() > 0) {
            int i = 0;
            while (i < attrNames.length) {
                String value = super.getValueOf(attrs, attrNames[i]);
                if (value != null) {
                    if (attrNames[i].equals("name")) {
                        this.name = value;
                    }
                    if (attrNames[i].equals("size")) {
                        this.size = value;
                    }
                    if (attrNames[i].equals("multiple")) {
                        this.multiple = value;
                    }
                    this.attrList = this.attrList + this.getAttrPair(attrNames[i], value);
                }
                ++i;
            }
        }
        if (this.multiple == null) {
            this.attrList = this.attrList + this.getAttrPair("multiple", "false");
        }
    }

    public String getAttrList() {
        return this.attrList + super.getAttrList();
    }

    public void addOption(OptionControl opt) {
        this.options.addElement(opt);
    }

    public void addOptionGroup(OptGroupControl optGrp) {
        this.options.addElement(optGrp);
    }

    public String getControlType() {
        return "SELECT";
    }

    public boolean equals(DefaultControl control) {
        SelectControl scontrol = (SelectControl)control;
        if (scontrol.name != null && scontrol.name.equalsIgnoreCase(this.name)) {
            return true;
        }
        return scontrol.multiple != null && scontrol.multiple.equalsIgnoreCase(this.multiple);
    }
}

